/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.pane;

import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.gx.IPoint;
import javax.baja.gx.Point;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BButton;
import javax.baja.ui.BLabel;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BPicture;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BTransformMode;
import javax.baja.ui.pane.BPane;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="content", type="BWidget", defaultValue="new BNullWidget()"), @NiagaraProperty(name="transformMode", type="BTransformMode", defaultValue="BTransformMode.none")})
public class BTransformPane
extends BPane {
    @Generated
    public static final Property content = BTransformPane.newProperty((int)0, (BValue)new BNullWidget(), null);
    @Generated
    public static final Property transformMode = BTransformPane.newProperty((int)0, (BValue)BTransformMode.none, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BTransformPane.class);

    @Generated
    public BWidget getContent() {
        return (BWidget)this.get(content);
    }

    @Generated
    public void setContent(BWidget v) {
        this.set(content, (BValue)v, null);
    }

    @Generated
    public BTransformMode getTransformMode() {
        return (BTransformMode)this.get(transformMode);
    }

    @Generated
    public void setTransformMode(BTransformMode v) {
        this.set(transformMode, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void paint(Graphics g) {
        g.push();
        try {
            BTransform transform = this.getPaintTransform();
            g.transform(transform);
            this.paintChild(g, this.getContent());
        }
        finally {
            g.pop();
        }
    }

    @Override
    public void doLayout(BWidget[] children) {
        BWidget content = this.getContent();
        if (this.isSideways()) {
            content.setBounds(0.0, 0.0, this.getHeight(), this.getWidth());
        } else {
            content.setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void computePreferredSize() {
        BWidget c = this.getContent();
        c.computePreferredSize();
        if (this.isSideways()) {
            this.setPreferredSize(c.getPreferredHeight(), c.getPreferredWidth());
        } else {
            this.setPreferredSize(c.getPreferredWidth(), c.getPreferredHeight());
        }
    }

    public final boolean isChildLegal(BComponent child) {
        return child instanceof BPicture || child instanceof BLabel || child instanceof BButton || child instanceof BTransformPane || child instanceof BBinding;
    }

    @Override
    public void changed(Property prop, Context context) {
        if (prop.equals(transformMode)) {
            this.needsLayout();
        }
    }

    @Override
    public BWidget childAt(Point point) {
        Point result = new Point();
        this.getPaintTransform().getInverse().transform((IPoint)point, result);
        BWidget widget = super.childAt(result);
        return widget;
    }

    private BTransform getPaintTransform() {
        BTransformMode transformMode = this.getTransformMode();
        if (transformMode.equals((Object)BTransformMode.none)) {
            return BTransform.DEFAULT;
        }
        if (transformMode.equals((Object)BTransformMode.flip)) {
            return BTransform.make((BTransform.Transform[])new BTransform.Transform[]{new BTransform.Scale(1.0, -1.0), new BTransform.Translate(0.0, -this.getHeight())});
        }
        if (transformMode.equals((Object)BTransformMode.mirror)) {
            return BTransform.make((BTransform.Transform[])new BTransform.Transform[]{new BTransform.Scale(-1.0, 1.0), new BTransform.Translate(-this.getWidth(), 0.0)});
        }
        double degrees = transformMode.equals((Object)BTransformMode.rotate90) ? 90.0 : (transformMode.equals((Object)BTransformMode.rotate180) ? 180.0 : 270.0);
        double radians = degrees * Math.PI / 180.0;
        Point center = new Point(this.getWidth() / 2.0 * Math.cos(radians) - this.getHeight() / 2.0 * Math.sin(radians), this.getHeight() / 2.0 * Math.cos(radians) + this.getWidth() / 2.0 * Math.sin(radians));
        BWidget c = this.getContent();
        return BTransform.make((BTransform.Transform[])new BTransform.Transform[]{new BTransform.Translate(this.getWidth() / 2.0 - center.x, this.getHeight() / 2.0 - center.y), new BTransform.Rotate(degrees), new BTransform.Translate((this.getWidth() - c.getWidth()) / 2.0, (this.getHeight() - c.getHeight()) / 2.0)});
    }

    private boolean isSideways() {
        BTransformMode mode = this.getTransformMode();
        return mode.equals((Object)BTransformMode.rotate90) || mode.equals((Object)BTransformMode.rotate270);
    }
}

