/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import com.tridium.ui.CaretTracker;
import com.tridium.ui.theme.custom.nss.StyleUtils;
import javax.baja.gx.BInsets;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraTopic;
import javax.baja.nre.annotations.NiagaraTopics;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComplex;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.UndoManager;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BInputMethodEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.text.BTextEditorOptions;
import javax.baja.ui.text.Blinker;
import javax.baja.ui.text.Line;
import javax.baja.ui.text.Position;
import javax.baja.ui.text.TextCommandFactory;
import javax.baja.ui.text.TextController;
import javax.baja.ui.text.TextModel;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.text.TextRenderer;
import javax.baja.ui.text.TextSelection;
import javax.baja.ui.text.commands.RemoveText;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;

@NiagaraType
@NiagaraProperty(name="editable", type="boolean", defaultValue="true")
@NiagaraTopics(value={@NiagaraTopic(name="textModified", eventType="BWidgetEvent"), @NiagaraTopic(name="selectionModified", eventType="BWidgetEvent"), @NiagaraTopic(name="inputMethodEvent", eventType="BInputEvent")})
public class BTextEditor
extends BTransferWidget
implements UndoManager.Scope {
    public static final Property editable = BTextEditor.newProperty((int)0, (boolean)true, null);
    public static final Topic textModified = BTextEditor.newTopic((int)0, null);
    public static final Topic selectionModified = BTextEditor.newTopic((int)0, null);
    public static final Topic inputMethodEvent = BTextEditor.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType(BTextEditor.class);
    private static final BIcon icon = BIcon.std((String)"widgets/textEditor.png");
    private static BInsets insets = BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0);
    private TextModel model;
    private TextController controller;
    private TextRenderer renderer;
    private TextSelection selection;
    private TextParser parser;
    private TextCommandFactory commandFactory;
    private BTextEditorOptions options;
    private TextRenderer.LineInfo lineInfo = new TextRenderer.LineInfo();
    private Position caretPos = new Position(0, 0);
    private boolean caretVisible;
    private boolean firstPaint = true;
    private boolean allowCopying = true;
    private UndoManager undoManager = null;

    public boolean getEditable() {
        return this.getBoolean(editable);
    }

    public void setEditable(boolean v) {
        this.setBoolean(editable, v, null);
    }

    public void fireTextModified(BWidgetEvent event) {
        this.fire(textModified, (BValue)event, null);
    }

    public void fireSelectionModified(BWidgetEvent event) {
        this.fire(selectionModified, (BValue)event, null);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    public final void fireInputMethodEvent(BInputEvent event) {
        switch (event.getId()) {
            case 1101: {
                this.caretPositionChanged((BInputMethodEvent)event);
                break;
            }
            case 1100: {
                this.imTextChanged((BInputMethodEvent)event);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.fire(inputMethodEvent, (BValue)event, null);
    }

    public void caretPositionChanged(BInputMethodEvent event) {
        this.controller.caretPositionChanged(event);
    }

    public void imTextChanged(BInputMethodEvent event) {
        this.controller.imTextChanged(event);
    }

    public BTextEditor(String text, boolean editable) {
        this();
        this.setText(text);
        this.setEditable(editable);
        this.updateEnableStates();
    }

    public BTextEditor() {
        this.setModel(new TextModel());
        this.setController(new TextController());
        this.setRenderer(new TextRenderer());
        this.setParser(new TextParser());
        this.setCommandFactory(new TextCommandFactory());
        this.setSelection(new TextSelection());
        this.setOptions(BTextEditorOptions.make());
        this.updateEnableStates();
    }

    public TextModel getModel() {
        return this.model;
    }

    public void setModel(TextModel model) {
        this.installSupport(this.model, model);
        this.model = model;
    }

    public TextController getController() {
        return this.controller;
    }

    public void setController(TextController controller) {
        this.installSupport(this.controller, controller);
        this.controller = controller;
    }

    public TextParser getParser() {
        return this.parser;
    }

    public void setParser(TextParser parser) {
        this.installSupport(this.parser, parser);
        this.parser = parser;
    }

    public TextCommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public void setCommandFactory(TextCommandFactory commandFactory) {
        this.installSupport(this.commandFactory, commandFactory);
        this.commandFactory = commandFactory;
    }

    public TextSelection getSelection() {
        return this.selection;
    }

    public void setSelection(TextSelection selection) {
        this.installSupport(this.selection, selection);
        this.selection = selection;
    }

    public TextRenderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(TextRenderer renderer) {
        this.installSupport(this.renderer, renderer);
        this.renderer = renderer;
    }

    public BTextEditorOptions getOptions() {
        return this.options;
    }

    public void setOptions(BTextEditorOptions options) {
        if (options == null) {
            throw new NullPointerException();
        }
        this.options = options;
    }

    private void installSupport(TextSupport old, TextSupport support) {
        if (support == null) {
            throw new NullPointerException();
        }
        if (old == support) {
            return;
        }
        if (support.editor != null) {
            throw new IllegalArgumentException("Already installed on another text widget");
        }
        if (old != null) {
            old.editor = null;
        }
        support.editor = this;
    }

    public final boolean isEditable() {
        return this.getEditable();
    }

    public boolean isSingleLine() {
        return false;
    }

    public String getText() {
        return this.model.getText();
    }

    public void setText(String text) {
        this.model.setText(text);
    }

    public boolean getAllowCopying() {
        return this.allowCopying;
    }

    public void setAllowCopying(boolean allow) {
        this.allowCopying = allow;
    }

    public Position getCaretPosition() {
        return this.caretPos;
    }

    public void moveCaretPosition(Position pos) {
        BComplex grandparent;
        Position end = this.model.getEndPosition();
        if (pos.compareTo(end) > 0) {
            pos = end;
        }
        this.caretPos = pos;
        if (this.hasFocus()) {
            Blinker.pauseBlinking();
        }
        this.scrollToVisible(pos);
        BComplex parent = this.getParent();
        if (parent != null && (grandparent = parent.getParent()) instanceof CaretTracker) {
            ((CaretTracker)grandparent).caretMoved(pos);
        }
        this.repaint();
    }

    public boolean isCaretBlinking() {
        return this == Blinker.getBlinkingWidget();
    }

    public void setCaretBlinking(boolean blinking) {
        if (blinking) {
            Blinker.startBlinking(this);
        } else {
            Blinker.stopBlinking();
            this.caretVisible = false;
        }
        try {
            this.repaint();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    void blinkCaret(boolean visible) {
        this.caretVisible = visible;
        try {
            this.repaint();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public int getVisibleLineCount() {
        double h = this.getHeight();
        BWidget parent = this.getParentWidget();
        if (parent instanceof BScrollPane) {
            h = parent.getHeight() - 4.0;
        }
        return (int)(h / this.renderer.getLineHeight());
    }

    public void scrollToVisible(Position pos) {
        if (pos.line >= this.model.getLineCount()) {
            return;
        }
        Line line = this.model.getLine(pos.line);
        BInsets insets = this.getInsets();
        double lineHeight = this.renderer.getLineHeight();
        double colWidth = this.renderer.getColumnWidth(line, pos.column);
        double x = this.renderer.columnToX(line, pos.column) + insets.left;
        double y = lineHeight * (double)pos.line + insets.top;
        double w = colWidth;
        double h = this.renderer.getLineHeight() + insets.top;
        this.scrollToVisible(new RectGeom(x -= colWidth, y -= lineHeight, w += colWidth * 2.0, h += lineHeight * 2.0));
    }

    public Position getPositionAt(double x, double y) {
        BInsets insets = this.getInsets();
        int lineIndex = (int)Math.ceil((int)((y -= insets.top) / this.renderer.getLineHeight()));
        Line line = this.renderer.getModel().getLine(lineIndex);
        int col = this.renderer.xToColumn(line, x -= insets.left);
        return new Position(lineIndex, col);
    }

    @Override
    public void computePreferredSize() {
        BInsets insets = this.getInsets();
        double pw = this.model.getPreferredWidth() + insets.left + insets.right;
        double ph = this.model.getPreferredHeight() + insets.top + insets.bottom;
        this.setPreferredSize(pw, ph);
    }

    @Override
    public void doLayout(BWidget[] kids) {
    }

    protected BInsets getInsets() {
        return insets;
    }

    @Override
    public void paint(Graphics g) {
        int q;
        TextModel model = this.model;
        TextRenderer renderer = this.renderer;
        double lineCount = model.getLineCount();
        double lineHeight = renderer.getLineHeight();
        Position selStart = this.getSelection().getStart();
        Position selEnd = this.getSelection().getEnd();
        IRectGeom clip = g.getClipBounds();
        BInsets insets = this.getInsets();
        int visibleStart = Math.max(0, (int)((clip.y() - insets.top) / lineHeight));
        int visibleEnd = (int)Math.min(lineCount - 1.0, (double)((int)((clip.y() + clip.height() - insets.top) / lineHeight)));
        this.getRenderer().paintBackground(g);
        g.translate(insets.left, insets.top);
        int margin = this.getOptions().getShowMargin();
        if (margin > 0 && !this.isSingleLine()) {
            g.setBrush(this.getOptions().getColorCoding().getWhitespace());
            double marginX = (double)margin * renderer.getColumnWidth(null, 0);
            g.strokeLine(marginX, clip.y(), marginX, clip.y() + clip.height());
        }
        for (q = visibleStart; q <= visibleEnd; ++q) {
            Line line;
            this.lineInfo.line = line = model.getLine(q);
            this.lineInfo.lineIndex = q;
            this.lineInfo.selectionStartColumn = -1;
            this.lineInfo.selectionEndColumn = -1;
            if (selStart != null && selStart.line <= q && q <= selEnd.line) {
                this.lineInfo.selectionStartColumn = selStart.line == q ? selStart.column : 0;
                this.lineInfo.selectionEndColumn = selEnd.line == q ? selEnd.column : Integer.MAX_VALUE;
            }
            g.translate(0.0, (double)q * lineHeight);
            renderer.paintLine(g, this.lineInfo);
            g.translate(0.0, (double)(-q) * lineHeight);
        }
        if (this.caretVisible) {
            q = this.caretPos.line;
            this.lineInfo.line = model.getLine(q);
            this.lineInfo.lineIndex = q;
            this.lineInfo.selectionStartColumn = -1;
            this.lineInfo.selectionEndColumn = -1;
            g.translate(0.0, (double)q * lineHeight);
            renderer.paintCaret(g, this.lineInfo, this.caretPos.column);
            g.translate(0.0, (double)(-q) * lineHeight);
        }
        g.translate(-insets.left, -insets.top);
    }

    @Override
    public String getStyleSelector() {
        return "text-editor";
    }

    @Override
    public boolean isFocusTraversable() {
        return this.controller.isFocusTraversable();
    }

    @Override
    public void focusGained(BFocusEvent event) {
        this.controller.focusGained(event);
        this.scrollToVisible(this.caretPos);
    }

    @Override
    public void focusLost(BFocusEvent event) {
        this.controller.focusLost(event);
    }

    @Override
    public void keyPressed(BKeyEvent event) {
        this.controller.keyPressed(event);
    }

    @Override
    public void keyReleased(BKeyEvent event) {
        this.controller.keyReleased(event);
    }

    @Override
    public void keyTyped(BKeyEvent event) {
        this.controller.keyTyped(event);
    }

    @Override
    public void fireKeyEvent(BKeyEvent event) {
        switch (event.getId()) {
            case 401: {
                this.keyPressed(event);
                break;
            }
            case 402: {
                this.keyReleased(event);
                break;
            }
            case 400: {
                this.keyTyped(event);
            }
        }
        this.fire(keyEvent, (BValue)event, null);
    }

    @Override
    public void mousePressed(BMouseEvent event) {
        this.controller.mousePressed(event);
    }

    @Override
    public void mouseReleased(BMouseEvent event) {
        this.controller.mouseReleased(event);
    }

    @Override
    public void mouseEntered(BMouseEvent event) {
        this.controller.mouseEntered(event);
    }

    @Override
    public void mouseExited(BMouseEvent event) {
        this.controller.mouseExited(event);
    }

    @Override
    public void mouseMoved(BMouseEvent event) {
        this.controller.mouseMoved(event);
    }

    @Override
    public void mouseDragged(BMouseEvent event) {
        this.controller.mouseDragged(event);
    }

    @Override
    public void mousePulsed(BMouseEvent event) {
        this.controller.mousePulsed(event);
    }

    @Override
    public void changed(Property prop, Context cx) {
        if (prop == null) {
            this.updateEnableStates();
        } else if (prop == editable) {
            StyleUtils.toggleStyleClass(this, "readonly", !this.getEditable());
        } else if (prop == enabled) {
            StyleUtils.toggleStyleClass(this, "disabled", !this.isEnabled());
        }
        this.repaint();
    }

    public void updateEnableStates() {
        boolean editable = this.getEditable();
        boolean hasSelection = !this.selection.isEmpty();
        this.setCopyEnabled(this.getAllowCopying() && hasSelection);
        this.setCutEnabled(this.getAllowCopying() && editable && hasSelection);
        this.setPasteEnabled(editable);
        this.setDeleteEnabled(editable && hasSelection);
    }

    public void updateAnchorX() {
        this.updateAnchorX(this.getCaretPosition());
    }

    public void updateAnchorX(Position newPos) {
        TextModel model = this.getModel();
        Line curLine = model.getLine(newPos.line);
        model.setAnchorX(this.getRenderer().columnToX(curLine, newPos.column));
    }

    public CommandArtifact doFind() throws Exception {
        return this.commandFactory.make("find").doInvoke();
    }

    public CommandArtifact doFindPrev() throws Exception {
        return this.commandFactory.make("findPrev").doInvoke();
    }

    public CommandArtifact doFindNext() throws Exception {
        return this.commandFactory.make("findNext").doInvoke();
    }

    public CommandArtifact doReplace() throws Exception {
        return this.commandFactory.make("replace").doInvoke();
    }

    public CommandArtifact doGoto() throws Exception {
        return this.commandFactory.make("goTo").doInvoke();
    }

    @Override
    public CommandArtifact doDelete() throws Exception {
        return new RemoveText(this).doInvoke();
    }

    @Override
    public TransferEnvelope getTransferData() throws Exception {
        String text = this.getModel().getSelectedText();
        return TransferEnvelope.make(text);
    }

    @Override
    public CommandArtifact removeTransferData(TransferContext cx) throws Exception {
        return new RemoveText(this).doInvoke();
    }

    @Override
    public CommandArtifact insertTransferData(TransferContext cx) throws Exception {
        String text = (String)cx.getEnvelope().getData(TransferFormat.string);
        return this.getController().doInsertText(text);
    }

    @Override
    public BIcon getIcon() {
        return icon;
    }

    @Override
    public UndoManager getInstalledUndoManager() {
        return this.undoManager;
    }

    @Override
    public void setInstalledUndoManager(UndoManager undoManager) {
        this.undoManager = undoManager;
    }

    public static abstract class TextSupport {
        BTextEditor editor;

        public final BTextEditor getEditor() {
            return this.editor;
        }

        public TextModel getModel() {
            return this.editor.model;
        }

        public TextController getController() {
            return this.editor.controller;
        }

        public TextRenderer getRenderer() {
            return this.editor.renderer;
        }

        public TextSelection getSelection() {
            return this.editor.selection;
        }

        public BTextEditorOptions getOptions() {
            return this.editor.options;
        }

        public TextParser getParser() {
            return this.editor.parser;
        }

        public TextCommandFactory getCommandFactory() {
            return this.editor.commandFactory;
        }

        public BWidgetShell getShell() {
            return this.editor.getShell();
        }
    }
}

