/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text;

import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.Position;

public class TextSelection
extends BTextEditor.TextSupport {
    private Position anchor;
    private Position lead;
    private Position start;
    private Position end;

    public boolean isEmpty() {
        return this.anchor == null || this.lead == null || this.anchor.equals(this.lead);
    }

    public Position getAnchor() {
        return this.anchor;
    }

    public Position getLead() {
        return this.lead;
    }

    public Position getStart() {
        return this.start;
    }

    public Position getEnd() {
        return this.end;
    }

    public void select(Position anchor, Position lead) {
        this.anchor = anchor;
        this.lead = lead;
        if (anchor.compareTo(lead) < 0) {
            this.start = anchor;
            this.end = lead;
        } else {
            this.start = lead;
            this.end = anchor;
        }
        this.getEditor().moveCaretPosition(lead);
        this.updateEditor();
    }

    public void selectAll() {
        Position docEnd;
        Position docStart = this.getModel().getStartPosition();
        if (docStart.equals(docEnd = this.getModel().getEndPosition())) {
            return;
        }
        this.anchor = this.start = docStart;
        this.lead = this.end = docEnd;
        this.getEditor().moveCaretPosition(this.start);
        this.updateEditor();
    }

    public void deselect() {
        if (this.anchor != null) {
            this.end = null;
            this.start = null;
            this.lead = null;
            this.anchor = null;
            this.updateEditor();
        }
    }

    public void updateEditor() {
        BTextEditor editor = this.getEditor();
        editor.updateEnableStates();
        editor.repaint();
        editor.fireSelectionModified(new BWidgetEvent(1, this.getEditor()));
    }
}

