/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.text.parsers;

import javax.baja.ui.text.Segment;
import javax.baja.ui.text.TextParser;

public class PythonParser
extends TextParser {
    @Override
    protected Segment nextSegment() {
        Segment whitespace = this.parseWhitespace();
        if (whitespace != null) {
            return whitespace;
        }
        int c = this.current;
        if (c == 123 || c == 125 || c == 40 || c == 41 || c == 91 || c == 93) {
            this.advance();
            return this.newSegment(8);
        }
        if (Character.isJavaIdentifierStart((char)c)) {
            Segment id = this.parseIdentifier();
            if (this.isKeyword(id)) {
                return new Segment(6, 8, id.offset, id.length);
            }
            return id;
        }
        if (c == 35) {
            this.advance();
            return this.newSegment(10);
        }
        if (!(c != 34 && c != 39 || this.last == 92 && this.lastLast != 92)) {
            this.advance();
            return this.newSegment(9);
        }
        if (48 <= c && c <= 57 || c == 45 && 48 <= this.next && this.next <= 57) {
            return this.parseNumberLiteral();
        }
        this.advance();
        while (this.isSymbol(this.current) && this.advance()) {
        }
        return this.newSegment(0);
    }

    private Segment parseIdentifier() {
        while (Character.isJavaIdentifierPart((char)this.current)) {
            this.advance();
        }
        return this.newSegment(5, 8);
    }

    private boolean isKeyword(Segment seg) {
        switch (this.buffer[this.segmentStart]) {
            case 'a': {
                if (this.isKeyword(seg, "and")) {
                    return true;
                }
                return this.isKeyword(seg, "assert");
            }
            case 'b': {
                return this.isKeyword(seg, "break");
            }
            case 'c': {
                if (this.isKeyword(seg, "class")) {
                    return true;
                }
                return this.isKeyword(seg, "continue");
            }
            case 'd': {
                if (this.isKeyword(seg, "def")) {
                    return true;
                }
                return this.isKeyword(seg, "del");
            }
            case 'e': {
                if (this.isKeyword(seg, "elif")) {
                    return true;
                }
                if (this.isKeyword(seg, "else")) {
                    return true;
                }
                if (this.isKeyword(seg, "except")) {
                    return true;
                }
                return this.isKeyword(seg, "exec");
            }
            case 'f': {
                if (this.isKeyword(seg, "finally")) {
                    return true;
                }
                if (this.isKeyword(seg, "from")) {
                    return true;
                }
                return this.isKeyword(seg, "for");
            }
            case 'g': {
                return this.isKeyword(seg, "global");
            }
            case 'i': {
                if (this.isKeyword(seg, "if")) {
                    return true;
                }
                if (this.isKeyword(seg, "import")) {
                    return true;
                }
                if (this.isKeyword(seg, "in")) {
                    return true;
                }
                return this.isKeyword(seg, "is");
            }
            case 'l': {
                return this.isKeyword(seg, "lambda");
            }
            case 'n': {
                return this.isKeyword(seg, "not");
            }
            case 'o': {
                return this.isKeyword(seg, "or");
            }
            case 'p': {
                if (this.isKeyword(seg, "pass")) {
                    return true;
                }
                return this.isKeyword(seg, "print");
            }
            case 'r': {
                if (this.isKeyword(seg, "raise")) {
                    return true;
                }
                return this.isKeyword(seg, "return");
            }
            case 't': {
                return this.isKeyword(seg, "try");
            }
            case 'w': {
                return this.isKeyword(seg, "while");
            }
            case 'y': {
                return this.isKeyword(seg, "yield");
            }
        }
        return false;
    }

    private boolean isKeyword(Segment seg, String s) {
        int len = seg.length;
        if (len != s.length()) {
            return false;
        }
        char[] buf = this.buffer;
        int start = this.segmentStart;
        for (int i = 1; i < len; ++i) {
            if (s.charAt(i) == buf[start + i]) continue;
            return false;
        }
        return true;
    }

    private Segment parseNumberLiteral() {
        int c;
        this.advance();
        if (this.last == 48 && (this.current == 120 || this.current == 88)) {
            this.advance();
        }
        while (48 <= (c = this.current) && c <= 57 || 97 <= c && c <= 102 || 65 <= c && c <= 70 || c == 108 || c == 76 || c == 46 || c == 45 && this.last == 101) {
            this.advance();
        }
        return this.newSegment(4, 8);
    }

    private boolean isSymbol(int c) {
        switch (c) {
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 43: 
            case 44: 
            case 46: 
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 92: 
            case 94: 
            case 95: 
            case 124: 
            case 126: {
                return true;
            }
        }
        return false;
    }
}

