/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.transfer;

import javax.baja.space.Mark;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.transfer.UnsupportedFormatException;

public final class TransferEnvelope {
    private TransferFormat[] formats;
    private Object[] data;

    public static TransferEnvelope make(String string) {
        return new TransferEnvelope(new TransferFormat[]{TransferFormat.string}, new Object[]{string});
    }

    public static TransferEnvelope make(Mark mark) {
        return new TransferEnvelope(new TransferFormat[]{TransferFormat.mark, TransferFormat.string}, new Object[]{mark, mark.toStringFormat()});
    }

    private TransferEnvelope(TransferFormat[] formats, Object[] data) {
        this.formats = formats;
        this.data = data;
    }

    public final boolean supports(TransferFormat format) {
        for (int i = 0; i < this.formats.length; ++i) {
            if (!this.formats[i].equals(format)) continue;
            return true;
        }
        return false;
    }

    public final TransferFormat[] getFormats() {
        return (TransferFormat[])this.formats.clone();
    }

    public final Object getData(TransferFormat format) {
        for (int i = 0; i < this.formats.length; ++i) {
            if (!this.formats[i].equals(format)) continue;
            return this.data[i];
        }
        throw new UnsupportedFormatException(format.toString());
    }
}

