/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.ui.tree;

import com.tridium.ui.theme.Theme;
import com.tridium.ui.theme.TreeTheme;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.gx.IRectGeom;
import javax.baja.gx.RectGeom;
import javax.baja.gx.Size;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNodeRenderer;

public abstract class TreeNode {
    private static final double MARGIN = 10.0;
    private TreeModel model;
    private TreeNode parent;
    private double x;
    private double y;
    private boolean isTop = true;
    private boolean isLast = true;
    private double height;
    private double expanderX;
    private double expanderWidth;
    private double expanderY;
    private double expanderHeight;
    private double nodeX;
    private double nodeY;
    private boolean expanded = false;
    private boolean selected = false;
    private boolean focus = false;
    private boolean mouseOver = false;

    public TreeNode(TreeModel model, TreeNode parent) {
        this.model = model;
        this.parent = parent;
    }

    public TreeNode(TreeModel model) {
        this.model = model;
    }

    public TreeNode(TreeNode parent) {
        this.parent = parent;
    }

    public TreeModel getModel() {
        TreeNode parent;
        if (this.model == null && (parent = this.getParent()) != null) {
            this.model = parent.getModel();
        }
        return this.model;
    }

    public BTree getTree() {
        return this.getModel().getTree();
    }

    public BWidgetShell getShell() {
        BTree tree = this.getTree();
        if (tree != null) {
            return tree.getShell();
        }
        return null;
    }

    public abstract String getText();

    public String toString() {
        return this.getText();
    }

    public abstract BImage getIcon();

    public boolean isLeaf() {
        return !this.hasChildren();
    }

    public boolean hasChildren() {
        return this.getChildCount() != 0;
    }

    public abstract int getChildCount();

    public abstract TreeNode getChild(int var1);

    public int getChildIndex(TreeNode child) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            if (this.getChild(i) != child) continue;
            return i;
        }
        return -1;
    }

    public Object getSubject() {
        return this.getText();
    }

    public TreeNode getParent() {
        return this.parent;
    }

    public boolean isDescendantOf(TreeNode ancestor) {
        TreeNode parent;
        for (parent = this.getParent(); parent != null && parent != ancestor; parent = parent.getParent()) {
        }
        return parent == ancestor;
    }

    public TreeNode[] getPathFromRoot() {
        ArrayList<TreeNode> temp = new ArrayList<TreeNode>(4);
        temp.add(this);
        for (TreeNode parent = this.getParent(); parent != null; parent = parent.getParent()) {
            temp.add(parent);
        }
        int count = temp.size();
        TreeNode[] path = new TreeNode[count];
        for (int i = 0; i < count; ++i) {
            path[i] = (TreeNode)temp.get(count - i - 1);
        }
        return path;
    }

    public boolean isValid() {
        TreeNode child = this;
        TreeNode parent = child.getParent();
        while (parent != null) {
            if (parent.getChildIndex(this) == -1) {
                return false;
            }
            child = parent;
            parent = child.getParent();
        }
        return this.model.getRootIndex(child) != -1;
    }

    public final void setExpanded(boolean expanded) {
        this.expanded = expanded;
        if (this.expanded) {
            this.expanded();
        } else {
            this.collapsed();
        }
    }

    public final boolean isExpanded() {
        return this.expanded;
    }

    public void expanded() {
    }

    public void collapsed() {
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean s) {
        this.selected = s;
    }

    public boolean hasFocus() {
        return this.focus;
    }

    void setFocus(boolean f) {
        this.focus = f;
    }

    public boolean isMouseOver() {
        return this.mouseOver;
    }

    public void setMouseOver(boolean over) {
        this.mouseOver = over;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    double layout(double x, double y, boolean isTop, boolean isLast, ArrayList<TreeNode> visibleNodes, Size prefSize) {
        this.x = x;
        this.y = y;
        this.isTop = isTop;
        this.isLast = isLast;
        visibleNodes.add(this);
        BTree tree = this.getTree();
        if (tree == null) {
            System.out.println("ERROR: TreeNode.layout no tree: " + this.getClass().getName());
            return 0.0;
        }
        TreeTheme theme = Theme.tree();
        TreeNodeRenderer renderer = tree.getNodeRenderer();
        double nodeHeight = renderer.getHeight();
        this.height = this.getTree().getRowHeight();
        this.expanderWidth = theme.getExpanderWidth();
        this.expanderHeight = theme.getExpanderHeight();
        this.expanderX = x;
        this.expanderY = y + (this.height - this.expanderHeight) / 2.0;
        this.nodeX = this.expanderX + this.expanderWidth + 10.0;
        this.nodeY = y + (this.height - nodeHeight) / 2.0;
        y += this.height;
        if (this.expanded) {
            RectGeom visRect = null;
            if (this.getTree().widgetSupport(this) != null) {
                visRect = new RectGeom(0.0, y - this.height, this.getTree().getWidth(), this.height);
            }
            double childX = this.nodeX + (renderer.getIconWidth() - this.expanderWidth) / 2.0;
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                y = this.getChild(i).layout(childX, y, false, i == childCount - 1, visibleNodes, prefSize);
            }
            if (visRect != null) {
                visRect.height = y - visRect.y;
                this.getTree().widgetSupport(visRect);
            }
        }
        prefSize.width = Math.max(prefSize.width, this.nodeX + renderer.getWidth(this));
        return y;
    }

    public boolean inExpander(double x, double y) {
        return Theme.tree().inExpander(this.expanderX, this.expanderY, x, y);
    }

    public boolean isSelection(double x, double y) {
        BTree tree = this.getTree();
        TreeNodeRenderer renderer = tree.getNodeRenderer();
        double nodeWidth = renderer.getWidth(this);
        return x >= this.nodeX && x <= this.nodeX + nodeWidth;
    }

    public double getWidth() {
        return this.expanderWidth + 10.0 + this.getTree().getNodeRenderer().getWidth(this);
    }

    double paint(Graphics g, double prevY) {
        try {
            TreeTheme theme = Theme.tree();
            TreeNodeRenderer renderer = this.getTree().getNodeRenderer();
            renderer.paintNode(g, this, this.nodeX, this.nodeY);
            boolean leaf = this.isLeaf();
            if (!leaf) {
                theme.paintExpander(g, this.getTree(), this.expanderX, this.expanderY, this.expanded);
            }
            if (this.expanded) {
                IRectGeom clip = g.getClipBounds();
                double viewTop = clip.y();
                double viewBottom = clip.y() + clip.height();
                prevY = this.y + this.height;
                int childCount = this.getChildCount();
                boolean belowBottom = false;
                for (int i = 0; i < childCount; ++i) {
                    TreeNode nextChild;
                    TreeNode thisChild = this.getChild(i);
                    if (thisChild.getY() > viewBottom) {
                        if (belowBottom) break;
                        belowBottom = true;
                    }
                    TreeNode treeNode = nextChild = i == childCount - 1 ? null : this.getChild(i + 1);
                    if (nextChild != null && nextChild.getY() <= viewTop) continue;
                    prevY = this.getChild(i).paint(g, prevY);
                }
            }
            return this.y + this.height;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return this.y + this.height;
        }
    }
}

