/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.test.diagnostics;

import com.tridium.nre.diagnostics.DiagnosticStats;
import com.tridium.test.diagnostics.BDiagnosticManager;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="functionName", type="String", defaultValue=""), @NiagaraProperty(name="key", type="String", defaultValue=""), @NiagaraProperty(name="lastDuration", type="double", defaultValue="0", flags=67, facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"millisecond\")")}), @NiagaraProperty(name="totalTimeDisplay", type="BRelTime", defaultValue="BRelTime.DEFAULT", flags=67, facets={@Facet(name="BFacets.SHOW_MILLISECONDS", value="true"), @Facet(name="BFacets.FIELD_EDITOR", value="\"workbench:ToStringFE\"")}), @NiagaraProperty(name="totalTime", type="double", defaultValue="0", flags=67, facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"millisecond\")")}), @NiagaraProperty(name="avgPerCall", type="double", defaultValue="0", flags=67, facets={@Facet(name="BFacets.UNITS", value="BUnit.getUnit(\"millisecond\")")}), @NiagaraProperty(name="callCount", type="long", defaultValue="0", flags=67)})
public final class BDiagnosticStat
extends BComponent {
    @Generated
    public static final Property functionName = BDiagnosticStat.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property key = BDiagnosticStat.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property lastDuration = BDiagnosticStat.newProperty((int)67, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    @Generated
    public static final Property totalTimeDisplay = BDiagnosticStat.newProperty((int)67, (BValue)BRelTime.DEFAULT, (BFacets)BFacets.make((BFacets)BFacets.make((String)"showMilliseconds", (boolean)true), (BFacets)BFacets.make((String)"fieldEditor", (String)"workbench:ToStringFE")));
    @Generated
    public static final Property totalTime = BDiagnosticStat.newProperty((int)67, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    @Generated
    public static final Property avgPerCall = BDiagnosticStat.newProperty((int)67, (int)0, (BFacets)BFacets.make((String)"units", (BIDataValue)BUnit.getUnit((String)"millisecond")));
    @Generated
    public static final Property callCount = BDiagnosticStat.newProperty((int)67, (int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BDiagnosticStat.class);
    private static double CONVERT_TO_MILLIS = 1000000.0;

    @Generated
    public String getFunctionName() {
        return this.getString(functionName);
    }

    @Generated
    public void setFunctionName(String v) {
        this.setString(functionName, v, null);
    }

    @Generated
    public String getKey() {
        return this.getString(key);
    }

    @Generated
    public void setKey(String v) {
        this.setString(key, v, null);
    }

    @Generated
    public double getLastDuration() {
        return this.getDouble(lastDuration);
    }

    @Generated
    public void setLastDuration(double v) {
        this.setDouble(lastDuration, v, null);
    }

    @Generated
    public BRelTime getTotalTimeDisplay() {
        return (BRelTime)this.get(totalTimeDisplay);
    }

    @Generated
    public void setTotalTimeDisplay(BRelTime v) {
        this.set(totalTimeDisplay, (BValue)v, null);
    }

    @Generated
    public double getTotalTime() {
        return this.getDouble(totalTime);
    }

    @Generated
    public void setTotalTime(double v) {
        this.setDouble(totalTime, v, null);
    }

    @Generated
    public double getAvgPerCall() {
        return this.getDouble(avgPerCall);
    }

    @Generated
    public void setAvgPerCall(double v) {
        this.setDouble(avgPerCall, v, null);
    }

    @Generated
    public long getCallCount() {
        return this.getLong(callCount);
    }

    @Generated
    public void setCallCount(long v) {
        this.setLong(callCount, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void changed(Property prop, Context cx) {
        BComplex c;
        if (!this.isRunning()) {
            return;
        }
        if ((prop.equals(functionName) || prop.equals(key)) && (c = this.getParent()) instanceof BDiagnosticManager) {
            ((BDiagnosticManager)c).poll();
        }
    }

    public BPermissions getPermissions(Context cx) {
        if (cx != null && cx.getUser() != null && !cx.getUser().getPermissions().isSuperUser()) {
            return BPermissions.DEFAULT;
        }
        return super.getPermissions(cx);
    }

    public void copyFrom(DiagnosticStats.KeyStat keyStat) {
        if (keyStat != null) {
            double totalMsTime = (double)keyStat.getTotalTime() / CONVERT_TO_MILLIS;
            this.setTotalTime(totalMsTime);
            this.setTotalTimeDisplay(BRelTime.make((long)((long)totalMsTime)));
            this.setAvgPerCall(totalMsTime / (double)keyStat.getCallCount());
            this.setCallCount(keyStat.getCallCount());
            this.setLastDuration((double)keyStat.getLastDuration() / CONVERT_TO_MILLIS);
        } else {
            this.setTotalTime(0.0);
            this.setTotalTimeDisplay(BRelTime.DEFAULT);
            this.setAvgPerCall(0.0);
            this.setCallCount(0L);
            this.setLastDuration(0.0);
        }
    }

    public void copyFrom(DiagnosticStats stat) {
        if (stat != null) {
            double totalMsTime = stat.getTotalTime() / CONVERT_TO_MILLIS;
            this.setTotalTime(totalMsTime);
            this.setTotalTimeDisplay(BRelTime.make((long)((long)totalMsTime)));
            this.setAvgPerCall(totalMsTime / (double)stat.getFunctionCalls());
            this.setCallCount(stat.getFunctionCalls());
            this.setLastDuration(stat.getLastDuration() / CONVERT_TO_MILLIS);
        } else {
            this.copyFrom((DiagnosticStats.KeyStat)null);
        }
    }
}

