/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.testng;

import com.tridium.testng.ConfigurationFailureListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.function.RunnableCanThrowException;
import javax.baja.nre.util.KeyValueTuple;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.test.BTestNg;
import org.testng.Assert;
import org.testng.annotations.Listeners;

@NiagaraType
@Listeners(value={ConfigurationFailureListener.class})
public abstract class BTridiumTestNg
extends BTestNg {
    @Generated
    public static final Type TYPE = Sys.loadType(BTridiumTestNg.class);

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public static <T> Object[][] toDataProviderArray(Iterable<T> i) {
        return BTridiumTestNg.toDataProviderArray(StreamSupport.stream(i.spliterator(), false));
    }

    public static <T> Object[][] toDataProviderArray(Stream<T> values) {
        return (Object[][])values.collect(Stream::builder, (builder, s) -> builder.accept(new Object[]{s}), (builder1, builder2) -> builder2.build().forEach(builder1::add)).build().toArray(x$0 -> new Object[x$0][]);
    }

    @SafeVarargs
    public static <T> Object[][] toDataProviderArray(T ... v) {
        Object[][] result = new Object[v.length][1];
        for (int i = 0; i < v.length; ++i) {
            result[i] = new Object[]{v[i]};
        }
        return result;
    }

    public static <T> Object[][] toDataProviderArray(Iterable<T> inputValues, TestMethodSignature signature, TestCaseProcessor<T> processor) {
        return StreamSupport.stream(inputValues.spliterator(), false).collect(() -> new DataProviderResults(signature), (testCaseValues, t) -> processor.processInputValue(testCaseValues::add, testCaseValues::newCase, t), DataProviderResults::combine).toArray();
    }

    public static <E extends Exception> void verifyUnsupported(RunnableCanThrowException<E> method, String message) throws E {
        BTridiumTestNg.verifyException(method, UnsupportedOperationException.class, message);
    }

    public static <E extends Exception> void verifyIllegalArgument(RunnableCanThrowException<E> method, String message) throws E {
        BTridiumTestNg.verifyException(method, IllegalArgumentException.class, message);
    }

    public static <U extends Exception, E extends Exception> void verifyException(RunnableCanThrowException<U> method, Class<E> expectedExceptionClass, String message) throws U {
        try {
            method.run();
            Assert.fail(message);
        }
        catch (Throwable t) {
            if (expectedExceptionClass.isAssignableFrom(t.getClass())) {
                Assert.assertTrue(true, message);
                return;
            }
            throw t;
        }
    }

    public static class TestCase {
        private final TestMethodSignature signature;
        private final Object[] parameterValues;

        public TestCase(TestMethodSignature signature) {
            Objects.requireNonNull(signature);
            this.signature = signature;
            this.parameterValues = new Object[signature.size()];
        }

        public <T> TestCase set(String parameterName, T parameterValue) {
            Objects.requireNonNull(parameterName);
            if (parameterValue != null && !this.signature.parameterType(parameterName).isAssignableFrom(parameterValue.getClass())) {
                throw new ClassCastException("cannot assign " + parameterValue.getClass().getName() + " to " + this.signature.parameterType(parameterName).getName());
            }
            this.parameterValues[this.signature.parameterIndex((String)parameterName)] = parameterValue;
            return this;
        }

        public Object get(String parameterName) {
            return this.parameterValues[this.signature.parameterIndex(parameterName)];
        }

        public Object[] values() {
            return this.parameterValues;
        }

        public TestCase newCopy() {
            TestCase result = new TestCase(this.signature);
            System.arraycopy(this.parameterValues, 0, result.parameterValues, 0, this.parameterValues.length);
            return result;
        }
    }

    public static class TestMethodSignature {
        private final Map<String, Integer> parameterIndices = new HashMap<String, Integer>();
        private final KeyValueTuple<String, Class<?>>[] parameterTuples;

        @SafeVarargs
        public TestMethodSignature(KeyValueTuple<String, Class<?>> ... parameterTuples) {
            this.parameterTuples = parameterTuples;
            for (int i = 0; i < parameterTuples.length; ++i) {
                if (this.parameterIndices.containsKey(parameterTuples[i].key)) {
                    throw new IllegalArgumentException("Duplicate parameter name: " + (String)parameterTuples[i].key);
                }
                this.parameterIndices.put((String)parameterTuples[i].key, i);
            }
        }

        public Class<?> parameterType(String parameterName) {
            return (Class)this.parameterTuples[this.parameterIndex((String)parameterName)].value;
        }

        public KeyValueTuple<String, Class<?>>[] parameterTuples() {
            return Arrays.copyOf(this.parameterTuples, this.parameterTuples.length);
        }

        public boolean hasParameter(String parameterName) {
            return this.parameterIndices.containsKey(parameterName);
        }

        public int parameterIndex(String parameterName) {
            Integer parameterIndex = this.parameterIndices.get(parameterName);
            if (parameterIndex == null) {
                throw new IllegalArgumentException("parameter " + parameterName + " not declared");
            }
            return parameterIndex;
        }

        public Collection<String> parameterNames() {
            return new ArrayList<String>(this.parameterIndices.keySet());
        }

        public int size() {
            return this.parameterIndices.size();
        }

        public boolean equals(Object o) {
            return o instanceof TestMethodSignature && Arrays.equals(((TestMethodSignature)o).parameterTuples, this.parameterTuples) && Objects.equals(((TestMethodSignature)o).parameterIndices, this.parameterIndices);
        }

        public int hashCode() {
            return Objects.hash(this.parameterIndices, Arrays.hashCode(this.parameterTuples));
        }
    }

    public static class DataProviderResults {
        private final TestMethodSignature signature;
        private final List<TestCase> cases = new ArrayList<TestCase>();

        @SafeVarargs
        public DataProviderResults(KeyValueTuple<String, Class<?>> ... parameterTuples) {
            this(new TestMethodSignature(parameterTuples));
        }

        public DataProviderResults(TestMethodSignature signature) {
            this.signature = signature;
        }

        public <T> DataProviderResults(String parameterName, T parameterValue) {
            this(new TestMethodSignature(new KeyValueTuple((Object)parameterName, parameterValue.getClass())));
            this.add(this.newCase().set(parameterName, parameterValue));
        }

        public <T> DataProviderResults(String parameterName, Iterable<T> parameterValues) {
            this(parameterName, StreamSupport.stream(parameterValues.spliterator(), false));
        }

        public <T> DataProviderResults(String parameterName, Stream<T> parameterValues) {
            boolean first = true;
            Iterator iterator = parameterValues.iterator();
            if (!iterator.hasNext()) {
                throw new IllegalStateException("Parameter values stream is empty");
            }
            Object value = iterator.next();
            this.signature = new TestMethodSignature(new KeyValueTuple((Object)parameterName, value.getClass()));
            this.add(this.newCase().set(parameterName, value));
            iterator.forEachRemaining(remainingValue -> this.add(this.newCase().set(parameterName, remainingValue)));
        }

        public DataProviderResults add(TestCase testCase) {
            Objects.requireNonNull(testCase);
            if (testCase.signature.equals(this.signature)) {
                this.cases.add(testCase);
                return this;
            }
            throw new IllegalArgumentException("declarations do not agree");
        }

        public TestCase newCase() {
            return new TestCase(this.signature);
        }

        public Object[][] toArray() {
            Object[][] result = new Object[this.cases.size()][this.signature.size()];
            for (int i = 0; i < this.cases.size(); ++i) {
                result[i] = this.cases.get(i).values();
            }
            return result;
        }

        public void combine(DataProviderResults combine) {
            if (!combine.signature.equals(this.signature)) {
                throw new IllegalArgumentException("declarations do not agree");
            }
            this.cases.addAll(combine.cases);
        }

        public <P> void setParameterValues(String parameterName, Iterable<P> parameterValues) {
            Objects.requireNonNull(parameterName);
            Objects.requireNonNull(parameterValues);
            ArrayList<TestCase> casesToAdd = new ArrayList<TestCase>();
            if (this.cases.size() == 0) {
                for (P parameterValue : parameterValues) {
                    TestCase caseToUpdate = this.newCase();
                    casesToAdd.add(caseToUpdate);
                    caseToUpdate.set(parameterName, parameterValue);
                }
            } else {
                for (TestCase existingCase : this.cases) {
                    boolean firstParameter = true;
                    for (P parameterValue : parameterValues) {
                        TestCase caseToUpdate;
                        if (firstParameter) {
                            caseToUpdate = existingCase;
                            firstParameter = false;
                        } else {
                            caseToUpdate = existingCase.newCopy();
                            casesToAdd.add(caseToUpdate);
                        }
                        caseToUpdate.set(parameterName, parameterValue);
                    }
                }
            }
            this.cases.addAll(casesToAdd);
        }

        public <P> void setParameterValues(String parameterName, Function<TestCase, Iterable<P>> valuesFunction) {
            Objects.requireNonNull(parameterName);
            Objects.requireNonNull(valuesFunction);
            ArrayList<TestCase> casesToAdd = new ArrayList<TestCase>();
            for (TestCase existingCase : this.cases) {
                Iterable<P> newParameterValues = valuesFunction.apply(existingCase);
                if (newParameterValues == null) continue;
                boolean firstParameter = true;
                for (P parameterValue : newParameterValues) {
                    TestCase caseToUpdate;
                    if (firstParameter) {
                        caseToUpdate = existingCase;
                        firstParameter = false;
                    } else {
                        caseToUpdate = existingCase.newCopy();
                        casesToAdd.add(caseToUpdate);
                    }
                    caseToUpdate.set(parameterName, parameterValue);
                }
            }
            this.cases.addAll(casesToAdd);
        }

        public void addCases(Predicate<TestCase> filter, Consumer<TestCase> modifier) {
            Objects.requireNonNull(modifier);
            if (filter == null) {
                filter = testCase -> true;
            }
            List<TestCase> newCases = this.cases.stream().filter(filter).map(testCase -> {
                TestCase newCase = testCase.newCopy();
                modifier.accept(newCase);
                return newCase;
            }).collect(Collectors.toList());
            newCases.forEach(this::add);
        }

        public void modifyCases(Predicate<TestCase> filter, Consumer<TestCase> modifier) {
            Objects.requireNonNull(modifier);
            if (filter == null) {
                filter = testCase -> true;
            }
            this.cases.stream().filter(filter).forEach(modifier::accept);
        }
    }

    @FunctionalInterface
    public static interface TestCaseProcessor<T> {
        public void processInputValue(Consumer<TestCase> var1, Supplier<TestCase> var2, T var3);
    }
}

