/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.testng;

import com.tridium.nre.security.ISecretBytesSupplier;
import com.tridium.nre.security.PBEEncodingKey;
import com.tridium.nre.security.SecretChars;
import com.tridium.template.file.BINtplFile;
import com.tridium.template.file.PxFileRef;
import com.tridium.template.manifest.TemplateManifest;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.util.Objects;
import java.util.function.Consumer;
import javax.baja.category.BCategoryMask;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.SlotPath;
import javax.baja.security.BPassword;
import javax.baja.security.BPasswordAuthenticator;
import javax.baja.security.BPbkdf2HmacSha256PasswordEncoder;
import javax.baja.security.PasswordEncodingContext;
import javax.baja.space.Mark;
import javax.baja.sys.BObject;
import javax.baja.sys.BStation;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.user.BUserService;
import javax.baja.util.BServiceContainer;

public class StationFileTestUtil {
    public static BDirectory createUserHomeStationFiles(String stationName, BPassword adminPassword, Consumer<BStation> configurator, String bogFilePassphrase) throws IOException {
        Objects.requireNonNull(stationName);
        Objects.requireNonNull(adminPassword);
        if (!SlotPath.isValidName((String)stationName) || stationName.length() > 32) {
            throw new IllegalArgumentException(String.format("Invalid station name '%s'", stationName));
        }
        if (configurator == null) {
            configurator = station -> {};
        }
        try (BINtplFile templateFile = (BINtplFile)BFileSystem.INSTANCE.findFile(new FilePath("!defaults/workbench/newStations/NewControllerStation.ntpl"));){
            BStation station2 = (BStation)templateFile.getBaseComponent();
            station2.setCategoryMask(BCategoryMask.make((String)"1"), null);
            station2.setStationName(stationName);
            configurator.accept(station2);
            BServiceContainer[] serviceContainers = (BServiceContainer[])station2.getChildren(BServiceContainer.class);
            BUserService[] userServices = (BUserService[])serviceContainers[0].getChildren(BUserService.class);
            userServices[0].get("admin").asComplex().set("authenticator", (BValue)new BPasswordAuthenticator(BPassword.make((String)AccessController.doPrivileged(() -> ((BPassword)adminPassword).getValue()), (String)BPbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE)));
            userServices[0].get("guest").asComplex().set("authenticator", (BValue)new BPasswordAuthenticator(BPassword.make((String)"", (String)BPbkdf2HmacSha256PasswordEncoder.ENCODING_TYPE)));
            Object encodingContext = bogFilePassphrase == null ? PasswordEncodingContext.makeNone() : PasswordEncodingContext.updateForExternal(null, (ISecretBytesSupplier)new PBEEncodingKey(SecretChars.fromString((String)bogFilePassphrase)));
            FilePath dirPath = new FilePath(String.format("~stations/%s", stationName));
            BDirectory stationDirectory = (BDirectory)BFileSystem.INSTANCE.findFile(dirPath);
            if (stationDirectory != null) {
                stationDirectory.delete();
            }
            stationDirectory = BFileSystem.INSTANCE.makeDir(dirPath);
            BIFile stationFile = BFileSystem.INSTANCE.makeFile(dirPath.merge("config.bog"));
            ValueDocEncoder encoder = new ValueDocEncoder((OutputStream)new BufferedOutputStream(stationFile.getOutputStream()), (Context)encodingContext);
            encoder.setZipped(true);
            encoder.encodeDocument((BValue)station2);
            encoder.close();
            TemplateManifest tm = templateFile.getTemplateManifest();
            FilePath sharedPath = dirPath.merge("shared");
            for (PxFileRef pxFileRef : templateFile.getPxFiles()) {
                StationFileTestUtil.copyFile((BIFile)pxFileRef.getPxFile(), "px", sharedPath, tm);
            }
            for (BDirectory bDirectory : templateFile.getPxImageFiles()) {
                StationFileTestUtil.copyFile((BIFile)bDirectory, "image", sharedPath, tm);
            }
            BDirectory bDirectory = stationDirectory;
            return bDirectory;
        }
    }

    public static void copyFile(BIFile f, String fileType, FilePath sharedPath, TemplateManifest tm) throws IOException {
        TemplateManifest.Resource res = tm.getResource(f.getFileName(), fileType);
        if (!res.sourceOrd.startsWith("file:^")) {
            return;
        }
        FilePath imDirPath = sharedPath.merge(res.sourceOrd.substring(6)).getParent();
        BDirectory imDir = BFileSystem.INSTANCE.makeDir(imDirPath);
        Mark mark = new Mark((BObject)f, f.getFileName());
        try {
            mark.copyTo((BObject)imDir, null);
        }
        catch (IOException rethrow) {
            throw rethrow;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

