/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.test.file;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BISpace;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.test.BMockHost;
import javax.baja.test.BMockSession;
import javax.baja.test.file.BMockFileStore;

@NiagaraType(agent={@AgentOn(types={"test:MockSession"})})
public class BMockFileSpace
extends BFileSpace {
    @Generated
    public static final Type TYPE = Sys.loadType(BMockFileSpace.class);
    private final Map<FilePath, Map<String, BIFile>> childNodesByParentPath = new TreeMap<FilePath, Map<String, BIFile>>();
    private final Map<FilePath, BIFile> fileByPath = new TreeMap<FilePath, BIFile>();
    private final Set<FilePath> rootPaths = new TreeSet<FilePath>();
    private final Lock mapsLock = new ReentrantLock();
    private final BMockSession session;
    public static final BIFile[] NO_FILES = new BIFile[0];

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMockFileSpace(BMockSession session) {
        super("file");
        this.session = session;
    }

    public static BMockFileSpace makeFileSpace(String sessionName) {
        BMockSession session = BMockHost.INSTANCE.makeSession(sessionName);
        BMockFileSpace result = (BMockFileSpace)session.getNavChild("file");
        if (result == null) {
            result = new BMockFileSpace(session);
            session.mountSpace((BISpace)result);
        }
        return result;
    }

    public void clear() {
        this.mapsLock.lock();
        try {
            this.childNodesByParentPath.clear();
            this.fileByPath.clear();
            this.rootPaths.clear();
        }
        finally {
            this.mapsLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BIFile[] getChildren(FilePath parentPath) {
        if (parentPath.isRelative()) {
            throw new IllegalArgumentException("Relative path: " + parentPath.getBody());
        }
        this.mapsLock.lock();
        try {
            if (this.childNodesByParentPath.containsKey(parentPath)) {
                Collection<BIFile> results = this.childNodesByParentPath.get(parentPath).values();
                BIFile[] bIFileArray = results.toArray(new BIFile[0]);
                return bIFileArray;
            }
            BIFile[] bIFileArray = NO_FILES;
            return bIFileArray;
        }
        finally {
            this.mapsLock.unlock();
        }
    }

    public BIFile mockFile(FilePath path, boolean isDirectory) {
        return this.makeFile(this.mockStore(path, isDirectory));
    }

    public BIFile mockFile(String pathBody) {
        return this.mockFile(new FilePath(pathBody), false);
    }

    public BDirectory mockDirectory(String pathBody) {
        return (BDirectory)this.mockFile(new FilePath(pathBody), true);
    }

    public void mockFiles(String ... paths) {
        for (String path : paths) {
            this.mockFile(new FilePath(path), false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BMockFileStore mockStore(FilePath path, boolean isDirectory) {
        if (path.isRelative()) {
            throw new IllegalArgumentException("Relative path: " + path.getBody());
        }
        BIFileStore result = this.findStore(path);
        if (result == null) {
            if (path.depth() == 0) {
                if (!isDirectory) {
                    throw new IllegalArgumentException(String.format("makeStore isDirectory expected true but got false for %s", path.getBody()));
                }
                this.mapsLock.lock();
                try {
                    result = new BMockFileStore(this, path.getBody(), true);
                    BDirectory dir2 = new BDirectory(result);
                    this.rootPaths.add(path);
                    this.fileByPath.put(path, (BIFile)dir2);
                    this.childNodesByParentPath.put(path, new TreeMap());
                }
                finally {
                    this.mapsLock.unlock();
                }
            } else {
                this.mockStore(path.getParent(), true);
                this.mapsLock.lock();
                try {
                    result = new BMockFileStore(this, path.getBody(), isDirectory);
                    BIFile file = this.makeFile(result);
                    this.childNodesByParentPath.get(path.getParent()).put(path.getName(), file);
                    if (isDirectory) {
                        this.childNodesByParentPath.put(path, new TreeMap());
                    }
                    this.fileByPath.put(path, file);
                }
                finally {
                    this.mapsLock.unlock();
                }
            }
        } else if (result.isDirectory() != isDirectory) {
            throw new IllegalArgumentException(String.format("makeStore isDirectory expected %s but got %s for %s", result.isDirectory(), isDirectory, path.getBody()));
        }
        return (BMockFileStore)result;
    }

    public boolean hasNavChildren() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BINavNode getNavChild(String navName) {
        FilePath navChildPath = new FilePath(navName);
        this.mapsLock.lock();
        try {
            if (this.rootPaths.contains(navChildPath)) {
                BINavNode bINavNode = (BINavNode)this.fileByPath.get(navChildPath);
                return bINavNode;
            }
            BINavNode bINavNode = null;
            return bINavNode;
        }
        finally {
            this.mapsLock.unlock();
        }
    }

    public BINavNode[] getNavChildren() {
        return this.listFiles();
    }

    public BINavNode getNavParent() {
        return this.session;
    }

    public BOrd getOrdInSession() {
        return BOrd.make((String)"file:");
    }

    public BOrd getOrdInHost() {
        return BOrd.make((BOrd)this.getSession().getOrdInHost(), (String)"file:");
    }

    public BHost getHost() {
        return BMockHost.INSTANCE;
    }

    public BISession getSession() {
        return this.session;
    }

    public BDirectory makeDir(FilePath path, Context cx) throws IOException {
        return (BDirectory)this.mockFile(path, true);
    }

    public BIFile makeFile(FilePath path, Context cx) throws IOException {
        return this.mockFile(path, false);
    }

    public void move(FilePath from, FilePath to, Context cx) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(FilePath path, Context cx) throws IOException {
        if (path.isRelative()) {
            throw new IllegalArgumentException("Relative path: " + path.getBody());
        }
        this.mapsLock.lock();
        try {
            if (this.childNodesByParentPath.containsKey(path)) {
                for (String nodeName : this.childNodesByParentPath.get(path).keySet()) {
                    this.delete(path.merge(nodeName), cx);
                }
            }
            this.fileByPath.remove(path);
            this.rootPaths.remove(path);
        }
        finally {
            this.mapsLock.unlock();
        }
    }

    public BIFileStore findStore(FilePath path) {
        BIFile file = this.findFile(path);
        return file == null ? null : file.getStore();
    }

    public BIFile findFile(FilePath path) {
        if (path.isRelative()) {
            throw new IllegalArgumentException("Relative path: " + path.getBody());
        }
        this.mapsLock.lock();
        try {
            BIFile bIFile = this.fileByPath.get(path);
            return bIFile;
        }
        finally {
            this.mapsLock.unlock();
        }
    }

    public BIFile getChild(BIFile parent, String childName) {
        return this.findFile(parent.getFilePath().merge(childName));
    }

    public BIFile[] getChildren(BIFile parent) {
        return this.getChildren(parent.getFilePath());
    }

    public BIFile[] listFiles() {
        this.mapsLock.lock();
        try {
            BIFile[] bIFileArray = (BIFile[])this.rootPaths.stream().map(this.fileByPath::get).toArray(BIFile[]::new);
            return bIFileArray;
        }
        finally {
            this.mapsLock.unlock();
        }
    }
}

