/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.testng.collections.Lists;
import org.testng.internal.EclipseInterface;

public class Assert {
    public static final String ARRAY_MISMATCH_TEMPLATE = "arrays differ firstly at element [%d]; expected value is <%s> but was <%s>. %s";

    protected Assert() {
    }

    public static void assertTrue(boolean condition, String message) {
        if (!condition) {
            Assert.failNotEquals(condition, Boolean.TRUE, message);
        }
    }

    public static void assertTrue(boolean condition) {
        Assert.assertTrue(condition, null);
    }

    public static void assertFalse(boolean condition, String message) {
        if (condition) {
            Assert.failNotEquals(condition, Boolean.FALSE, message);
        }
    }

    public static void assertFalse(boolean condition) {
        Assert.assertFalse(condition, null);
    }

    public static void fail(String message, Throwable realCause) {
        AssertionError ae = new AssertionError((Object)message);
        ((Throwable)((Object)ae)).initCause(realCause);
        throw ae;
    }

    public static void fail(String message) {
        throw new AssertionError((Object)message);
    }

    public static void fail() {
        Assert.fail(null);
    }

    public static void assertEquals(Object actual, Object expected, String message) {
        if (expected != null && expected.getClass().isArray()) {
            Assert.assertArrayEquals(actual, expected, message);
            return;
        }
        Assert.assertEqualsImpl(actual, expected, message);
    }

    private static void assertEqualsImpl(Object actual, Object expected, String message) {
        if (expected == null && actual == null) {
            return;
        }
        if (expected == null ^ actual == null) {
            Assert.failNotEquals(actual, expected, message);
        }
        if (expected.equals(actual) && actual.equals(expected)) {
            return;
        }
        Assert.failNotEquals(actual, expected, message);
    }

    private static void assertArrayEquals(Object actual, Object expected, String message) {
        int expectedLength;
        if (expected == actual) {
            return;
        }
        if (null == expected) {
            Assert.fail("expected a null array, but not null found. " + message);
        }
        if (null == actual) {
            Assert.fail("expected not null array, but null found. " + message);
        }
        if (!actual.getClass().isArray()) {
            Assert.failNotEquals(actual, expected, message);
        }
        if ((expectedLength = Array.getLength(expected)) != Array.getLength(actual)) {
            Assert.failNotEquals(Array.getLength(actual), expectedLength, message == null ? "" : message + " (Array lengths are not the same)");
        }
        for (int i = 0; i < expectedLength; ++i) {
            Object _actual = Array.get(actual, i);
            Object _expected = Array.get(expected, i);
            try {
                Assert.assertEquals(_actual, _expected);
                continue;
            }
            catch (AssertionError ae) {
                Assert.failNotEquals(actual, expected, message == null ? "" : message + " (values at index " + i + " are not the same)");
            }
        }
    }

    public static void assertEquals(byte[] actual, byte[] expected) {
        Assert.assertEquals(actual, expected, "");
    }

    public static void assertEquals(byte[] actual, byte[] expected, String message) {
        if (Assert.checkRefEqualityAndLength(actual, expected, message)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, i, Byte.toString(expected[i]), Byte.toString(actual[i]), message));
        }
    }

    public static void assertEquals(short[] actual, short[] expected) {
        Assert.assertEquals(actual, expected, "");
    }

    public static void assertEquals(short[] actual, short[] expected, String message) {
        if (Assert.checkRefEqualityAndLength(actual, expected, message)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, i, Short.toString(expected[i]), Short.toString(actual[i]), message));
        }
    }

    public static void assertEquals(int[] actual, int[] expected) {
        Assert.assertEquals(actual, expected, "");
    }

    public static void assertEquals(int[] actual, int[] expected, String message) {
        if (Assert.checkRefEqualityAndLength(actual, expected, message)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, i, Integer.toString(expected[i]), Integer.toString(actual[i]), message));
        }
    }

    public static void assertEquals(boolean[] actual, boolean[] expected) {
        Assert.assertEquals(actual, expected, "");
    }

    public static void assertEquals(boolean[] actual, boolean[] expected, String message) {
        if (Assert.checkRefEqualityAndLength(actual, expected, message)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, i, Boolean.toString(expected[i]), Boolean.toString(actual[i]), message));
        }
    }

    public static void assertEquals(char[] actual, char[] expected) {
        Assert.assertEquals(actual, expected, "");
    }

    public static void assertEquals(char[] actual, char[] expected, String message) {
        if (Assert.checkRefEqualityAndLength(actual, expected, message)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, i, Character.toString(expected[i]), Character.toString(actual[i]), message));
        }
    }

    public static void assertEquals(float[] actual, float[] expected) {
        Assert.assertEquals(actual, expected, "");
    }

    public static void assertEquals(float[] actual, float[] expected, String message) {
        if (Assert.checkRefEqualityAndLength(actual, expected, message)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, i, Float.toString(expected[i]), Float.toString(actual[i]), message));
        }
    }

    public static void assertEquals(double[] actual, double[] expected) {
        Assert.assertEquals(actual, expected, "");
    }

    public static void assertEquals(double[] actual, double[] expected, String message) {
        if (Assert.checkRefEqualityAndLength(actual, expected, message)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, i, Double.toString(expected[i]), Double.toString(actual[i]), message));
        }
    }

    public static void assertEquals(long[] actual, long[] expected) {
        Assert.assertEquals(actual, expected, "");
    }

    public static void assertEquals(long[] actual, long[] expected, String message) {
        if (Assert.checkRefEqualityAndLength(actual, expected, message)) {
            return;
        }
        for (int i = 0; i < expected.length; ++i) {
            if (expected[i] == actual[i]) continue;
            Assert.fail(String.format(ARRAY_MISMATCH_TEMPLATE, i, Long.toString(expected[i]), Long.toString(actual[i]), message));
        }
    }

    private static boolean checkRefEqualityAndLength(Object actualArray, Object expectedArray, String message) {
        if (expectedArray == actualArray) {
            return true;
        }
        if (null == expectedArray) {
            Assert.fail("expectedArray a null array, but not null found. " + message);
        }
        if (null == actualArray) {
            Assert.fail("expectedArray not null array, but null found. " + message);
        }
        Assert.assertEquals(Array.getLength(actualArray), Array.getLength(expectedArray), "arrays don't have the same size. " + message);
        return false;
    }

    public static void assertEquals(Object actual, Object expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(String actual, String expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(String actual, String expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(double actual, double expected, double delta, String message) {
        if (Double.isInfinite(expected)) {
            if (expected != actual) {
                Assert.failNotEquals(actual, expected, message);
            }
        } else if (Double.isNaN(expected)) {
            if (!Double.isNaN(actual)) {
                Assert.failNotEquals(actual, expected, message);
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            Assert.failNotEquals(actual, expected, message);
        }
    }

    public static void assertEquals(double actual, double expected, double delta) {
        Assert.assertEquals(actual, expected, delta, null);
    }

    public static void assertEquals(float actual, float expected, float delta, String message) {
        if (Float.isInfinite(expected)) {
            if (expected != actual) {
                Assert.failNotEquals(Float.valueOf(actual), Float.valueOf(expected), message);
            }
        } else if (!(Math.abs(expected - actual) <= delta)) {
            Assert.failNotEquals(Float.valueOf(actual), Float.valueOf(expected), message);
        }
    }

    public static void assertEquals(float actual, float expected, float delta) {
        Assert.assertEquals(actual, expected, delta, null);
    }

    public static void assertEquals(long actual, long expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(long actual, long expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(boolean actual, boolean expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(boolean actual, boolean expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(byte actual, byte expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(byte actual, byte expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(char actual, char expected, String message) {
        Assert.assertEquals(Character.valueOf(actual), Character.valueOf(expected), message);
    }

    public static void assertEquals(char actual, char expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(short actual, short expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(short actual, short expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(int actual, int expected, String message) {
        Assert.assertEquals((Object)actual, (Object)expected, message);
    }

    public static void assertEquals(int actual, int expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertNotNull(Object object) {
        Assert.assertNotNull(object, null);
    }

    public static void assertNotNull(Object object, String message) {
        if (object == null) {
            String formatted = "";
            if (message != null) {
                formatted = message + " ";
            }
            Assert.fail(formatted + "expected object to not be null");
        }
        Assert.assertTrue(object != null, message);
    }

    public static void assertNull(Object object) {
        Assert.assertNull(object, null);
    }

    public static void assertNull(Object object, String message) {
        if (object != null) {
            Assert.failNotSame(object, null, message);
        }
    }

    public static void assertSame(Object actual, Object expected, String message) {
        if (expected == actual) {
            return;
        }
        Assert.failNotSame(actual, expected, message);
    }

    public static void assertSame(Object actual, Object expected) {
        Assert.assertSame(actual, expected, null);
    }

    public static void assertNotSame(Object actual, Object expected, String message) {
        if (expected == actual) {
            Assert.failSame(actual, expected, message);
        }
    }

    public static void assertNotSame(Object actual, Object expected) {
        Assert.assertNotSame(actual, expected, null);
    }

    private static void failSame(Object actual, Object expected, String message) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + EclipseInterface.ASSERT_LEFT2 + expected + EclipseInterface.ASSERT_MIDDLE + actual + EclipseInterface.ASSERT_RIGHT);
    }

    private static void failNotSame(Object actual, Object expected, String message) {
        String formatted = "";
        if (message != null) {
            formatted = message + " ";
        }
        Assert.fail(formatted + EclipseInterface.ASSERT_LEFT + expected + EclipseInterface.ASSERT_MIDDLE + actual + EclipseInterface.ASSERT_RIGHT);
    }

    private static void failNotEquals(Object actual, Object expected, String message) {
        Assert.fail(Assert.format(actual, expected, message));
    }

    static String format(Object actual, Object expected, String message) {
        String formatted = "";
        if (null != message) {
            formatted = message + " ";
        }
        return formatted + EclipseInterface.ASSERT_LEFT + expected + EclipseInterface.ASSERT_MIDDLE + actual + EclipseInterface.ASSERT_RIGHT;
    }

    public static void assertEquals(Collection<?> actual, Collection<?> expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Collection<?> actual, Collection<?> expected, String message) {
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            if (message != null) {
                Assert.fail(message);
            } else {
                Assert.fail("Collections not equal: expected: " + expected + " and actual: " + actual);
            }
        }
        Assert.assertEquals(actual.size(), expected.size(), (message == null ? "" : message + ": ") + "lists don't have the same size");
        Iterator<?> actIt = actual.iterator();
        Iterator<?> expIt = expected.iterator();
        int i = -1;
        while (actIt.hasNext() && expIt.hasNext()) {
            Object e = expIt.next();
            Object a = actIt.next();
            String explanation = "Lists differ at element [" + ++i + "]: " + e + " != " + a;
            String errorMessage = message == null ? explanation : message + ": " + explanation;
            Assert.assertEqualsImpl(a, e, errorMessage);
        }
    }

    public static void assertEquals(Iterator<?> actual, Iterator<?> expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Iterator<?> actual, Iterator<?> expected, String message) {
        String errorMessage;
        String explanation;
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            String msg = message != null ? message : "Iterators not equal: expected: " + expected + " and actual: " + actual;
            Assert.fail(msg);
        }
        int i = -1;
        while (actual.hasNext() && expected.hasNext()) {
            Object e = expected.next();
            Object a = actual.next();
            String explanation2 = "Iterators differ at element [" + ++i + "]: " + e + " != " + a;
            String errorMessage2 = message == null ? explanation2 : message + ": " + explanation2;
            Assert.assertEqualsImpl(a, e, errorMessage2);
        }
        if (actual.hasNext()) {
            explanation = "Actual iterator returned more elements than the expected iterator.";
            errorMessage = message == null ? explanation : message + ": " + explanation;
            Assert.fail(errorMessage);
        } else if (expected.hasNext()) {
            explanation = "Expected iterator returned more elements than the actual iterator.";
            errorMessage = message == null ? explanation : message + ": " + explanation;
            Assert.fail(errorMessage);
        }
    }

    public static void assertEquals(Iterable<?> actual, Iterable<?> expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Iterable<?> actual, Iterable<?> expected, String message) {
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            if (message != null) {
                Assert.fail(message);
            } else {
                Assert.fail("Iterables not equal: expected: " + expected + " and actual: " + actual);
            }
        }
        Iterator<?> actIt = actual.iterator();
        Iterator<?> expIt = expected.iterator();
        Assert.assertEquals(actIt, expIt, message);
    }

    public static void assertEquals(Object[] actual, Object[] expected, String message) {
        if (actual == expected) {
            return;
        }
        if (actual == null && expected != null || actual != null && expected == null) {
            if (message != null) {
                Assert.fail(message);
            } else {
                Assert.fail("Arrays not equal: " + Arrays.toString(expected) + " and " + Arrays.toString(actual));
            }
        }
        Assert.assertEquals(Arrays.asList(actual), Arrays.asList(expected), message);
    }

    public static void assertEqualsNoOrder(Object[] actual, Object[] expected, String message) {
        if (actual == expected) {
            return;
        }
        if (actual == null && expected != null || actual != null && expected == null) {
            Assert.failAssertNoEqual("Arrays not equal: " + Arrays.toString(expected) + " and " + Arrays.toString(actual), message);
        }
        if (actual.length != expected.length) {
            Assert.failAssertNoEqual("Arrays do not have the same size:" + actual.length + " != " + expected.length, message);
        }
        List actualCollection = Lists.newArrayList();
        for (Object a : actual) {
            actualCollection.add(a);
        }
        for (Object o : expected) {
            actualCollection.remove(o);
        }
        if (actualCollection.size() != 0) {
            Assert.failAssertNoEqual("Arrays not equal: " + Arrays.toString(expected) + " and " + Arrays.toString(actual), message);
        }
    }

    private static void failAssertNoEqual(String defaultMessage, String message) {
        if (message != null) {
            Assert.fail(message);
        } else {
            Assert.fail(defaultMessage);
        }
    }

    public static void assertEquals(Object[] actual, Object[] expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEqualsNoOrder(Object[] actual, Object[] expected) {
        Assert.assertEqualsNoOrder(actual, expected, null);
    }

    public static void assertEquals(Set<?> actual, Set<?> expected) {
        Assert.assertEquals(actual, expected, null);
    }

    public static void assertEquals(Set<?> actual, Set<?> expected, String message) {
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            if (message == null) {
                Assert.fail("Sets not equal: expected: " + expected + " and actual: " + actual);
            } else {
                Assert.failNotEquals(actual, expected, message);
            }
        }
        if (!actual.equals(expected)) {
            if (message == null) {
                Assert.fail("Sets differ: expected " + expected + " but got " + actual);
            } else {
                Assert.failNotEquals(actual, expected, message);
            }
        }
    }

    public static void assertEqualsDeep(Set<?> actual, Set<?> expected, String message) {
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            if (message == null) {
                Assert.fail("Sets not equal: expected: " + expected + " and actual: " + actual);
            } else {
                Assert.failNotEquals(actual, expected, message);
            }
        }
        Iterator<?> actualIterator = actual.iterator();
        for (Object expectedValue : expected) {
            if (!actualIterator.hasNext()) {
                Assert.fail("Sets not equal: expected: " + expected + " and actual: " + actual);
            }
            Object value = actualIterator.next();
            if (expectedValue.getClass().isArray()) {
                Assert.assertArrayEquals(value, expectedValue, message);
                continue;
            }
            Assert.assertEqualsImpl(value, expectedValue, message);
        }
    }

    public static void assertEquals(Map<?, ?> actual, Map<?, ?> expected, String message) {
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            Assert.fail("Maps not equal: expected: " + expected + " and actual: " + actual);
        }
        if (actual.size() != expected.size()) {
            Assert.fail("Maps do not have the same size:" + actual.size() + " != " + expected.size());
        }
        Set<Map.Entry<?, ?>> entrySet = actual.entrySet();
        Iterator<Map.Entry<?, ?>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            Map.Entry<?, ?> anEntrySet;
            Map.Entry<?, ?> entry = anEntrySet = iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object expectedValue = expected.get(key);
            String assertMessage = message != null ? message : "Maps do not match for key:" + key + " actual:" + value + " expected:" + expectedValue;
            Assert.assertEqualsImpl(value, expectedValue, assertMessage);
        }
    }

    public static void assertEqualsDeep(Map<?, ?> actual, Map<?, ?> expected) {
        Assert.assertEqualsDeep(actual, expected, null);
    }

    public static void assertEqualsDeep(Map<?, ?> actual, Map<?, ?> expected, String message) {
        if (actual == expected) {
            return;
        }
        if (actual == null || expected == null) {
            Assert.fail("Maps not equal: expected: " + expected + " and actual: " + actual);
        }
        if (actual.size() != expected.size()) {
            Assert.fail("Maps do not have the same size:" + actual.size() + " != " + expected.size());
        }
        Set<Map.Entry<?, ?>> entrySet = actual.entrySet();
        Iterator<Map.Entry<?, ?>> iterator = entrySet.iterator();
        while (iterator.hasNext()) {
            String assertMessage;
            Map.Entry<?, ?> anEntrySet;
            Map.Entry<?, ?> entry = anEntrySet = iterator.next();
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object expectedValue = expected.get(key);
            String string = assertMessage = message != null ? message : "Maps do not match for key:" + key + " actual:" + value + " expected:" + expectedValue;
            if (expectedValue.getClass().isArray()) {
                Assert.assertArrayEquals(value, expectedValue, assertMessage);
                continue;
            }
            Assert.assertEqualsImpl(value, expectedValue, assertMessage);
        }
    }

    public static void assertNotEquals(Object actual1, Object actual2, String message) {
        boolean fail;
        try {
            Assert.assertEquals(actual1, actual2);
            fail = true;
        }
        catch (AssertionError e) {
            fail = false;
        }
        if (fail) {
            Assert.fail(message);
        }
    }

    public static void assertNotEquals(Object actual1, Object actual2) {
        Assert.assertNotEquals(actual1, actual2, null);
    }

    static void assertNotEquals(String actual1, String actual2, String message) {
        Assert.assertNotEquals((Object)actual1, (Object)actual2, message);
    }

    static void assertNotEquals(String actual1, String actual2) {
        Assert.assertNotEquals(actual1, actual2, null);
    }

    static void assertNotEquals(long actual1, long actual2, String message) {
        Assert.assertNotEquals((Object)actual1, (Object)actual2, message);
    }

    static void assertNotEquals(long actual1, long actual2) {
        Assert.assertNotEquals(actual1, actual2, null);
    }

    static void assertNotEquals(boolean actual1, boolean actual2, String message) {
        Assert.assertNotEquals((Object)actual1, (Object)actual2, message);
    }

    static void assertNotEquals(boolean actual1, boolean actual2) {
        Assert.assertNotEquals(actual1, actual2, null);
    }

    static void assertNotEquals(byte actual1, byte actual2, String message) {
        Assert.assertNotEquals((Object)actual1, (Object)actual2, message);
    }

    static void assertNotEquals(byte actual1, byte actual2) {
        Assert.assertNotEquals(actual1, actual2, null);
    }

    static void assertNotEquals(char actual1, char actual2, String message) {
        Assert.assertNotEquals(Character.valueOf(actual1), Character.valueOf(actual2), message);
    }

    static void assertNotEquals(char actual1, char actual2) {
        Assert.assertNotEquals(actual1, actual2, null);
    }

    static void assertNotEquals(short actual1, short actual2, String message) {
        Assert.assertNotEquals((Object)actual1, (Object)actual2, message);
    }

    static void assertNotEquals(short actual1, short actual2) {
        Assert.assertNotEquals(actual1, actual2, null);
    }

    static void assertNotEquals(int actual1, int actual2, String message) {
        Assert.assertNotEquals((Object)actual1, (Object)actual2, message);
    }

    static void assertNotEquals(int actual1, int actual2) {
        Assert.assertNotEquals(actual1, actual2, null);
    }

    public static void assertNotEquals(float actual1, float actual2, float delta, String message) {
        boolean fail;
        try {
            Assert.assertEquals(actual1, actual2, delta, message);
            fail = true;
        }
        catch (AssertionError e) {
            fail = false;
        }
        if (fail) {
            Assert.fail(message);
        }
    }

    public static void assertNotEquals(float actual1, float actual2, float delta) {
        Assert.assertNotEquals(actual1, actual2, delta, null);
    }

    public static void assertNotEquals(double actual1, double actual2, double delta, String message) {
        boolean fail;
        try {
            Assert.assertEquals(actual1, actual2, delta, message);
            fail = true;
        }
        catch (AssertionError e) {
            fail = false;
        }
        if (fail) {
            Assert.fail(message);
        }
    }

    public static void assertNotEquals(Set<?> actual, Set<?> expected) {
        Assert.assertNotEquals(actual, expected, null);
    }

    public static void assertNotEquals(Set<?> actual, Set<?> expected, String message) {
        boolean fail;
        try {
            Assert.assertEquals(actual, expected, message);
            fail = true;
        }
        catch (AssertionError e) {
            fail = false;
        }
        if (fail) {
            Assert.fail(message);
        }
    }

    public static void assertNotEqualsDeep(Set<?> actual, Set<?> expected) {
        Assert.assertNotEqualsDeep(actual, expected, null);
    }

    public static void assertNotEqualsDeep(Set<?> actual, Set<?> expected, String message) {
        boolean fail;
        try {
            Assert.assertEqualsDeep(actual, expected, message);
            fail = true;
        }
        catch (AssertionError e) {
            fail = false;
        }
        if (fail) {
            Assert.fail(message);
        }
    }

    public static void assertNotEquals(Map<?, ?> actual, Map<?, ?> expected) {
        Assert.assertNotEquals(actual, expected, null);
    }

    public static void assertNotEquals(Map<?, ?> actual, Map<?, ?> expected, String message) {
        boolean fail;
        try {
            Assert.assertEquals(actual, expected, message);
            fail = true;
        }
        catch (AssertionError e) {
            fail = false;
        }
        if (fail) {
            Assert.fail(message);
        }
    }

    public static void assertNotEqualsDeep(Map<?, ?> actual, Map<?, ?> expected) {
        Assert.assertNotEqualsDeep(actual, expected, null);
    }

    public static void assertNotEqualsDeep(Map<?, ?> actual, Map<?, ?> expected, String message) {
        boolean fail;
        try {
            Assert.assertEqualsDeep(actual, expected, message);
            fail = true;
        }
        catch (AssertionError e) {
            fail = false;
        }
        if (fail) {
            Assert.fail(message);
        }
    }

    public static void assertNotEquals(double actual1, double actual2, double delta) {
        Assert.assertNotEquals(actual1, actual2, delta, null);
    }

    public static void assertThrows(ThrowingRunnable runnable) {
        Assert.assertThrows(Throwable.class, runnable);
    }

    public static <T extends Throwable> void assertThrows(Class<T> throwableClass, ThrowingRunnable runnable) {
        Assert.expectThrows(throwableClass, runnable);
    }

    public static <T extends Throwable> T expectThrows(Class<T> throwableClass, ThrowingRunnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            if (throwableClass.isInstance(t)) {
                return (T)((Throwable)throwableClass.cast(t));
            }
            String mismatchMessage = String.format("Expected %s to be thrown, but %s was thrown", throwableClass.getSimpleName(), t.getClass().getSimpleName());
            throw new AssertionError(mismatchMessage, t);
        }
        String message = String.format("Expected %s to be thrown, but nothing was thrown", throwableClass.getSimpleName());
        throw new AssertionError((Object)message);
    }

    public static interface ThrowingRunnable {
        public void run() throws Throwable;
    }
}

