/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.collections.Objects;
import org.testng.internal.IResultListener2;

public class TestListenerAdapter
implements IResultListener2 {
    private Collection<ITestNGMethod> m_allTestMethods = new ConcurrentLinkedQueue<ITestNGMethod>();
    private Collection<ITestResult> m_passedTests = new ConcurrentLinkedQueue<ITestResult>();
    private Collection<ITestResult> m_failedTests = new ConcurrentLinkedQueue<ITestResult>();
    private Collection<ITestResult> m_skippedTests = new ConcurrentLinkedQueue<ITestResult>();
    private Collection<ITestResult> m_failedButWSPerTests = new ConcurrentLinkedQueue<ITestResult>();
    private Collection<ITestContext> m_testContexts = new ConcurrentLinkedQueue<ITestContext>();
    private Collection<ITestResult> m_failedConfs = new ConcurrentLinkedQueue<ITestResult>();
    private Collection<ITestResult> m_skippedConfs = new ConcurrentLinkedQueue<ITestResult>();
    private Collection<ITestResult> m_passedConfs = new ConcurrentLinkedQueue<ITestResult>();

    @Override
    public void onTestSuccess(ITestResult tr) {
        this.m_allTestMethods.add(tr.getMethod());
        this.m_passedTests.add(tr);
    }

    @Override
    public void onTestFailure(ITestResult tr) {
        this.m_allTestMethods.add(tr.getMethod());
        this.m_failedTests.add(tr);
    }

    @Override
    public void onTestSkipped(ITestResult tr) {
        this.m_allTestMethods.add(tr.getMethod());
        this.m_skippedTests.add(tr);
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult tr) {
        this.m_allTestMethods.add(tr.getMethod());
        this.m_failedButWSPerTests.add(tr);
    }

    protected ITestNGMethod[] getAllTestMethods() {
        return this.m_allTestMethods.toArray(new ITestNGMethod[this.m_allTestMethods.size()]);
    }

    @Override
    public void onStart(ITestContext testContext) {
        this.m_testContexts.add(testContext);
    }

    @Override
    public void onFinish(ITestContext testContext) {
    }

    public List<ITestResult> getFailedButWithinSuccessPercentageTests() {
        return new ArrayList<ITestResult>(this.m_failedButWSPerTests);
    }

    public List<ITestResult> getFailedTests() {
        return new ArrayList<ITestResult>(this.m_failedTests);
    }

    public List<ITestResult> getPassedTests() {
        return new ArrayList<ITestResult>(this.m_passedTests);
    }

    public List<ITestResult> getSkippedTests() {
        return new ArrayList<ITestResult>(this.m_skippedTests);
    }

    private static void ppp(String s) {
        System.out.println("[TestListenerAdapter] " + s);
    }

    public void setAllTestMethods(List<ITestNGMethod> allTestMethods) {
        this.m_allTestMethods = allTestMethods;
    }

    public void setFailedButWithinSuccessPercentageTests(List<ITestResult> failedButWithinSuccessPercentageTests) {
        this.m_failedButWSPerTests = failedButWithinSuccessPercentageTests;
    }

    public void setFailedTests(List<ITestResult> failedTests) {
        this.m_failedTests = failedTests;
    }

    public void setPassedTests(List<ITestResult> passedTests) {
        this.m_passedTests = passedTests;
    }

    public void setSkippedTests(List<ITestResult> skippedTests) {
        this.m_skippedTests = skippedTests;
    }

    @Override
    public void onTestStart(ITestResult result) {
    }

    public List<ITestContext> getTestContexts() {
        return new ArrayList<ITestContext>(this.m_testContexts);
    }

    public List<ITestResult> getConfigurationFailures() {
        return new ArrayList<ITestResult>(this.m_failedConfs);
    }

    @Override
    public void onConfigurationFailure(ITestResult itr) {
        this.m_failedConfs.add(itr);
    }

    public List<ITestResult> getConfigurationSkips() {
        return new ArrayList<ITestResult>(this.m_skippedConfs);
    }

    @Override
    public void beforeConfiguration(ITestResult tr) {
    }

    @Override
    public void onConfigurationSkip(ITestResult itr) {
        this.m_skippedConfs.add(itr);
    }

    @Override
    public void onConfigurationSuccess(ITestResult itr) {
        this.m_passedConfs.add(itr);
    }

    public String toString() {
        return Objects.toStringHelper(this.getClass()).add("passed", this.getPassedTests().size()).add("failed", this.getFailedTests().size()).add("skipped", this.getSkippedTests().size()).toString();
    }
}

