/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.testng.ClassMethodMap;
import org.testng.IClassListener;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.collections.Lists;
import org.testng.internal.ClassBasedParallelWorker;
import org.testng.internal.ConfigurationGroupMethods;
import org.testng.internal.IInvoker;
import org.testng.internal.InstanceBasedParallelParallelWorker;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.thread.graph.IWorker;
import org.testng.xml.XmlSuite;

public abstract class AbstractParallelWorker {
    public static AbstractParallelWorker newWorker(XmlSuite.ParallelMode mode) {
        if (XmlSuite.ParallelMode.INSTANCES.equals((Object)mode)) {
            return new InstanceBasedParallelParallelWorker();
        }
        return new ClassBasedParallelWorker();
    }

    public abstract List<IWorker<ITestNGMethod>> createWorkers(Arguments var1);

    public static class Arguments {
        private List<ITestNGMethod> methods;
        private IInvoker invoker;
        private ConfigurationGroupMethods configMethods;
        private ClassMethodMap classMethodMap;
        private List<IClassListener> listeners;
        private ITestContext testContext;
        private IAnnotationFinder finder;

        private Arguments() {
        }

        public List<ITestNGMethod> getMethods() {
            return Collections.unmodifiableList(this.methods);
        }

        public IInvoker getInvoker() {
            return this.invoker;
        }

        public ConfigurationGroupMethods getConfigMethods() {
            return this.configMethods;
        }

        public ClassMethodMap getClassMethodMap() {
            return this.classMethodMap;
        }

        List<IClassListener> getListeners() {
            return Collections.unmodifiableList(this.listeners);
        }

        public ITestContext getTestContext() {
            return this.testContext;
        }

        public IAnnotationFinder getFinder() {
            return this.finder;
        }

        public static class Builder {
            private Arguments instance = new Arguments();

            public Builder methods(List<ITestNGMethod> methods) {
                this.instance.methods = methods;
                return this;
            }

            public Builder invoker(IInvoker invoker) {
                this.instance.invoker = invoker;
                return this;
            }

            public Builder configMethods(ConfigurationGroupMethods configMethods) {
                this.instance.configMethods = configMethods;
                return this;
            }

            public Builder classMethodMap(ClassMethodMap classMethodMap) {
                this.instance.classMethodMap = classMethodMap;
                return this;
            }

            public Builder listeners(Collection<IClassListener> listeners) {
                this.instance.listeners = Lists.newLinkedList(listeners);
                return this;
            }

            public Builder testContext(ITestContext testContext) {
                this.instance.testContext = testContext;
                return this;
            }

            public Builder finder(IAnnotationFinder finder) {
                this.instance.finder = finder;
                return this;
            }

            public Arguments build() {
                return this.instance;
            }
        }
    }
}

