/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.BitSet;
import org.testng.IResultMap;
import org.testng.ITestContext;

public class ExitCode {
    public static final int HAS_NO_TEST = 8;
    private static final int FAILED_WITHIN_SUCCESS = 4;
    private static final int SKIPPED = 2;
    private static final int FAILED = 1;
    private static final int SIZE = 3;
    private final BitSet exitCodeBits;

    ExitCode() {
        this(new BitSet(3));
    }

    public static boolean hasFailureWithinSuccessPercentage(int returnCode) {
        return (returnCode & 4) == 4;
    }

    public static boolean hasSkipped(int returnCode) {
        return (returnCode & 2) == 2;
    }

    public static boolean hasFailure(int returnCode) {
        return (returnCode & 1) == 1;
    }

    public static ExitCode newExitCodeRepresentingFailure() {
        BitSet bitSet = new BitSet(3);
        bitSet.set(0, true);
        bitSet.set(1, false);
        bitSet.set(2, false);
        return new ExitCode(bitSet);
    }

    private ExitCode(BitSet exitCodeBits) {
        this.exitCodeBits = exitCodeBits;
    }

    void computeAndUpdate(ITestContext context) {
        this.computeAndUpdate(0, context.getFailedTests(), context.getFailedConfigurations());
        this.computeAndUpdate(1, context.getSkippedTests(), context.getSkippedConfigurations());
        this.computeAndUpdate(2, context.getFailedButWithinSuccessPercentageTests(), null);
    }

    private void computeAndUpdate(int index, IResultMap testResults, IResultMap configResults) {
        boolean containsResults;
        boolean bl = containsResults = testResults.size() != 0;
        if (configResults != null) {
            boolean bl2 = containsResults = containsResults || configResults.size() != 0;
        }
        if (containsResults) {
            this.exitCodeBits.set(index);
        }
    }

    public boolean hasFailure() {
        return this.exitCodeBits.get(0);
    }

    public boolean hasSkip() {
        return this.exitCodeBits.get(1);
    }

    public boolean hasFailureWithinSuccessPercentage() {
        return this.exitCodeBits.get(2);
    }

    public int getExitCode() {
        int exitCode = 0;
        for (int i = 0; i < this.exitCodeBits.length(); ++i) {
            if (!this.exitCodeBits.get(i)) continue;
            exitCode |= 1 << i;
        }
        return exitCode;
    }
}

