/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.testng.IDataProviderListener;
import org.testng.IInstanceInfo;
import org.testng.IObjectFactory;
import org.testng.IObjectFactory2;
import org.testng.ITestContext;
import org.testng.ITestNGListener;
import org.testng.ITestNGMethod;
import org.testng.ITestObjectFactory;
import org.testng.TestNGException;
import org.testng.annotations.IFactoryAnnotation;
import org.testng.annotations.IListenersAnnotation;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.internal.BaseTestMethod;
import org.testng.internal.ClassHelper;
import org.testng.internal.ConstructorOrMethod;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.Parameters;
import org.testng.internal.RunInfo;
import org.testng.internal.TestNGMethodFinder;
import org.testng.internal.Utils;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.xml.XmlSuite;
import org.testng.xml.XmlTest;

public class FactoryMethod
extends BaseTestMethod {
    private final IFactoryAnnotation factoryAnnotation;
    private final Object m_instance;
    private final ITestContext m_testContext;
    private final ITestObjectFactory objectFactory;
    private final Map<Class<? extends IDataProviderListener>, IDataProviderListener> m_dataProviderListeners;

    @Deprecated
    public FactoryMethod(ConstructorOrMethod com, Object instance, XmlTest xmlTest, IAnnotationFinder annotationFinder, ITestContext testContext, ITestObjectFactory objectFactory) {
        this(com, instance, annotationFinder, testContext, objectFactory, Collections.emptyMap());
    }

    private void init(Object instance, IAnnotationFinder annotationFinder, ConstructorOrMethod com) {
        Class<? extends ITestNGListener>[] listeners;
        IListenersAnnotation annotation = annotationFinder.findAnnotation(com.getDeclaringClass(), IListenersAnnotation.class);
        if (annotation == null) {
            return;
        }
        for (Class<? extends ITestNGListener> listener : listeners = annotation.getValue()) {
            Class<? extends ITestNGListener> key;
            if (!IDataProviderListener.class.isAssignableFrom(listener) || this.m_dataProviderListeners.containsKey(key = listener)) continue;
            if (instance != null && IDataProviderListener.class.isAssignableFrom(instance.getClass())) {
                this.m_dataProviderListeners.put(key, (IDataProviderListener)instance);
                continue;
            }
            ITestNGListener object = ClassHelper.newInstanceOrNull(listener);
            if (object == null) continue;
            this.m_dataProviderListeners.put(key, (IDataProviderListener)object);
        }
    }

    FactoryMethod(ConstructorOrMethod com, Object instance, IAnnotationFinder annotationFinder, ITestContext testContext, ITestObjectFactory objectFactory, Map<Class<? extends IDataProviderListener>, IDataProviderListener> dataProviderListeners) {
        super(com.getName(), com, annotationFinder, instance);
        this.m_dataProviderListeners = dataProviderListeners;
        this.init(instance, annotationFinder, com);
        Utils.checkInstanceOrStatic(instance, com.getMethod());
        Utils.checkReturnType(com.getMethod(), Object[].class, IInstanceInfo[].class);
        Class<?> declaringClass = com.getDeclaringClass();
        if (instance != null && !declaringClass.isAssignableFrom(instance.getClass())) {
            throw new TestNGException("Mismatch between instance/method classes:" + instance.getClass() + " " + declaringClass);
        }
        if (instance == null && com.getMethod() != null && !Modifier.isStatic(com.getMethod().getModifiers())) {
            throw new TestNGException("An inner factory method MUST be static. But '" + com.getMethod().getName() + "' from '" + declaringClass.getName() + "' is not.");
        }
        if (com.getMethod() != null && !Modifier.isPublic(com.getMethod().getModifiers())) {
            try {
                com.getMethod().setAccessible(true);
            }
            catch (SecurityException e) {
                throw new TestNGException(com.getMethod().getName() + " must be public", e);
            }
        }
        this.factoryAnnotation = annotationFinder.findAnnotation(com, IFactoryAnnotation.class);
        this.m_instance = instance;
        this.m_testContext = testContext;
        NoOpTestClass tc = new NoOpTestClass();
        tc.setTestClass(declaringClass);
        this.m_testClass = tc;
        this.objectFactory = objectFactory;
        this.m_groups = FactoryMethod.getAllGroups(declaringClass, testContext.getCurrentXmlTest(), annotationFinder);
    }

    @Deprecated
    public FactoryMethod(ConstructorOrMethod com, Object instance, XmlTest xmlTest, IAnnotationFinder annotationFinder, ITestContext testContext, ITestObjectFactory objectFactory, Map<Class<? extends IDataProviderListener>, IDataProviderListener> dataProviderListeners) {
        this(com, instance, annotationFinder, testContext, objectFactory, dataProviderListeners);
    }

    private static String[] getAllGroups(Class<?> declaringClass, XmlTest xmlTest, IAnnotationFinder annotationFinder) {
        TestNGMethodFinder testMethodFinder = new TestNGMethodFinder(new RunInfo(), annotationFinder);
        ITestNGMethod[] testMethods = testMethodFinder.getTestMethods(declaringClass, xmlTest);
        HashSet<String> groups = new HashSet<String>();
        for (ITestNGMethod method : testMethods) {
            groups.addAll(Arrays.asList(method.getGroups()));
        }
        return groups.toArray(new String[groups.size()]);
    }

    public Object[] invoke() {
        List result = Lists.newArrayList();
        Map<String, String> allParameterNames = Maps.newHashMap();
        Parameters.MethodParameters methodParameters = new Parameters.MethodParameters(this.m_testContext.getCurrentXmlTest().getAllParameters(), this.findMethodParameters(this.m_testContext.getCurrentXmlTest()), null, null, this.m_testContext, null);
        Iterator<Object[]> parameterIterator = Parameters.handleParameters((ITestNGMethod)this, allParameterNames, (Object)this.m_instance, (Parameters.MethodParameters)methodParameters, (XmlSuite)this.m_testContext.getCurrentXmlTest().getSuite(), (IAnnotationFinder)this.m_annotationFinder, null, this.m_dataProviderListeners.values()).parameters;
        try {
            List<Integer> indices = this.factoryAnnotation.getIndices();
            int position = 0;
            while (parameterIterator.hasNext()) {
                Object[] parameters = parameterIterator.next();
                ConstructorOrMethod com = this.getConstructorOrMethod();
                if (com.getMethod() != null) {
                    Object[] testInstances = (Object[])com.getMethod().invoke(this.m_instance, parameters);
                    if (indices == null || indices.isEmpty()) {
                        result.addAll(Arrays.asList(testInstances));
                    } else {
                        for (Integer index : indices) {
                            int i = index - position;
                            if (i < 0 || i >= testInstances.length) continue;
                            result.add(testInstances[i]);
                        }
                    }
                    position += testInstances.length;
                    continue;
                }
                if (indices == null || indices.isEmpty() || indices.contains(position)) {
                    Object instance;
                    if (this.objectFactory instanceof IObjectFactory) {
                        instance = ((IObjectFactory)this.objectFactory).newInstance(com.getConstructor(), parameters);
                    } else if (this.objectFactory instanceof IObjectFactory2) {
                        instance = ((IObjectFactory2)this.objectFactory).newInstance(com.getDeclaringClass());
                    } else {
                        throw new IllegalStateException("Unsupported ITestObjectFactory " + this.objectFactory.getClass());
                    }
                    result.add(instance);
                }
                ++position;
            }
        }
        catch (Throwable t) {
            ConstructorOrMethod com = this.getConstructorOrMethod();
            throw new TestNGException("The factory method " + com.getDeclaringClass() + "." + com.getName() + "() threw an exception", t);
        }
        return result.toArray(new Object[result.size()]);
    }

    @Override
    public ITestNGMethod clone() {
        throw new IllegalStateException("clone is not supported for FactoryMethod");
    }
}

