/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.util.Comparator;
import org.testng.ITestNGMethod;

public final class Systematiser {
    private Systematiser() {
    }

    public static Comparator<ITestNGMethod> getComparator() {
        Comparator<ITestNGMethod> comparator;
        String text = System.getProperty("testng.order", Order.INSTANCES.getValue());
        Order order = Order.parse(text);
        switch (order) {
            case METHOD_NAMES: {
                comparator = new Comparator<ITestNGMethod>(){

                    @Override
                    public int compare(ITestNGMethod o1, ITestNGMethod o2) {
                        String n1 = o1.getMethodName();
                        String n2 = o1.getMethodName();
                        return n1.compareTo(n2);
                    }

                    public String toString() {
                        return "Method_Names";
                    }
                };
                break;
            }
            case NONE: {
                comparator = new Comparator<ITestNGMethod>(){

                    @Override
                    public int compare(ITestNGMethod o1, ITestNGMethod o2) {
                        return 0;
                    }

                    public String toString() {
                        return "No_Sorting";
                    }
                };
                break;
            }
            default: {
                comparator = new Comparator<ITestNGMethod>(){

                    @Override
                    public int compare(ITestNGMethod o1, ITestNGMethod o2) {
                        return o1.toString().compareTo(o2.toString());
                    }

                    public String toString() {
                        return "Instance_Names";
                    }
                };
            }
        }
        return comparator;
    }

    static enum Order {
        METHOD_NAMES("methods"),
        INSTANCES("instances"),
        NONE("none");

        private String value;

        private Order(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Order parse(String value) {
            if (value == null || value.trim().isEmpty()) {
                return INSTANCES;
            }
            for (Order each : Order.values()) {
                if (!each.getValue().equalsIgnoreCase(value)) continue;
                return each;
            }
            return INSTANCES;
        }
    }
}

