/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;

public class Files {
    public static String readFile(File f) throws IOException {
        try (FileInputStream is = new FileInputStream(f);){
            String string = Files.readFile(is);
            return string;
        }
    }

    public static String readFile(InputStream is) throws IOException {
        StringBuilder result = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(is));
        String line = br.readLine();
        while (line != null) {
            result.append(line + "\n");
            line = br.readLine();
        }
        return result.toString();
    }

    public static void writeFile(String string, File f) throws IOException {
        f.getParentFile().mkdirs();
        try (FileWriter fw = new FileWriter(f);
             BufferedWriter bw = new BufferedWriter(fw);){
            bw.write(string);
        }
    }

    public static void copyFile(InputStream from, File to) throws IOException {
        if (!to.getParentFile().exists()) {
            to.getParentFile().mkdirs();
        }
        try (FileOutputStream os = new FileOutputStream(to);){
            byte[] buffer = new byte[65536];
            int count = from.read(buffer);
            while (count > 0) {
                ((OutputStream)os).write(buffer, 0, count);
                count = from.read(buffer);
            }
        }
    }

    public static String streamToString(InputStream is) throws IOException {
        if (is != null) {
            StringWriter writer = new StringWriter();
            char[] buffer = new char[1024];
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
                int n;
                while ((n = reader.read(buffer)) != -1) {
                    ((Writer)writer).write(buffer, 0, n);
                }
            }
            return ((Object)writer).toString();
        }
        return "";
    }
}

