/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.control.trigger;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Random;
import java.util.StringTokenizer;
import javax.baja.control.trigger.BTimeTrigger;
import javax.baja.control.trigger.BTriggerMode;
import javax.baja.control.trigger.TriggerScheduler;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BTime;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BDaysOfWeekBits;
import javax.baja.util.LexiconText;

@NiagaraType
public final class BIntervalTriggerMode
extends BTriggerMode {
    public static final BIntervalTriggerMode DEFAULT = new BIntervalTriggerMode();
    public static final Type TYPE = Sys.loadType(BIntervalTriggerMode.class);
    private boolean rangeEnabled = false;
    private BTime startTime = BTime.make((int)0, (int)0, (int)0);
    private BTime endTime = BTime.make((int)23, (int)59, (int)59, (int)999);
    private BRelTime interval = BRelTime.makeMinutes((int)1);
    private BDaysOfWeekBits daysOfWeek = BDaysOfWeekBits.DEFAULT;
    private BAbsTime scheduledTime;
    private static Random rand = new Random();
    private static LexiconText dispName = LexiconText.make((String)"control", (String)"trigger.interval");

    public static BIntervalTriggerMode make() {
        return DEFAULT;
    }

    public static BIntervalTriggerMode make(BRelTime interval) {
        BIntervalTriggerMode m = new BIntervalTriggerMode();
        m.interval = interval;
        return m;
    }

    public static BIntervalTriggerMode make(BRelTime interval, BDaysOfWeekBits daysOfWeek) {
        BIntervalTriggerMode m = new BIntervalTriggerMode();
        m.interval = interval;
        m.daysOfWeek = daysOfWeek;
        return m;
    }

    public static BIntervalTriggerMode make(BTime startTime, BTime endTime, BRelTime interval, BDaysOfWeekBits daysOfWeek) {
        return BIntervalTriggerMode.make(true, startTime, endTime, interval, daysOfWeek);
    }

    public static BIntervalTriggerMode make(boolean rangeEnabled, BTime startTime, BTime endTime, BRelTime interval, BDaysOfWeekBits daysOfWeek) {
        BIntervalTriggerMode m = new BIntervalTriggerMode();
        m.rangeEnabled = rangeEnabled;
        m.startTime = startTime;
        m.endTime = endTime;
        m.interval = interval;
        m.daysOfWeek = daysOfWeek;
        return m;
    }

    private BIntervalTriggerMode() {
    }

    @Override
    public String getDisplayName(Context cx) {
        return dispName.getText(cx);
    }

    public boolean isRangeEnabled() {
        return this.rangeEnabled;
    }

    public BTime getStartTime() {
        return this.startTime;
    }

    public BTime getEndTime() {
        return this.endTime;
    }

    public BRelTime getInterval() {
        return this.interval;
    }

    public BDaysOfWeekBits getDaysOfWeek() {
        return this.daysOfWeek;
    }

    @Override
    public TriggerScheduler makeScheduler(BTimeTrigger trigger) {
        return new IntervalTriggerScheduler(trigger);
    }

    public int hashCode() {
        return this.startTime.hashCode() ^ this.endTime.hashCode() ^ this.interval.hashCode() ^ this.daysOfWeek.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof BIntervalTriggerMode) {
            BIntervalTriggerMode itt = (BIntervalTriggerMode)((Object)o);
            return this.rangeEnabled == itt.rangeEnabled && this.startTime.equals((Object)itt.startTime) && this.endTime.equals((Object)itt.endTime) && this.interval.equals((Object)itt.interval) && this.daysOfWeek.equals((Object)itt.daysOfWeek);
        }
        return false;
    }

    public void encode(DataOutput out) throws IOException {
        out.writeBoolean(this.rangeEnabled);
        this.startTime.encode(out);
        this.endTime.encode(out);
        this.interval.encode(out);
        this.daysOfWeek.encode(out);
    }

    public BObject decode(DataInput in) throws IOException {
        return BIntervalTriggerMode.make(in.readBoolean(), (BTime)BTime.DEFAULT.decode(in), (BTime)BTime.DEFAULT.decode(in), (BRelTime)BRelTime.DEFAULT.decode(in), (BDaysOfWeekBits)BDaysOfWeekBits.DEFAULT.decode(in));
    }

    public String encodeToString() {
        StringBuilder s = new StringBuilder();
        s.append(BBoolean.encode((boolean)this.rangeEnabled));
        s.append(';').append(this.startTime.encodeToString());
        s.append(';').append(this.endTime.encodeToString());
        s.append(';').append(this.interval.encodeToString());
        s.append(';').append(this.daysOfWeek.encodeToString());
        return s.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        StringTokenizer st = new StringTokenizer(s, ";");
        return BIntervalTriggerMode.make(BBoolean.decode((String)st.nextToken()), (BTime)BTime.DEFAULT.decodeFromString(st.nextToken()), (BTime)BTime.DEFAULT.decodeFromString(st.nextToken()), (BRelTime)BRelTime.DEFAULT.decodeFromString(st.nextToken()), (BDaysOfWeekBits)BDaysOfWeekBits.DEFAULT.decodeFromString(st.nextToken()));
    }

    public String toString(Context cx) {
        return this.interval.toString(cx) + " " + this.daysOfWeek.toString(cx);
    }

    @Override
    public Type getType() {
        return TYPE;
    }

    private class IntervalTriggerScheduler
    extends TriggerScheduler {
        private Clock.Ticket ticket;

        public IntervalTriggerScheduler(BTimeTrigger trigger) {
            super(trigger);
        }

        @Override
        public void start() {
            BIntervalTriggerMode.this.scheduledTime = this.getNextTriggerTime(Clock.time(), this.getTrigger().getLastTrigger());
            if (BIntervalTriggerMode.this.interval.getMillis() > 0L) {
                this.ticket = Clock.schedulePeriodically((BComponent)this.getTrigger(), (BAbsTime)BIntervalTriggerMode.this.scheduledTime, (BRelTime)BIntervalTriggerMode.this.interval, (Action)BTimeTrigger.checkTime, null);
            }
        }

        @Override
        public void stop() {
            if (this.ticket != null) {
                this.ticket.cancel();
            }
        }

        @Override
        public boolean isTriggerTime(BAbsTime time) {
            boolean fireIt;
            BAbsTime next = this.getTrigger().getNextTrigger();
            boolean bl = fireIt = !time.isBefore(next);
            if (fireIt) {
                BIntervalTriggerMode.this.scheduledTime = this.getNextTriggerTime(time, next);
                return true;
            }
            if (this.ticket != null) {
                BIntervalTriggerMode.this.scheduledTime = next;
                this.ticket.cancel();
                this.ticket = Clock.schedulePeriodically((BComponent)this.getTrigger(), (BAbsTime)next, (BRelTime)BIntervalTriggerMode.this.getInterval(), (Action)BTimeTrigger.checkTime, null);
            }
            return false;
        }

        @Override
        BAbsTime getScheduledTriggerTime() {
            return BIntervalTriggerMode.this.scheduledTime;
        }

        @Override
        public BAbsTime getNextTriggerTime(BAbsTime from, BAbsTime previous) {
            BRelTime interval;
            BDaysOfWeekBits daysOfWeek = BIntervalTriggerMode.this.getDaysOfWeek();
            if (daysOfWeek.isEmpty()) {
                return BAbsTime.END_OF_TIME;
            }
            if (previous.isAfter(from)) {
                previous = BAbsTime.NULL;
            }
            if ((interval = BIntervalTriggerMode.this.getInterval()).getMillis() <= 0L) {
                return BAbsTime.END_OF_TIME;
            }
            if (!BIntervalTriggerMode.this.isRangeEnabled()) {
                BAbsTime result = null;
                if (previous.isNull()) {
                    result = from.add(BRelTime.make((long)((long)((double)interval.getMillis() * rand.nextDouble()))));
                } else {
                    BRelTime diff = from.delta(previous).abs();
                    if (diff.getMillis() > interval.getMillis() * 3L) {
                        result = from.add(BRelTime.make((long)((long)((double)interval.getMillis() * rand.nextDouble()))));
                    } else {
                        result = previous.add(interval);
                        while (result.isBefore(from)) {
                            result = result.add(interval);
                        }
                    }
                }
                while (!daysOfWeek.includes(result)) {
                    result = result.add(interval);
                }
                return result;
            }
            BTime startTime = BIntervalTriggerMode.this.getStartTime();
            BTime endTime = BIntervalTriggerMode.this.getEndTime();
            if (endTime.isBefore(startTime)) {
                return BAbsTime.END_OF_TIME;
            }
            BAbsTime result = BAbsTime.make((BAbsTime)from, (BTime)startTime);
            if (BTime.make((BAbsTime)from).isAfter(endTime)) {
                result = result.nextDay();
            }
            if (!daysOfWeek.includes(result)) {
                while (!daysOfWeek.includes(result)) {
                    result = result.nextDay();
                }
            }
            while (result.isBefore(from)) {
                result = result.add(interval);
            }
            return result;
        }
    }
}

