/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.comm;

import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.NMessage;
import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.common.CommonUtil;
import com.tridiumemea.micros.message.linkup.MicrosSocketHandshakeMsg;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.baja.util.Lexicon;

public final class MicrosLinkMessage
extends LinkMessage {
    private static final Lexicon LEX = Lexicon.make(BMicrosNetwork.class);
    private static final boolean debugEnabled = "true".equals(LEX.getText("linkMessageDebug"));
    private StringBuilder debugString;
    private static final int DEBUG_START_LENGTH = 32;
    private static final long SLEEP_BEFORE_READING_AGAIN = 200L;
    private static final String DEBUG_STRING_START = "LM>";
    private static final char DEBUG_STRING_END = '<';
    private static final char DEBUG_STRING_LENGTH = 'S';
    private static final char DEBUG_BYTES_LENGTH = 'B';
    private static final int DEAD_STREAM_OR_TCP_TIMEOUT_MINUS_1 = -1;
    static final int LM_MAX_LENGTH = 138;

    MicrosLinkMessage() {
        super(138);
        if (debugEnabled) {
            this.debugString = new StringBuilder(32);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean receive(InputStream in) throws IOException, InterruptedException {
        int leadingByte = in.read();
        boolean complete = false;
        if (leadingByte == 2) {
            try (OutputStream os = this.getOutputStream();){
                while (!complete) {
                    int currentChar = in.read();
                    if (currentChar > -1) {
                        if (currentChar != 3) {
                            os.write(currentChar);
                            if (!debugEnabled) continue;
                            this.debugString.append((char)currentChar);
                            continue;
                        }
                        os.write(0);
                        os.flush();
                        complete = true;
                        continue;
                    }
                    MicrosLinkMessage microsLinkMessage = this;
                    synchronized (microsLinkMessage) {
                        ((Object)((Object)this)).wait(200L);
                    }
                }
            }
        } else if (debugEnabled) {
            this.debugString.append("Missing frame start:").append((char)leadingByte);
        }
        this.outputAsDebugMsg();
        return complete;
    }

    private void outputAsDebugMsg() {
        if (debugEnabled) {
            this.debugString.insert(0, DEBUG_STRING_START);
            this.debugString.append('<').append('S').append(this.debugString.length()).append('B').append(this.getLength());
            CommonUtil.globalLog.info(this.debugString.toString());
            this.debugString.setLength(0);
        }
    }

    public String toString() {
        return new String(this.getByteArray(), Charset.forName("UTF-8"));
    }

    public boolean setMessage(NMessage msg) throws Exception {
        if (!(msg instanceof MicrosSocketHandshakeMsg)) {
            try (OutputStream os = this.getOutputStream();){
                os.write(2);
                msg.toOutputStream(this.getOutputStream());
                os.write(3);
                os.flush();
            }
        }
        this.address = msg.getAddress();
        return false;
    }
}

