/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.job;

import com.tridium.ndriver.comm.NMessage;
import com.tridiumemea.micros.BMicrosDevice;
import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.comm.BMicrosListener;
import com.tridiumemea.micros.comm.exception.MicrosDataSyncException;
import com.tridiumemea.micros.comm.flag.MicrosMessageFlag;
import com.tridiumemea.micros.common.CommonUtil;
import com.tridiumemea.micros.job.DatabaseSyncLoggable;
import com.tridiumemea.micros.message.MicrosMessage;
import com.tridiumemea.micros.message.datasync.MicrosDataSyncRequest;
import com.tridiumemea.micros.point.BMicrosPointDeviceExt;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.job.BSimpleJob;
import javax.baja.job.JobCancelException;
import javax.baja.job.JobLogItem;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="source", type="boolean", defaultValue="false", flags=65539, facets={@Facet(name="BFacets.TRUE_TEXT", value="BString.make(\"%lexicon(micros:ds.job.source.server)%\")"), @Facet(name="BFacets.FALSE_TEXT", value="BString.make(\"%lexicon(micros:ds.job.source.local)%\")")}), @NiagaraProperty(name="duration", type="baja:RelTime", defaultValue="BRelTime.DEFAULT", flags=65539), @NiagaraProperty(name="serverSyncStartRecieved", type="boolean", defaultValue="false", flags=65539), @NiagaraProperty(name="serverSyncEndRecieved", type="boolean", defaultValue="false", flags=65539), @NiagaraProperty(name="guestInCount", type="int", defaultValue="0", flags=65539), @NiagaraProperty(name="guestOutCount", type="int", defaultValue="0", flags=65539), @NiagaraProperty(name="totalRecievedCount", type="int", defaultValue="0", flags=65539), @NiagaraProperty(name="assumedCheckOutCount", type="int", defaultValue="0", flags=65539), @NiagaraProperty(name="unknownRoomCount", type="int", defaultValue="0", flags=65539)})
public final class BMicrosDatabaseSyncJob
extends BSimpleJob
implements DatabaseSyncLoggable {
    public static final Property source = BMicrosDatabaseSyncJob.newProperty((int)65539, (boolean)false, (BFacets)BFacets.make((BFacets)BFacets.make((String)"trueText", (BIDataValue)BString.make((String)"%lexicon(micros:ds.job.source.server)%")), (BFacets)BFacets.make((String)"falseText", (BIDataValue)BString.make((String)"%lexicon(micros:ds.job.source.local)%"))));
    public static final Property duration = BMicrosDatabaseSyncJob.newProperty((int)65539, (BValue)BRelTime.DEFAULT, null);
    public static final Property serverSyncStartRecieved = BMicrosDatabaseSyncJob.newProperty((int)65539, (boolean)false, null);
    public static final Property serverSyncEndRecieved = BMicrosDatabaseSyncJob.newProperty((int)65539, (boolean)false, null);
    public static final Property guestInCount = BMicrosDatabaseSyncJob.newProperty((int)65539, (int)0, null);
    public static final Property guestOutCount = BMicrosDatabaseSyncJob.newProperty((int)65539, (int)0, null);
    public static final Property totalRecievedCount = BMicrosDatabaseSyncJob.newProperty((int)65539, (int)0, null);
    public static final Property assumedCheckOutCount = BMicrosDatabaseSyncJob.newProperty((int)65539, (int)0, null);
    public static final Property unknownRoomCount = BMicrosDatabaseSyncJob.newProperty((int)65539, (int)0, null);
    public static final Type TYPE = Sys.loadType(BMicrosDatabaseSyncJob.class);
    private BAbsTime timeLastRecordWasSeen = BAbsTime.now();
    private BMicrosNetwork network;
    private BMicrosDevice device;
    private BMicrosListener listener;
    private Logger logger;
    private static final Lexicon lex = Lexicon.make(BMicrosDatabaseSyncJob.class);
    private static final String START_LOCAL_DS_MSG = lex.getText("ds.start.local.msg");
    private static final String START_REMOTE_DS_MSG = lex.getText("ds.start.remote.msg");
    private static final String DS_RECEIVED = lex.getText("ds.received");
    private static final String DS_CANCELLED = lex.getText("ds.cancelled");
    private static final String NO_RECORDS_RECEIVED = lex.getText("ds.empty.warning");
    private static final String DID_NOT_RECOGNISE_ANY_RECEIVED_ROOMS = lex.getText("ds.none.recognized");
    private static final String NOT_ATTEMPT_CHECKOUT_MSG = lex.getText("ds.not.attempting.auto.checkout");
    private static final String SUBMIT_VIA_NETWORK = "DS: Must submit Job via MicrosNetwork";
    private static final String JOB_INTERRUPT_MSG = "Job Interrupted while waiting for server to send end of db sync [DE]";
    private static final String DS_NOT_EXPECTED_RESPONSE_MSG = "DS: Not expected response";
    private static final String ERROR_REQUESTING_DS_WITH_SERVER = "Error requesting DS with server";
    private static final int SECONDS_TO_MS_FACTOR = 1000;
    private static final boolean LOCAL_SOURCE = false;

    public boolean getSource() {
        return this.getBoolean(source);
    }

    public void setSource(boolean v) {
        this.setBoolean(source, v, null);
    }

    public BRelTime getDuration() {
        return (BRelTime)this.get(duration);
    }

    public void setDuration(BRelTime v) {
        this.set(duration, (BValue)v, null);
    }

    public boolean getServerSyncStartRecieved() {
        return this.getBoolean(serverSyncStartRecieved);
    }

    public void setServerSyncStartRecieved(boolean v) {
        this.setBoolean(serverSyncStartRecieved, v, null);
    }

    public boolean getServerSyncEndRecieved() {
        return this.getBoolean(serverSyncEndRecieved);
    }

    public void setServerSyncEndRecieved(boolean v) {
        this.setBoolean(serverSyncEndRecieved, v, null);
    }

    public int getGuestInCount() {
        return this.getInt(guestInCount);
    }

    public void setGuestInCount(int v) {
        this.setInt(guestInCount, v, null);
    }

    public int getGuestOutCount() {
        return this.getInt(guestOutCount);
    }

    public void setGuestOutCount(int v) {
        this.setInt(guestOutCount, v, null);
    }

    public int getTotalRecievedCount() {
        return this.getInt(totalRecievedCount);
    }

    public void setTotalRecievedCount(int v) {
        this.setInt(totalRecievedCount, v, null);
    }

    public int getAssumedCheckOutCount() {
        return this.getInt(assumedCheckOutCount);
    }

    public void setAssumedCheckOutCount(int v) {
        this.setInt(assumedCheckOutCount, v, null);
    }

    public int getUnknownRoomCount() {
        return this.getInt(unknownRoomCount);
    }

    public void setUnknownRoomCount(int v) {
        this.setInt(unknownRoomCount, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMicrosDatabaseSyncJob() {
    }

    public BMicrosDatabaseSyncJob(BMicrosNetwork network, SOURCE isServerInitiated, Context cx) {
        Objects.requireNonNull(network, SUBMIT_VIA_NETWORK);
        this.logger = network.log();
        if (!network.isRunning() || !network.getLinkStatus().isLinkActive() || network.isFatalFault()) {
            this.abortStart("ds.link.inactive");
        } else if (network.getDsUtil().isCachedJobAlive()) {
            this.abortStart("ds.util.already.active");
        } else {
            if (this.logger != null) {
                this.logger.fine(() -> "DB Sync OK to proceed with new DS Job");
            }
            this.setSource(isServerInitiated == SOURCE.REMOTE);
            this.network = network;
            this.device = network.getDevice();
            this.listener = network.getEventListener();
            network.getDsUtil().setCachedJob(this);
            this.submit(cx);
        }
    }

    private void abortStart(String whyKey) {
        try {
            this.logger.warning(lex.getText(whyKey));
        }
        catch (NullPointerException noLogger) {
            CommonUtil.globalLog.log(Level.SEVERE, "Database SyncJob Orphaned from Logger", noLogger);
        }
        throw new LocalizableRuntimeException("micros", whyKey);
    }

    public void started() {
        this.network.setDatabaseSyncJobOrd(this.getSlotPathOrd());
    }

    private void audit(Context cx, String oldValue, String value) {
        Auditor auditor = Sys.getAuditor();
        if (auditor != null) {
            String target = this.network.getName() + " : " + this.device.getAddress().getIpAddress();
            String username = this.getSource() ? lex.getText("ds.job.source.server").toLowerCase() : (cx != null && cx.getUser() != null ? cx.getUser().getUsername() : lex.getText("ds.job.source.local").toLowerCase());
            AuditEvent auditEvent = new AuditEvent("Invoked", target, BMicrosNetwork.databaseSync.getName(), oldValue, value, username);
            auditor.audit(auditEvent);
        }
    }

    public void run(Context context) throws InterruptedException {
        this.log().start(this.getSource() ? START_REMOTE_DS_MSG : START_LOCAL_DS_MSG);
        if (!this.getSource()) {
            this.sendDataRequestToServer();
        }
        this.performDatabaseSync();
        this.writeJobLogSummary(this.device.getPoints().getProxyExtCount(), this.listener.getSwapFlagBuffer().size());
        String rcvd = "Received: " + this.getTotalRecievedCount();
        String asmd = "Assumed: " + this.getAssumedCheckOutCount();
        this.audit(context, rcvd, asmd);
        this.listener.getSwapFlagBuffer().clear();
        this.reportTerminalState(this.getTotalRecievedCount() > 0);
    }

    private void performDatabaseSync() throws InterruptedException {
        this.log().add(new JobLogItem(0, DS_RECEIVED, "DS"));
        this.setProgress(25);
        this.checkCancel();
        this.network.getDsUtil().restartDatabaseSyncTimer();
        this.device.getPoints().setAllPointsStaleDuringDataSync();
        try {
            while (!this.getServerSyncEndRecieved()) {
                Thread.sleep(500L);
                if (this.isAlive()) continue;
                throw new JobCancelException(JOB_INTERRUPT_MSG);
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw ie;
        }
        catch (JobCancelException jce) {
            this.logger.warning(jce.getMessage());
            this.log().endFailed(jce.getMessage());
            this.listener.getSwapFlagBuffer().clear();
            this.canceled();
            throw jce;
        }
        finally {
            this.setTotalRecievedCount(this.getGuestOutCount() + this.getGuestInCount());
            this.setDuration(this.getStartTime().delta(BAbsTime.now()));
        }
        this.checkCancel();
        this.vacateUnseenRooms();
    }

    private void sendDataRequestToServer() {
        MicrosMessage response;
        MicrosDataSyncRequest DR_request = new MicrosDataSyncRequest(this.device.getAddress());
        DR_request.setResponseTimeOut(this.network.getLinkConfig().getMsgResponseTimeout().getSeconds() * 1000);
        this.listener.factoryFlags.raise(MicrosMessageFlag.Flag.DATA_START);
        try {
            response = (MicrosMessage)this.network.getTcpConfig().tcomm().sendRequest((NMessage)DR_request);
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, ERROR_REQUESTING_DS_WITH_SERVER, e);
            throw new MicrosDataSyncException("Error requesting DS with server: " + e.getMessage(), e);
        }
        finally {
            this.listener.factoryFlags.lower(MicrosMessageFlag.Flag.DATA_START);
        }
        if (response == null || !response.getRecordID().equals("DS")) {
            MicrosDataSyncException incorrectResponseEx = new MicrosDataSyncException(DS_NOT_EXPECTED_RESPONSE_MSG);
            this.logger.log(Level.WARNING, DS_NOT_EXPECTED_RESPONSE_MSG, (Throwable)((Object)incorrectResponseEx));
            this.log().failed(DS_NOT_EXPECTED_RESPONSE_MSG, (Throwable)((Object)incorrectResponseEx));
            throw incorrectResponseEx;
        }
        this.logger.log(Level.FINE, DS_RECEIVED + " source isServer: " + this.getSource());
        this.setServerSyncStartRecieved(true);
    }

    private void vacateUnseenRooms() {
        boolean featureEnabled = this.network.getLinkConfig().getDatabaseSyncConfig().isPolicyToVacateUnseenRooms();
        if (featureEnabled && this.getTotalRecievedCount() > 0 && this.getUnknownRoomCount() != this.getTotalRecievedCount()) {
            BMicrosPointDeviceExt points = this.device.getPoints();
            try {
                int quantity = points.unseenRoomCheckout(this);
                this.setAssumedCheckOutCount(quantity);
            }
            catch (NullPointerException npe) {
                this.logger.log(Level.WARNING, "Job could not checkout SF buffer ", npe);
            }
        } else {
            this.log().add(new JobLogItem(0, NOT_ATTEMPT_CHECKOUT_MSG));
            this.logger.log(Level.INFO, NOT_ATTEMPT_CHECKOUT_MSG);
        }
    }

    private void reportTerminalState(boolean recievedAnyRoomRecords) {
        if (!recievedAnyRoomRecords || this.getUnknownRoomCount() >= this.getTotalRecievedCount()) {
            this.listener.reportEmptyDataSync();
            String errMsg = recievedAnyRoomRecords ? DID_NOT_RECOGNISE_ANY_RECEIVED_ROOMS : NO_RECORDS_RECEIVED;
            this.logger.warning(errMsg);
            throw new MicrosDataSyncException(errMsg);
        }
        this.log().success(TYPE.getModule().getModuleName(), "ds.finish");
        this.progress(100);
    }

    private void checkCancel() {
        if (!this.isAlive()) {
            this.log().failed(DS_CANCELLED);
            throw new MicrosDataSyncException(DS_CANCELLED);
        }
    }

    public BAbsTime getTimeLastRecordWasSeen() {
        return this.timeLastRecordWasSeen;
    }

    void setTimeLastRecordWasSeen() {
        this.timeLastRecordWasSeen = Clock.time((int)1000);
    }

    public static enum SOURCE {
        LOCAL,
        REMOTE;

    }
}

