/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.message;

import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.common.CommonUtil;
import com.tridiumemea.micros.enums.BMicrosMinibarRightsEnum;
import com.tridiumemea.micros.enums.BMicrosPayTvRightsEnum;
import javax.baja.nre.platform.RuntimeProfile;
import javax.baja.util.Lexicon;

public final class MicrosDictionary {
    public static final String SWAP_FLAG = "SF";
    public static final String LINK_DESCRIPTION = "LD";
    public static final String LINK_RECORD = "LR";
    public static final String LINK_CONFIG = "LC";
    public static final String ROOM_NUMBER = "RN";
    public static final String ROOM_EQUIPMENT = "RE";
    public static final String CLASS_OF_SERVICE = "CS";
    public static final String MINIBAR_RIGHTS_RECORD = "MR";
    public static final String TV_RIGHTS_RECORD = "TV";
    public static final byte FRAME_START = 2;
    public static final byte FRAME_END = 3;
    public static final char NULL_CHAR = '\u0000';
    public static final int MICROS_FIELD_LENGTH = 2;
    public static final char FIELD_SEPARATOR = '|';
    public static final String DATE = "DA";
    public static final String TIME = "TI";
    private static final Lexicon lex = Lexicon.make(BMicrosNetwork.class);
    public static final String UNSET_ROOM_NUMBER = lex.getText("unset.room.number");
    public static final Integer UNSET_GUEST_NUMBER = MicrosDictionary.attemptFetchingGuestNumber();
    public static final int CLOCK_TOLERANCE_MS = 1000;
    public static final String DRIVER_NAME = "micros";

    private MicrosDictionary() {
    }

    private static Integer attemptFetchingGuestNumber() {
        try {
            return Integer.parseInt(lex.getText("unset.guest.number"));
        }
        catch (NumberFormatException oops) {
            CommonUtil.globalLog.warning("Micros unset.guest.number in lexicon could not be converted to int");
            return -1;
        }
    }

    public static enum TV_RIGHTS {
        TU(3),
        TM(1),
        TX(2),
        TN(0);

        private final int niagaraEnum;

        private TV_RIGHTS(int niagaraEnum) {
            this.niagaraEnum = niagaraEnum;
        }

        public static String getRecord() {
            return MicrosDictionary.TV_RIGHTS_RECORD;
        }

        public BMicrosPayTvRightsEnum getNiagaraEnum() {
            return BMicrosPayTvRightsEnum.make(this.niagaraEnum);
        }
    }

    public static enum MINIBAR_RIGHTS {
        MU(2),
        MN(1),
        ML(0);

        private final int niagaraEnum;

        private MINIBAR_RIGHTS(int niagaraEnum) {
            this.niagaraEnum = niagaraEnum;
        }

        public static String getRecord() {
            return MicrosDictionary.MINIBAR_RIGHTS_RECORD;
        }

        public BMicrosMinibarRightsEnum getNiagaraEnum() {
            return BMicrosMinibarRightsEnum.make(this.niagaraEnum);
        }
    }

    public static final class GUEST_FIELD {
        public static final String OLD_ROOM_NUMBER = "RO";
        public static final String RESERVATION_NUMBER = "G#";
        public static final String TITLE = "GT";
        public static final String FORENAME = "GF";
        public static final String NAME = "GN";
        public static final String LANG = "GL";
        public static final String VIP = "GV";

        private GUEST_FIELD() {
        }
    }

    public static final class GUEST_RECORD {
        public static final String CHECK_IN = "GI";
        public static final String CHECK_OUT = "GO";
        public static final String CHANGE = "GC";

        private GUEST_RECORD() {
        }
    }

    public static final class LINK_CONFIG_FIELD {
        public static final String HOTEL_ID = "PH";
        public static final String PMS_VERSION = "A1";
        public static final String IFC_DRIVER_VERSION = "A3";
        public static final String IFC_VERSION = "A2";
        public static final String UNKNOWN_VERSION = "?";

        private LINK_CONFIG_FIELD() {
        }
    }

    public static final class LINK_RECORD_FIELD {
        public static final String RECORD_INDICATOR = "RI";
        public static final String FIELD_LIST = "FL";

        private LINK_RECORD_FIELD() {
        }
    }

    public static final class LINK_DESCRIPTION_FIELD {
        public static final String VERSION = "V#";
        public static final String MODULE_VERSION_VALUE = BMicrosNetwork.TYPE.getModule().getVendorVersion(RuntimeProfile.rt).toString();
        public static final String INTERFACE_FAMILY = "IF";
        public static final String INTERFACE_FAMILY_VALUE = "EM";
        public static final String LD_REQUEST_TYPE = "RT";
        public static final int RT_REQUEST_BITS_VALUE = 52;

        private LINK_DESCRIPTION_FIELD() {
        }
    }

    public static final class DATABASE_RECORD {
        public static final String REQUEST = "DR";
        public static final String START = "DS";
        public static final String END = "DE";

        private DATABASE_RECORD() {
        }
    }

    public static final class LINK_MANAGEMENT_RECORD {
        public static final String LINK_START = "LS";
        public static final String LINK_ACTIVE = "LA";
        public static final String LINK_END = "LE";

        private LINK_MANAGEMENT_RECORD() {
        }
    }
}

