/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.message;

import com.tridiumemea.micros.message.MicrosMessage;
import com.tridiumemea.micros.message.MicrosMessageField;
import java.nio.charset.Charset;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BTime;

final class MicrosMessageBuilder {
    private static final char ZERO_CHAR = '0';
    private static final int FRAME_BUFFER_STARTING_LENGTH = 40;
    private static final int DATE_TIME_BUFFER_STARTING_LENGTH = 8;

    private MicrosMessageBuilder() {
    }

    static byte[] build(MicrosMessage msg) {
        MicrosMessageField[] microsMessageFields;
        StringBuilder frameBuff = new StringBuilder(40);
        for (MicrosMessageField microsMessageField : microsMessageFields = msg.getFields()) {
            String fieldStr = microsMessageField.getFieldType();
            frameBuff.append(fieldStr);
            Object data = microsMessageField.getData();
            if (data != null) {
                String dataStr = data instanceof BAbsTime ? MicrosMessageBuilder.buildDate((BAbsTime)data) : (data instanceof BTime ? MicrosMessageBuilder.buildTime((BTime)data) : data.toString());
                frameBuff.append(dataStr);
            }
            frameBuff.append('|');
        }
        return frameBuff.toString().getBytes(Charset.forName("UTF-8"));
    }

    static String buildDate(BAbsTime date) {
        StringBuilder dateBuff = new StringBuilder(8);
        String yearStr = String.valueOf(date.getYear());
        dateBuff.append(yearStr, 2, 4);
        String monthStr = String.valueOf(date.getMonth().getMonthOfYear());
        MicrosMessageBuilder.leftPadZeroAppend(dateBuff, monthStr);
        String dayStr = String.valueOf(date.getDay());
        MicrosMessageBuilder.leftPadZeroAppend(dateBuff, dayStr);
        return dateBuff.toString();
    }

    static String buildTime(BTime time) {
        StringBuilder timeBuff = new StringBuilder(8);
        String hourStr = String.valueOf(time.getHour());
        MicrosMessageBuilder.leftPadZeroAppend(timeBuff, hourStr);
        String minuteStr = String.valueOf(time.getMinute());
        MicrosMessageBuilder.leftPadZeroAppend(timeBuff, minuteStr);
        String secondStr = String.valueOf(time.getSecond());
        MicrosMessageBuilder.leftPadZeroAppend(timeBuff, secondStr);
        return timeBuff.toString();
    }

    private static void leftPadZeroAppend(StringBuilder builder, String value) {
        if (value.length() == 1) {
            builder.append('0');
        }
        builder.append(value);
    }
}

