/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.message;

import com.tridium.ndriver.comm.IMessageFactory;
import com.tridium.ndriver.comm.LinkMessage;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.io.TypedInputStream;
import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.comm.BMicrosListener;
import com.tridiumemea.micros.comm.flag.MicrosMessageFlag;
import com.tridiumemea.micros.message.MicrosMessage;
import com.tridiumemea.micros.message.datasync.MicrosDataSyncEndNotification;
import com.tridiumemea.micros.message.datasync.MicrosDataSyncStartingResponseOrNotification;
import com.tridiumemea.micros.message.linkdown.MicrosLinkEndResponseOrNotification;
import com.tridiumemea.micros.message.linkup.MicrosLinkActiveResponseOrNotification;
import com.tridiumemea.micros.message.linkup.MicrosLinkConfigNotification;
import com.tridiumemea.micros.message.linkup.MicrosLinkStartResponseOrNotification;
import com.tridiumemea.micros.message.roomguest.MicrosGuestChangeNotification;
import com.tridiumemea.micros.message.roomguest.MicrosGuestInNotification;
import com.tridiumemea.micros.message.roomguest.MicrosGuestOutNotification;
import com.tridiumemea.micros.message.roomguest.MicrosPreArrivalRoomEquipmentNotification;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import javax.baja.sys.BajaRuntimeException;

public final class MicrosMessageFactory
implements IMessageFactory {
    private BMicrosNetwork network;
    private BMicrosListener listener;
    private static final String CLASS_NAME = MicrosMessageFactory.class.getSimpleName();
    private static final String MSG_FOUND_TXT = CLASS_NAME + ": Found ";
    private static final String READING_STREAM_ERR_MSG = "MicrosMessage: Error reading input stream: ";
    private static final String LEADING_BYTES_UNKNOWN_ERR_MSG = CLASS_NAME + ": Could not determine which message to create from leading bytes ";

    private MicrosMessageFactory() {
    }

    public MicrosMessageFactory(BMicrosNetwork network) {
        this.network = network;
        this.listener = network.getEventListener();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NMessage makeMessage(LinkMessage lm) throws IOException {
        try (TypedInputStream ti = new TypedInputStream(lm.getByteArray(), 0, lm.getLength());){
            MicrosMessage message;
            String msgType = ti.readCharArray(2);
            ti.reset();
            if (this.network.log() != null && this.network.log().isLoggable(Level.FINE)) {
                this.network.log().log(Level.FINE, MSG_FOUND_TXT + msgType);
            }
            if ((message = this.identifyMessage(msgType)) == null) {
                BajaRuntimeException err = new BajaRuntimeException(LEADING_BYTES_UNKNOWN_ERR_MSG + msgType);
                if (this.network.log() == null) throw err;
                this.network.log().log(Level.WARNING, CLASS_NAME, err);
                throw err;
            }
            message.fromInputStream((InputStream)ti);
            MicrosMessage microsMessage = message;
            return microsMessage;
        }
        catch (IOException | IllegalArgumentException | BajaRuntimeException e) {
            if (this.network.log() == null) throw e;
            this.network.log().log(Level.WARNING, READING_STREAM_ERR_MSG, e);
            throw e;
        }
    }

    private MicrosMessage identifyMessage(String msgType) {
        switch (msgType) {
            case "GI": {
                return new MicrosGuestInNotification();
            }
            case "GO": {
                return new MicrosGuestOutNotification();
            }
            case "GC": {
                return new MicrosGuestChangeNotification();
            }
            case "LC": {
                return new MicrosLinkConfigNotification();
            }
            case "RE": {
                return new MicrosPreArrivalRoomEquipmentNotification();
            }
            case "DS": {
                return new MicrosDataSyncStartingResponseOrNotification(this.listener.factoryFlags.isRaised(MicrosMessageFlag.Flag.DATA_START));
            }
            case "DE": {
                return new MicrosDataSyncEndNotification();
            }
            case "LE": {
                return new MicrosLinkEndResponseOrNotification(this.listener.factoryFlags.isRaised(MicrosMessageFlag.Flag.LINK_END));
            }
            case "LA": 
            case "LS": {
                boolean isResponse = this.listener.factoryFlags.isRaised(MicrosMessageFlag.Flag.LINK_MSG);
                if (this.network.getLinkStatus().isLinkActivating()) {
                    return new MicrosLinkActiveResponseOrNotification(isResponse);
                }
                return new MicrosLinkStartResponseOrNotification(isResponse);
            }
        }
        return null;
    }

    public String toString() {
        return CLASS_NAME;
    }
}

