/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.message.linkup;

import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.comm.exception.MicrosLinkNegotiationException;
import com.tridiumemea.micros.message.MicrosMessage;
import com.tridiumemea.micros.message.MicrosUnsolicitedNotification;
import com.tridiumemea.micros.message.linkup.MicrosLinkActiveMsg;
import java.util.logging.Level;

public final class MicrosLinkStartResponseOrNotification
extends MicrosMessage
implements MicrosUnsolicitedNotification {
    private final boolean factoryDeterminedIsResponse;
    private static final String LOGNAME = "LinkStartResponseOrNotification:";
    private static final String UNMATCHED_LS_ERR = "LinkStartResponseOrNotification::unsolicitedAction: Leading Field neither LS or LA = ";

    public MicrosLinkStartResponseOrNotification(boolean isResponse) {
        this.factoryDeterminedIsResponse = isResponse;
    }

    @Override
    public void unsolicitedAction(BMicrosNetwork network) {
        switch (this.getRecordID()) {
            case "LS": {
                network.getActivationUtil().sendSequence();
                break;
            }
            case "LA": {
                try {
                    network.sendAsync(new MicrosLinkActiveMsg(network.getDevice().getAddress()));
                }
                catch (Exception e) {
                    network.log().log(Level.WARNING, "LinkStartResponseOrNotification:Error sending LA Acknowledge", e);
                }
                break;
            }
            default: {
                throw new MicrosLinkNegotiationException(UNMATCHED_LS_ERR + this.getRecordID());
            }
        }
    }

    public boolean isResponse() {
        return this.factoryDeterminedIsResponse;
    }

    public Object getTag() {
        return "LinkStart";
    }
}

