/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.message.roomguest;

import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.message.roomguest.MicrosGuestEventNotification;
import com.tridiumemea.micros.message.roomguest.MicrosGuestInNotification;
import javax.baja.job.JobLogItem;
import javax.baja.util.Lexicon;

interface DatabaseSyncReportable {
    default public boolean proceedWithGuestEvent() {
        MicrosGuestEventNotification msg = (MicrosGuestEventNotification)((Object)this);
        if (msg.getRoomNumber() == null) {
            SUPPORT.logFailureToJob(MicrosGuestEventNotification.LOG_REASON.COULD_NOT_READ_ROOM_NUMBER, msg);
            return false;
        }
        if (msg.isRoomPresent(msg.getRoomNumber())) {
            SUPPORT.bufferSwapFlaggedRoom(msg);
            if (msg.isRoomProxyExtOperational()) {
                return true;
            }
            SUPPORT.logFailureToJob(MicrosGuestEventNotification.LOG_REASON.PROXY_DISABLED, msg);
        } else {
            SUPPORT.logFailureToJob(MicrosGuestEventNotification.LOG_REASON.ROOM_NOT_FOUND, msg);
        }
        return false;
    }

    public String getEventLogTitle();

    default public void logSuccessToJob(Integer newGuestNumber) {
        MicrosGuestEventNotification msg = (MicrosGuestEventNotification)((Object)this);
        if (msg.getNetwork().getDsUtil().isCachedJobAlive()) {
            StringBuilder jobLogDetail = new StringBuilder(32);
            jobLogDetail.append(SUPPORT.WORD_ROOM).append(msg.getRoomNumber());
            if (newGuestNumber != null) {
                jobLogDetail.append(SUPPORT.GUEST_NUM_TXT).append(msg.getProxy().getGuestReservationNumber());
            }
            SUPPORT.log(0, jobLogDetail.toString(), msg, true);
        }
    }

    public static final class SUPPORT {
        private static final Lexicon lex = Lexicon.make(BMicrosNetwork.class);
        private static final String WORD_ROOM = lex.getText("ds.room");
        private static final String GUEST_NUM_TXT = "  " + lex.getText("ds.guest.number");
        private static final int ASSUMED_LENGTH_OF_DETAIL = 32;

        private static void bufferSwapFlaggedRoom(MicrosGuestEventNotification msg) {
            if (msg.isAvailable("SF") && msg.net.getLinkConfig().getDatabaseSyncConfig().isPolicyToVacateUnseenRooms()) {
                msg.net.getEventListener().getSwapFlagBuffer().add(msg.getProxy().getRoomNumber());
            }
        }

        private static void logFailureToJob(MicrosGuestEventNotification.LOG_REASON reason, MicrosGuestEventNotification msg) {
            if (msg.getNetwork().getDsUtil().isCachedJobAlive()) {
                StringBuilder jobLogDetail = new StringBuilder(32);
                boolean roomFound = false;
                switch (reason) {
                    case ROOM_NOT_FOUND: {
                        jobLogDetail.append(reason.reasonText).append(msg.getRoomNumber());
                        break;
                    }
                    case PROXY_DISABLED: {
                        jobLogDetail.append(reason.reasonText).append(msg.getRoomNumber()).append(msg.getProxy().getStatus());
                        roomFound = true;
                        break;
                    }
                    case COULD_NOT_READ_ROOM_NUMBER: {
                        jobLogDetail.append(reason.reasonText).append(msg.toString());
                        break;
                    }
                    default: {
                        jobLogDetail.append("Invalid log message!");
                    }
                }
                SUPPORT.log(4, jobLogDetail.toString(), msg, roomFound);
            }
        }

        private static void log(int icon, String detail, MicrosGuestEventNotification msg, boolean roomFoundInStation) {
            String title = ((DatabaseSyncReportable)((Object)msg)).getEventLogTitle();
            JobLogItem jobLogItem = new JobLogItem(icon, title, detail);
            boolean incrementGiCounter = msg instanceof MicrosGuestInNotification;
            msg.net.getDsUtil().getCachedJob().updateJobProgress(jobLogItem, incrementGiCounter, roomFoundInStation);
        }
    }
}

