/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumemea.micros.message.roomguest;

import com.tridiumemea.micros.BMicrosNetwork;
import com.tridiumemea.micros.datatype.config.BMicrosLinkConfig;
import com.tridiumemea.micros.message.MicrosDictionary;
import com.tridiumemea.micros.message.MicrosMessage;
import com.tridiumemea.micros.message.MicrosUnsolicitedNotification;
import com.tridiumemea.micros.point.BMicrosProxyExt;
import java.util.Objects;
import java.util.logging.Level;

abstract class MicrosGuestEventNotification
extends MicrosMessage
implements MicrosUnsolicitedNotification {
    BMicrosNetwork net;
    BMicrosLinkConfig linkConfig;
    private BMicrosProxyExt proxy;
    private String roomNumber;
    private static final String NO_GUEST_NUM = "Guest reservation number missing from room ";

    MicrosGuestEventNotification() {
    }

    abstract void messageSpecificAction();

    @Override
    public void unsolicitedAction(BMicrosNetwork network) {
        this.net = network;
        this.linkConfig = network.getLinkConfig();
        this.roomNumber = this.extractRoomNumberFromMessage("RN");
        this.messageSpecificAction();
    }

    String extractRoomNumberFromMessage(String microsField) {
        Objects.requireNonNull(microsField);
        try {
            return (String)this.get(microsField).getData();
        }
        catch (IllegalArgumentException | NullPointerException iae) {
            this.logToConsole(microsField, LOG_REASON.COULD_NOT_READ_ROOM_NUMBER);
            throw iae;
        }
    }

    Integer extractGuestNumberFromMessage() {
        try {
            return (Integer)this.get("G#").getData();
        }
        catch (IllegalArgumentException fieldNotFound) {
            this.net.log().log(Level.INFO, NO_GUEST_NUM + this.proxy.getRoomNumber(), fieldNotFound);
            return MicrosDictionary.UNSET_GUEST_NUMBER;
        }
    }

    final boolean isRoomPresent(String roomNumber) {
        this.proxy = this.net.getDevice().getPoints().lookupProxyExt(roomNumber);
        if (this.proxy == null) {
            this.logToConsole(roomNumber, LOG_REASON.ROOM_NOT_FOUND);
            return false;
        }
        this.logToConsole(roomNumber, LOG_REASON.RESOLVED_ROOM);
        return true;
    }

    final boolean isRoomProxyExtOperational() {
        if (this.proxy != null && this.proxy.isUnoperational()) {
            this.logToConsole(this.proxy.getRoomNumber(), LOG_REASON.PROXY_DISABLED);
            return false;
        }
        return true;
    }

    private void logToConsole(String newRoomNumber, LOG_REASON reason) {
        String logMsg = "Unknown log";
        switch (reason) {
            case ROOM_NOT_FOUND: {
                logMsg = reason.reasonText + newRoomNumber;
                break;
            }
            case PROXY_DISABLED: {
                logMsg = reason.reasonText + newRoomNumber + ' ' + this.proxy.getStatus();
                break;
            }
            case RESOLVED_ROOM: {
                if (!this.net.log().isLoggable(reason.logLevel)) break;
                if (this.getProxy().getSlotPathOrd() != null) {
                    logMsg = reason.reasonText + '[' + newRoomNumber + "] => " + this.getProxy().getSlotPathOrd().toString();
                    break;
                }
                logMsg = "SlotPath Unknown " + newRoomNumber;
                break;
            }
            case COULD_NOT_READ_ROOM_NUMBER: {
                logMsg = reason.reasonText + this.toString();
            }
        }
        this.net.log().log(reason.logLevel, logMsg);
    }

    BMicrosProxyExt getProxy() {
        return this.proxy;
    }

    String getRoomNumber() {
        return this.roomNumber;
    }

    BMicrosNetwork getNetwork() {
        return this.net;
    }

    static enum LOG_REASON {
        ROOM_NOT_FOUND("roomMsg.roomNotFound", Level.CONFIG),
        PROXY_DISABLED("roomMsg.disabled", Level.CONFIG),
        RESOLVED_ROOM("roomMsg.resolveRoom", Level.FINER),
        COULD_NOT_READ_ROOM_NUMBER("roomMsg.noRoomNumber", Level.WARNING);

        final String reasonText;
        final Level logLevel;

        private LOG_REASON(String lexKey, Level logLevel) {
            this.reasonText = lex.getText(lexKey);
            this.logLevel = logLevel;
        }
    }
}

