/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumx.intrusionSmartKey.hx.commands;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.hx.ErrorDialog;
import com.tridium.hx.fieldeditors.BHxBooleanFE;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.smartTableHx.BHxSmartTableView;
import com.tridium.smartTableHx.SmartCommand;
import com.tridium.smartTableHx.tab.Tab;
import com.tridiumx.entsec.orionTools.RemoteUtil;
import com.tridiumx.entsecHx.securityUtilHx.alarm.EditAlarmClass;
import javax.baja.alarm.ext.BAlarmSourceExt;
import javax.baja.hx.BHxView;
import javax.baja.hx.Command;
import javax.baja.hx.HxOp;
import javax.baja.io.HtmlWriter;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class EditEntryPoint
extends EditAlarmClass {
    public static final String ENTRY = "entry";
    public static final String ALWAYS_ARMED = "alwaysArmed";

    public EditEntryPoint(BHxView view) {
        super(view);
    }

    public String getName(HxOp op) {
        return "editEntryPoint";
    }

    public String getPropertyName(HxOp op) {
        return ENTRY;
    }

    public String getSecondPropertyName(HxOp op) {
        return ALWAYS_ARMED;
    }

    public String getJavascriptPropertyPath(HxOp op) {
        return ".firstChild.nextSibling.nextSibling";
    }

    public BObject save(HxOp op) throws Exception {
        Tab tab = this.getTab(op);
        BBoolean entry = (BBoolean)tab.save();
        String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
        boolean disabledFix = false;
        BHxSmartTableView sView = (BHxSmartTableView)this.getView();
        if (!sView.isEnabled(op)) {
            disabledFix = true;
        }
        HtmlWriter out = op.getHtmlWriter();
        for (int i = 0; i < selectionList.length; ++i) {
            tab = this.getTab(i, op);
            BAlarmSourceExt alarmExt = (BAlarmSourceExt)tab.op.getComponent();
            alarmExt.lease();
            if (entry.getBoolean() && alarmExt.get(this.getSecondPropertyName(op)) instanceof BBoolean && ((BBoolean)alarmExt.get(this.getSecondPropertyName(op))).getBoolean()) {
                String message = alarmExt.toDisplayPathString((Context)op) + " cannot be both " + TextUtil.toFriendly((String)this.getSecondPropertyName(op)) + " and " + TextUtil.toFriendly((String)this.getPropertyName(op)) + ".";
                new ErrorDialog(this.getDisplayName(op), (Command)this, (Throwable)new Exception(message)).open(op);
                return op.get();
            }
            if (alarmExt.get(this.getPropertyName(op)) != null) {
                alarmExt.set(this.getPropertyName(op), (BValue)entry);
            } else {
                alarmExt.add(this.getPropertyName(op), (BValue)entry, 0x10000000);
            }
            if (!disabledFix) continue;
            String id = BHxSmartTableView.scopeId((String)alarmExt.getSlotPath().toString(), (HxOp)op);
            SmartCommand.tryException((HxOp)op);
            out.w((Object)("$('" + id + "')" + this.getJavascriptPropertyPath(op) + ".innerHTML='"));
            out.safe((Object)entry.toString((Context)op));
            out.w((Object)"';");
            SmartCommand.catchException((HxOp)op);
        }
        return entry;
    }

    public Tab getTab(HxOp op) {
        return this.getTab(0, op);
    }

    public Tab getTab(int row, HxOp op) {
        BHxBooleanFE fe = BHxBooleanFE.INSTANCE;
        String[] selectionList = SmartCommand.getSelectionList((HxOp)op);
        if (selectionList == null || row >= selectionList.length) {
            return null;
        }
        String rowId = selectionList[row];
        int idx = rowId.indexOf(59);
        BAlarmSourceExt ext = null;
        if (idx == -1) {
            BOrd ord = BOrd.make((String)("station:|" + BHxSmartTableView.unscopeId((String)rowId)));
            ext = (BAlarmSourceExt)ord.get();
        } else {
            String stationName = SlotPath.unescape((String)rowId.substring(0, idx));
            String slotPath = rowId.substring(idx + 1, rowId.length());
            BOrd ord = BOrd.make((String)("station:|" + slotPath));
            if (stationName.equals(Sys.getStation().getStationName())) {
                ext = (BAlarmSourceExt)ord.get();
            } else {
                BNiagaraNetwork nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
                BNiagaraStation station = (BNiagaraStation)nn.getNiagaraStation(stationName);
                BFoxSession foxSession = RemoteUtil.getFoxSession((BNiagaraStation)station);
                ext = (BAlarmSourceExt)RemoteUtil.getRemoteComponent((BFoxSession)foxSession, (String)ord.toString());
            }
            ext.lease();
        }
        BBoolean value = BBoolean.FALSE;
        if (ext.get(this.getPropertyName(op)) != null) {
            value = ext.get(this.getPropertyName(op));
        }
        HxOp extOp = op.make("ext", (BObject)ext, null);
        HxOp fieldOp = extOp.make(this.getName(op), (BObject)value, null);
        Tab tab = new Tab((BHxView)fe, "", fieldOp);
        return tab;
    }
}

