/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.neql;

import java.io.PrintWriter;
import javax.baja.neql.AstNode;
import javax.baja.neql.BinaryExpression;
import javax.baja.neql.ContextExpression;
import javax.baja.neql.EvalOnExpression;
import javax.baja.neql.NotExpression;
import javax.baja.neql.Projection;
import javax.baja.neql.Select;
import javax.baja.neql.TraverseOutExpression;

public class AstOut {
    private int currentIndent = 0;
    private static final String INDENT = "                                                                                ";
    private PrintWriter out;

    public AstOut(PrintWriter out) {
        this.out = out;
    }

    public void write(AstNode root) {
        switch (root.getNodeType()) {
            case 1: {
                this.out.print(this.indent());
                this.out.println(root);
                this.moreIndent();
                if (((Select)root).hasProjection()) {
                    this.write(((Select)root).getProjection());
                }
                if (((Select)root).hasPredicate()) {
                    this.write(((Select)root).getPredicate());
                }
                this.lessIndent();
                break;
            }
            case 2: {
                this.out.print(this.indent());
                this.out.println(root);
                this.moreIndent();
                Projection projection = (Projection)root;
                for (int i = 0; i < projection.getElementCount(); ++i) {
                    this.write(projection.getElement(i));
                }
                this.lessIndent();
                break;
            }
            case 3: 
            case 5: {
                this.out.print(this.indent());
                this.out.println(root);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                this.out.print(this.indent());
                this.out.println(root);
                this.moreIndent();
                this.write(((BinaryExpression)root).getLeft());
                this.write(((BinaryExpression)root).getRight());
                this.lessIndent();
                break;
            }
            case 14: {
                this.out.print(this.indent());
                this.out.println(root);
                this.moreIndent();
                this.write(((ContextExpression)root).getExpression());
                this.lessIndent();
                break;
            }
            case 15: {
                this.out.print(this.indent());
                this.out.println(root);
                this.moreIndent();
                this.write(((NotExpression)root).getExpression());
                this.lessIndent();
                break;
            }
            case 18: {
                this.out.print(this.indent());
                this.out.println(root);
                this.moreIndent();
                this.write(((TraverseOutExpression)root).getExpression());
                this.lessIndent();
                break;
            }
            case 19: {
                this.out.print(this.indent());
                this.out.println(root);
                this.moreIndent();
                this.write(((EvalOnExpression)root).getExpression());
                this.write(((EvalOnExpression)root).getTarget());
                this.lessIndent();
                break;
            }
            default: {
                this.out.print(this.indent());
                this.out.println(root);
            }
        }
    }

    public void flush() {
        this.out.flush();
    }

    private String indent() {
        return INDENT.substring(0, this.currentIndent);
    }

    public void moreIndent() {
        this.currentIndent += 3;
    }

    public void lessIndent() {
        this.currentIndent -= 3;
    }
}

