/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.neql;

import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.naming.BOrd;
import javax.baja.neql.Expression;
import javax.baja.security.BIProtected;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BMarker;
import javax.baja.sys.BNumber;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.Type;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.timezone.BTimeZone;
import javax.baja.units.BUnit;

public final class NeqlUtil {
    private static final Logger LOGGER = Logger.getLogger("neql");

    private NeqlUtil() {
    }

    public static String getNamespaceFromContext(Context context) {
        BString namespace = null;
        if (context != null) {
            namespace = (BString)context.getFacet("namespace");
        }
        return namespace != null ? namespace.getString() : "";
    }

    public static boolean equals(BIDataValue left, BIDataValue right) {
        Type rightType;
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        Type leftType = left.getType();
        if (!NeqlUtil.areEqualsOnlyTypes(leftType, rightType = right.getType())) {
            Integer result = NeqlUtil.compareValues(left, leftType, right, rightType);
            return result != null ? result == 0 : false;
        }
        if (leftType == rightType) {
            return left.equals(right);
        }
        if (leftType == BString.TYPE) {
            try {
                return ((BString)left).getString().equals(right.encodeToString());
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, e, () -> "Error while encoding values to Strings for equality check.");
            }
        } else if (rightType == BString.TYPE) {
            try {
                return left.encodeToString().equals(((BString)right).getString());
            }
            catch (IOException e) {
                LOGGER.log(Level.FINE, e, () -> "Error while encoding values to Strings for equality check.");
            }
        }
        return false;
    }

    public static Integer compareValues(BIDataValue left, BIDataValue right) {
        Type rightType;
        if (left == null || right == null) {
            return null;
        }
        Type leftType = left.getType();
        if (NeqlUtil.areEqualsOnlyTypes(leftType, rightType = right.getType())) {
            return null;
        }
        return NeqlUtil.compareValues(left, leftType, right, rightType);
    }

    private static boolean areEqualsOnlyTypes(Type leftType, Type rightType) {
        return leftType == BMarker.TYPE || rightType == BMarker.TYPE || leftType == BUnit.TYPE || rightType == BUnit.TYPE || leftType == BEnumRange.TYPE || rightType == BEnumRange.TYPE || leftType == BTimeZone.TYPE || rightType == BTimeZone.TYPE;
    }

    private static Integer compareValues(BIDataValue left, Type leftType, BIDataValue right, Type rightType) {
        if (leftType.is(BNumber.TYPE)) {
            return NeqlUtil.compareLeftNumber((BNumber)left, leftType, right, rightType);
        }
        if (leftType == BBoolean.TYPE) {
            return NeqlUtil.compareLeftBoolean((BBoolean)left, right, rightType);
        }
        if (leftType == BDynamicEnum.TYPE) {
            return NeqlUtil.compareLeftDynamicEnum((BDynamicEnum)left, right, rightType);
        }
        if (leftType == BAbsTime.TYPE) {
            return NeqlUtil.compareLeftAbsTime((BAbsTime)left, right, rightType);
        }
        if (leftType == BOrd.TYPE) {
            return NeqlUtil.compareLeftOrd((BOrd)left, right, rightType);
        }
        if (leftType == BRelTime.TYPE) {
            return NeqlUtil.compareLeftRelTime((BRelTime)left, right, rightType);
        }
        if (leftType == BString.TYPE) {
            return NeqlUtil.compareLeftString((BString)left, right, rightType);
        }
        return null;
    }

    public static int compareNumbers(BNumber left, Type leftType, BNumber right, Type rightType) {
        if (leftType == BDouble.TYPE || rightType == BDouble.TYPE) {
            return Double.compare(left.getDouble(), right.getDouble());
        }
        if (leftType == BFloat.TYPE || rightType == BFloat.TYPE) {
            return Float.compare(left.getFloat(), right.getFloat());
        }
        if (leftType == BLong.TYPE || rightType == BLong.TYPE) {
            return Long.compare(left.getLong(), right.getLong());
        }
        return Integer.compare(left.getInt(), right.getInt());
    }

    private static Integer compareLeftNumber(BNumber left, Type leftType, BIDataValue right, Type rightType) {
        if (rightType.is(BNumber.TYPE)) {
            return NeqlUtil.compareNumbers(left, leftType, (BNumber)right, rightType);
        }
        if (rightType == BDynamicEnum.TYPE && (leftType == BInteger.TYPE || leftType == BLong.TYPE)) {
            return Integer.compare(left.getInt(), ((BEnum)right).getOrdinal());
        }
        if (rightType == BRelTime.TYPE) {
            return Long.compare(left.getLong(), ((BRelTime)right).getMillis());
        }
        return null;
    }

    private static Integer compareLeftBoolean(BBoolean left, BIDataValue right, Type rightType) {
        if (rightType == BBoolean.TYPE) {
            return left.compareTo((Object)right);
        }
        if (rightType == BString.TYPE) {
            switch (((BString)right).getString()) {
                case "true": {
                    return left.compareTo((Object)BBoolean.TRUE);
                }
                case "false": {
                    return left.compareTo((Object)BBoolean.FALSE);
                }
            }
            return null;
        }
        return null;
    }

    private static int getOrdinal(String tag, BEnumRange enumRange) {
        int ordinal = enumRange == BEnumRange.NULL ? Integer.parseInt(tag) : enumRange.tagToOrdinal(tag);
        return ordinal;
    }

    private static Integer compareLeftDynamicEnum(BDynamicEnum left, BIDataValue right, Type rightType) {
        if (rightType == BInteger.TYPE || rightType == BLong.TYPE) {
            return Integer.compare(left.getOrdinal(), ((BNumber)right).getInt());
        }
        if (rightType == BDynamicEnum.TYPE) {
            BDynamicEnum rightEnum = (BDynamicEnum)right;
            if (left.getRange().equals((Object)rightEnum.getRange())) {
                return left.compareTo((Object)rightEnum);
            }
        } else if (rightType == BString.TYPE) {
            String rightTag = ((BString)right).getString();
            try {
                int rightOrdinal = NeqlUtil.getOrdinal(rightTag, left.getRange());
                return Integer.compare(left.getOrdinal(), rightOrdinal);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, e, () -> "Error converting right string " + rightTag + " to ordinal to compare with left dynamic enum " + left);
            }
        }
        return null;
    }

    private static Integer compareLeftAbsTime(BAbsTime left, BIDataValue right, Type rightType) {
        if (rightType == BAbsTime.TYPE) {
            return left.compareTo((Object)right);
        }
        if (rightType == BString.TYPE) {
            String rightString = ((BString)right).getString();
            try {
                return left.compareTo((Object)BAbsTime.make((String)rightString));
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, e, () -> "Error converting right string " + rightString + " to AbsTime to compare with left AbsTime");
            }
        }
        return null;
    }

    private static Integer compareLeftOrd(BOrd left, BIDataValue right, Type rightType) {
        if (rightType == BOrd.TYPE) {
            return left.compareTo((Object)right);
        }
        if (rightType == BString.TYPE) {
            return left.compareTo((Object)BOrd.make((String)((BString)right).getString()));
        }
        return null;
    }

    private static Integer compareLeftRelTime(BRelTime left, BIDataValue right, Type rightType) {
        if (rightType == BRelTime.TYPE) {
            return left.compareTo((Object)right);
        }
        if (rightType.is(BNumber.TYPE)) {
            return Long.compare(left.getMillis(), ((BNumber)right).getLong());
        }
        if (rightType == BString.TYPE) {
            String rightString = ((BString)right).getString();
            try {
                return left.compareTo((Object)BRelTime.make((String)rightString));
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, e, () -> "Error converting right string " + rightString + " to RelTime to compare with left RelTime");
            }
        }
        return null;
    }

    private static Integer compareLeftString(BString left, BIDataValue right, Type rightType) {
        if (rightType == BString.TYPE) {
            return left.compareTo((Object)right);
        }
        String leftString = left.getString();
        if (rightType == BBoolean.TYPE) {
            switch (leftString) {
                case "true": {
                    return BBoolean.TRUE.compareTo((Object)right);
                }
                case "false": {
                    return BBoolean.FALSE.compareTo((Object)right);
                }
            }
            return null;
        }
        if (rightType == BOrd.TYPE) {
            return BOrd.make((String)leftString).compareTo((Object)right);
        }
        if (rightType == BDynamicEnum.TYPE) {
            try {
                BDynamicEnum rightEnum = (BDynamicEnum)right;
                int leftOrdinal = NeqlUtil.getOrdinal(leftString, rightEnum.getRange());
                return Integer.compare(leftOrdinal, rightEnum.getOrdinal());
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, e, () -> "Error converting left string " + leftString + " to ordinal to compare with right dynamic enum " + right);
            }
        } else if (rightType == BAbsTime.TYPE) {
            try {
                return BAbsTime.make((String)leftString).compareTo((Object)right);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, e, () -> "Error converting left string " + leftString + " to AbsTime to compare with right AbsTime");
            }
        } else if (rightType == BRelTime.TYPE) {
            try {
                return BRelTime.make((String)leftString).compareTo((Object)right);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, e, () -> "Error converting left string " + leftString + " to RelTime to compare with right RelTime");
            }
        }
        return null;
    }

    public static Collection<BBoolean> searchForSingleLogicalBoolean(Collection<Object> evaluations) {
        for (Object val : evaluations) {
            if (val instanceof BBoolean) {
                BBoolean boolVal = (BBoolean)val;
                if (!boolVal.getBoolean()) continue;
                return Expression.SINGLE_TRUE;
            }
            return Expression.SINGLE_TRUE;
        }
        return Expression.SINGLE_FALSE;
    }

    public static Id getExpressionId(String key, String namespace, Context context) {
        Objects.requireNonNull(key);
        if (namespace == null || namespace.isEmpty()) {
            namespace = context != null ? NeqlUtil.getNamespaceFromContext(context) : "";
        }
        return Id.newId((String)namespace, (String)key);
    }

    public static boolean hasPermission(Entity entity, Context context) {
        return !(entity instanceof BIProtected) || ((BIProtected)entity).getPermissions(context).hasOperatorRead();
    }
}

