/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.neql;

import javax.baja.data.BIDataValue;
import javax.baja.neql.ContextExpression;
import javax.baja.neql.Expression;
import javax.baja.neql.GetTagExpression;
import javax.baja.neql.LiteralExpression;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.tag.Entity;

public abstract class BinaryExpression
extends Expression {
    private final Expression left;
    private final Expression right;

    protected BinaryExpression(Expression left, Expression right) {
        this.left = left;
        this.right = right;
    }

    public abstract String getSqlOperatorString();

    public final Expression getLeft() {
        return this.left;
    }

    public final Expression getRight() {
        return this.right;
    }

    static BIDataValue getSingleValue(Expression expression, Entity entity, Context context) {
        switch (expression.getNodeType()) {
            case 3: {
                return ((GetTagExpression)expression).getValue(entity, context);
            }
            case 5: {
                return ((LiteralExpression)expression).getValue();
            }
            case 14: {
                return ((ContextExpression)expression).getValue(context);
            }
            case 6: 
            case 7: 
            case 15: {
                throw new LocalizableRuntimeException("neql", "binaryExpression.getSingleValue.invalidLogicalExpression", new Object[]{expression.getClass().getSimpleName()});
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 20: {
                throw new LocalizableRuntimeException("neql", "binaryExpression.getSingleValue.invalidComparisonExpression", new Object[]{expression.getClass().getSimpleName()});
            }
        }
        throw new LocalizableRuntimeException("neql", "binaryExpression.getSingleValue.invalidExpression", new Object[]{expression.getClass().getSimpleName()});
    }
}

