/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.neql;

import com.tridium.neql.EvalOnIterator;
import java.io.IOException;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.baja.data.BIDataValue;
import javax.baja.neql.BinaryExpression;
import javax.baja.neql.EvalOnExpression;
import javax.baja.neql.Expression;
import javax.baja.neql.LiteralExpression;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.tag.Entity;

public class LikeExpression
extends BinaryExpression {
    private Pattern cachedPattern = null;

    public LikeExpression(Expression left, Expression right) {
        super(left, right);
    }

    @Override
    public int getNodeType() {
        return 20;
    }

    @Override
    public final String getSqlOperatorString() {
        return " like ";
    }

    public Collection<BBoolean> evaluate(Entity entity, Context context) {
        Collection<?> leftValues = this.getLeft().evaluate(entity, context);
        if (leftValues.isEmpty()) {
            return SINGLE_FALSE;
        }
        Collection<?> rightValues = this.getRight().evaluate(entity, context);
        if (rightValues.isEmpty()) {
            return SINGLE_FALSE;
        }
        BIDataValue rightValue = (BIDataValue)rightValues.iterator().next();
        if (rightValue.getType() != BString.TYPE) {
            return SINGLE_FALSE;
        }
        String regex = ((BString)rightValue).getString();
        try {
            Pattern pattern = Pattern.compile(regex);
            for (BIDataValue leftValue : leftValues) {
                Matcher matcher = pattern.matcher(leftValue.encodeToString());
                if (!matcher.matches()) continue;
                return SINGLE_TRUE;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return SINGLE_FALSE;
    }

    @Override
    protected final boolean evalBoolean(Entity entity, Context context) {
        Pattern pattern = this.getPattern();
        if (pattern == null) {
            return false;
        }
        Expression left = this.getLeft();
        if (left.getNodeType() == 19) {
            EvalOnExpression leftEvalOn = (EvalOnExpression)left;
            EvalOnIterator iterator = EvalOnIterator.make(leftEvalOn, entity, context);
            while (iterator.hasNext()) {
                BIDataValue leftValue = LikeExpression.getSingleValue(leftEvalOn.getExpression(), iterator.next(), context);
                try {
                    if (leftValue == null || !pattern.matcher(leftValue.encodeToString()).matches()) continue;
                    return true;
                }
                catch (IOException iOException) {
                }
            }
            return false;
        }
        BIDataValue leftValue = LikeExpression.getSingleValue(left, entity, context);
        if (leftValue == null) {
            return false;
        }
        try {
            return pattern.matcher(leftValue.encodeToString()).matches();
        }
        catch (IOException e) {
            return false;
        }
    }

    private Pattern getPattern() {
        BIDataValue rightValue;
        if (this.cachedPattern != null) {
            return this.cachedPattern;
        }
        Expression right = this.getRight();
        if (right instanceof LiteralExpression && (rightValue = ((LiteralExpression)right).getValue()).getType() == BString.TYPE) {
            this.cachedPattern = Pattern.compile(((BString)rightValue).getString());
        }
        return this.cachedPattern;
    }
}

