/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.neql;

import com.tridium.neql.ExprParser;
import com.tridium.neql.NeqlTokenizer;
import com.tridium.neql.NeqlUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import javax.baja.data.BIDataValue;
import javax.baja.neql.BinaryExpression;
import javax.baja.neql.ContextExpression;
import javax.baja.neql.EvalOnExpression;
import javax.baja.neql.Expression;
import javax.baja.neql.GetRelationExpression;
import javax.baja.neql.GetTagExpression;
import javax.baja.neql.LikeExpression;
import javax.baja.neql.LiteralExpression;
import javax.baja.neql.NotExpression;
import javax.baja.neql.TraverseInExpression;
import javax.baja.neql.TraverseOutExpression;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BIBoolean;
import javax.baja.sys.BIComparable;
import javax.baja.sys.BLong;
import javax.baja.sys.BNumber;
import javax.baja.sys.BString;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.tag.Entity;
import javax.baja.tag.Id;
import javax.baja.tag.Relation;

public class NeqlEntityEvaluator {
    public static Predicate<Entity> makePredicate(String expression) {
        return NeqlEntityEvaluator.makePredicate(expression, null);
    }

    public static Predicate<Entity> makePredicate(String expression, Context cx) {
        ExprParser parser = new ExprParser();
        Expression expr = parser.parse(new NeqlTokenizer(expression));
        return new EntityNeqlPredicate(expr, cx);
    }

    @Deprecated
    public boolean booleanEval(Context context, Entity contextEntity, Entity entity, Expression booleanExpression) {
        Object result = this.eval(context, contextEntity, entity, booleanExpression);
        if (result == null) {
            return false;
        }
        if (result instanceof BIBoolean) {
            return ((BIBoolean)result).getBoolean();
        }
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return true;
    }

    @Deprecated
    public Collection<BBoolean> booleanEvalAll(Context context, Entity entity, Expression booleanExpression) {
        Iterator<?> booleanValues = this.evalAll(context, entity, booleanExpression).iterator();
        LinkedList<BBoolean> booleanCollection = new LinkedList<BBoolean>();
        while (booleanValues.hasNext()) {
            Object current = booleanValues.next();
            if (current instanceof BBoolean) {
                booleanCollection.add((BBoolean)current);
                continue;
            }
            if (current instanceof Boolean) {
                booleanCollection.add(BBoolean.make((boolean)((Boolean)current)));
                continue;
            }
            booleanCollection.add(BBoolean.TRUE);
        }
        return booleanCollection;
    }

    @Deprecated
    public Object eval(Context context, Entity contextEntity, Entity entity, Expression expression) {
        if (entity == null) {
            return null;
        }
        int nodeType = expression.getNodeType();
        switch (nodeType) {
            case 3: {
                String namespace = ((GetTagExpression)expression).getNamespace();
                if (namespace == null || namespace.isEmpty()) {
                    namespace = NeqlUtil.getNamespaceFromContext(context);
                }
                String key = ((GetTagExpression)expression).getKey();
                Optional tag = entity.tags().get(Id.newId((String)namespace, (String)key));
                return tag.isPresent() ? tag.get() : null;
            }
            case 4: {
                String namespace = ((GetRelationExpression)expression).getNamespace();
                if (namespace == null || namespace.isEmpty()) {
                    namespace = NeqlUtil.getNamespaceFromContext(context);
                }
                String key = ((GetRelationExpression)expression).getKey();
                Optional orelation = entity.relations().get(Id.newId((String)namespace, (String)key));
                return orelation.isPresent() ? orelation.get() : null;
            }
            case 5: {
                return ((LiteralExpression)expression).getValue();
            }
            case 6: 
            case 7: {
                Expression left = ((BinaryExpression)expression).getLeft();
                Expression right = ((BinaryExpression)expression).getRight();
                boolean leftBool = this.booleanEval(context, contextEntity, entity, left);
                if (nodeType == 6) {
                    return leftBool ? BBoolean.make((boolean)this.booleanEval(context, contextEntity, entity, right)) : BBoolean.FALSE;
                }
                return leftBool ? BBoolean.TRUE : BBoolean.make((boolean)this.booleanEval(context, contextEntity, entity, right));
            }
            case 15: {
                Expression right = ((NotExpression)expression).getExpression();
                return this.booleanEval(context, contextEntity, entity, right) ? BBoolean.FALSE : BBoolean.TRUE;
            }
            case 8: 
            case 9: {
                Expression left = ((BinaryExpression)expression).getLeft();
                Expression right = ((BinaryExpression)expression).getRight();
                BIDataValue leftValue = (BIDataValue)this.eval(context, contextEntity, entity, left);
                BIDataValue rightValue = (BIDataValue)this.eval(context, contextEntity, entity, right);
                if (leftValue == null || rightValue == null) {
                    return BBoolean.FALSE;
                }
                return nodeType == 8 ? BBoolean.make((boolean)NeqlEntityEvaluator.equals(leftValue, rightValue)) : BBoolean.make((!NeqlEntityEvaluator.equals(leftValue, rightValue) ? 1 : 0) != 0);
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                Expression left = ((BinaryExpression)expression).getLeft();
                Expression right = ((BinaryExpression)expression).getRight();
                BIDataValue leftValue = (BIDataValue)this.eval(context, contextEntity, entity, left);
                BIDataValue rightValue = (BIDataValue)this.eval(context, contextEntity, entity, right);
                if (leftValue instanceof BIComparable && rightValue instanceof BIComparable) {
                    int compVal = 0;
                    int n = compVal = leftValue instanceof BNumber && rightValue instanceof BNumber ? NeqlEntityEvaluator.compareNumbers((BNumber)leftValue, (BNumber)rightValue) : ((BIComparable)leftValue).compareTo((Object)rightValue);
                    if (nodeType == 10) {
                        return BBoolean.make((compVal == -1 ? 1 : 0) != 0);
                    }
                    if (nodeType == 11) {
                        return BBoolean.make((compVal <= 0 ? 1 : 0) != 0);
                    }
                    if (nodeType == 12) {
                        return BBoolean.make((compVal == 1 ? 1 : 0) != 0);
                    }
                    return BBoolean.make((compVal >= 0 ? 1 : 0) != 0);
                }
                return BBoolean.FALSE;
            }
            case 14: {
                if (context == null) {
                    return BBoolean.FALSE;
                }
                GetTagExpression inner = (GetTagExpression)((ContextExpression)expression).getExpression();
                String key = inner.getKey();
                return context.getFacets().getFacet(key);
            }
            case 19: {
                Expression left = ((EvalOnExpression)expression).getExpression();
                Expression right = ((EvalOnExpression)expression).getTarget();
                Entity target = (Entity)this.eval(context, contextEntity, entity, right);
                return this.eval(context, contextEntity, target, left);
            }
            case 18: {
                Expression right = ((TraverseOutExpression)expression).getExpression();
                Relation relation = (Relation)this.eval(context, contextEntity, entity, right);
                return relation != null && relation.isOutbound() ? relation.getEndpoint() : null;
            }
            case 17: {
                Expression right = ((TraverseInExpression)expression).getExpression();
                Relation relation = (Relation)this.eval(context, contextEntity, entity, right);
                return relation != null && relation.isInbound() ? relation.getEndpoint() : null;
            }
            case 20: {
                Expression left = ((LikeExpression)expression).getLeft();
                Expression right = ((LikeExpression)expression).getRight();
                BIDataValue leftValue = (BIDataValue)this.eval(context, contextEntity, entity, left);
                BIDataValue rightValue = (BIDataValue)this.eval(context, contextEntity, entity, right);
                if (leftValue == null || rightValue == null || !(rightValue instanceof BString)) {
                    return BBoolean.FALSE;
                }
                try {
                    if (this.likeEval((BIDataValue)BString.make((String)leftValue.encodeToString()), rightValue)) {
                        return BBoolean.TRUE;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return BBoolean.FALSE;
            }
        }
        throw new UnsupportedOperationException("Unhandled expression type: " + nodeType);
    }

    public Collection<?> evalAll(Context context, Entity entity, Expression expression) {
        if (entity == null) {
            return Collections.emptyList();
        }
        return expression.evaluate(entity, context);
    }

    public boolean evalBoolean(Expression expression, Entity entity, Context context) {
        if (entity == null) {
            return false;
        }
        switch (expression.getNodeType()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                return expression.evalBoolean(entity, context);
            }
        }
        throw new LocalizableRuntimeException("neql", "neqlEntityEvaluator.evalBoolean.invalidExpression", new Object[]{expression.getClass().getSimpleName()});
    }

    private static boolean equals(BIDataValue left, BIDataValue right) {
        if (left instanceof BNumber) {
            return right instanceof BNumber && NeqlEntityEvaluator.compareNumbers((BNumber)left, (BNumber)right) == 0;
        }
        if (left == null && right == null) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        if (left instanceof BBoolean && right instanceof BString) {
            String leftStr = ((BBoolean)left).getBoolean() ? "true" : "false";
            return leftStr.equals(right.toString());
        }
        if (left.getType().is(right.getType())) {
            return left.equals(right);
        }
        try {
            return left.encodeToString().equals(right.encodeToString());
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private static int compareNumbers(BNumber left, BNumber right) {
        if (left instanceof BDouble || right instanceof BDouble) {
            return Double.compare(left.getDouble(), right.getDouble());
        }
        if (left instanceof BFloat || right instanceof BFloat) {
            return Float.compare(left.getFloat(), right.getFloat());
        }
        if (left instanceof BLong || right instanceof BLong) {
            return Long.compare(left.getLong(), right.getLong());
        }
        return Integer.compare(left.getInt(), right.getInt());
    }

    public boolean likeEval(BIDataValue left, BIDataValue right) {
        if (left instanceof BString && right instanceof BString) {
            return Pattern.matches(((BString)right).getString(), ((BString)left).getString());
        }
        return false;
    }

    private static final class EntityNeqlPredicate
    implements Predicate<Entity> {
        private final NeqlEntityEvaluator evaluator = new NeqlEntityEvaluator();
        private final Expression expression;
        private final Context context;

        private EntityNeqlPredicate(Expression expression, Context cx) {
            this.context = cx;
            this.expression = expression;
        }

        @Override
        public boolean test(Entity entity) {
            return this.evaluator.evalBoolean(this.expression, entity, this.context);
        }
    }
}

