/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.col;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;

public class PropName
extends MgrColumn {
    String propName;
    private static final Logger logger = Logger.getLogger("bacnet.ui");

    public PropName(String name, String propName, int flags) {
        super(name, flags);
        this.propName = propName;
    }

    public PropName(String propName, int flags) {
        this(propName, propName, flags);
    }

    public PropName(String propName) {
        this(propName, propName, 0);
    }

    public PropName(String name, String propName) {
        this(name, propName, 0);
    }

    public Object get(Object row) {
        if (((BComplex)row).loadSlots().getProperty(this.propName) == null) {
            return "";
        }
        return ((BComplex)row).propertyValueToString(((BComplex)row).getProperty(this.propName), null);
    }

    public BValue load(MgrEditRow row) {
        try {
            BValue v = row.getTarget().loadSlots().get(this.propName);
            if (v != null) {
                return v.newCopy();
            }
            logger.info("Property not found: " + this.propName);
            return null;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "exception in PropName.load(): propName=" + this.propName, e);
            logger.severe("row=" + row);
            if (row != null) {
                BComponent tgt = row.getTarget();
                logger.severe("tgt=" + tgt);
                if (tgt != null) {
                    logger.severe("typ=" + tgt.getType());
                    BValue v = tgt.loadSlots().get(this.propName);
                    logger.severe("get=" + v);
                }
            }
            return BString.make((String)"???");
        }
    }

    public void save(MgrEditRow row, BValue value, Context cx) {
        BComponent target = row.getTarget();
        Property prop = target.loadSlots().getProperty(this.propName);
        if (prop == null) {
            return;
        }
        BValue old = target.get(prop);
        if (!old.equivalent((Object)value)) {
            target.set(prop, value.newCopy(), cx);
        }
    }

    public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
        try {
            Property[] props = new Property[]{rows[0].getTarget().getProperty(this.propName)};
            if (props[0] == null) {
                return null;
            }
            return PropName.toFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)currentEditor, (Property[])props);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
        Property[] props = new Property[]{rows[0].getTarget().getProperty(this.propName)};
        if (props[0] == null) {
            return;
        }
        PropName.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, (Property[])props);
    }
}

