/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.fe;

import com.tridium.util.CompUtil;
import com.tridium.workbench.fieldeditors.BFrozenEnumFE;
import javax.baja.bacnet.datatypes.BBacnetChannelValue;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"bacnet:BacnetChannelValue"})})
@NiagaraAction(name="choiceChanged")
public class BBacnetChannelValueFE
extends BWbFieldEditor {
    @Generated
    public static final Action choiceChanged = BBacnetChannelValueFE.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetChannelValueFE.class);
    private final BGridPane editPane = new BGridPane(2);
    private final BFrozenEnumFE choiceEditor = new BFrozenEnumFE();
    private BWbFieldEditor valueEditor;
    private BLink valueEditorLink1;
    private BLink valueEditorLink2;

    @Generated
    public void choiceChanged() {
        this.invoke(choiceChanged, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetChannelValueFE() {
        this.editPane.add("choiceEditor", (BValue)this.choiceEditor);
        this.linkTo("choiceEditorLink1", (BComponent)this.choiceEditor, (Slot)BWbPlugin.pluginModified, (Slot)choiceChanged);
        this.linkTo("choiceEditorLink2", (BComponent)this.choiceEditor, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo("choiceEditorLink3", (BComponent)this.choiceEditor, (Slot)BWbPlugin.actionPerformed, (Slot)actionPerformed);
        this.setContent((BWidget)this.editPane);
    }

    protected void doSetReadonly(boolean readonly) {
        this.choiceEditor.setEnabled(!readonly);
        if (this.valueEditor != null) {
            this.valueEditor.setReadonly(readonly);
        }
    }

    protected void doLoadValue(BObject value, Context cx) {
        BBacnetChannelValue channelValue = (BBacnetChannelValue)value;
        int choice = channelValue.getChoice();
        BDynamicEnum choiceEnum = BDynamicEnum.make((int)choice, (BEnumRange)BBacnetChannelValue.getChoiceRange());
        this.choiceEditor.loadValue((BObject)choiceEnum, cx);
        this.choiceChanged();
        BValue channelValueValue = channelValue.getValue();
        if (channelValueValue == null) {
            this.removeValueEditor();
            return;
        }
        this.valueEditor.loadValue((BObject)channelValueValue, cx);
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        BBacnetChannelValue channelValue = (BBacnetChannelValue)value;
        int newChoice = ((BEnum)this.choiceEditor.saveValue(cx)).getOrdinal();
        String slotName = BBacnetChannelValue.getSlotName((int)newChoice);
        if (slotName == null) {
            throw new CannotSaveException("Choice value not supported: " + newChoice);
        }
        if (this.valueEditor == null) {
            throw new CannotSaveException("Missing value editor for choice " + newChoice);
        }
        BValue newValue = (BValue)this.valueEditor.saveValue(null);
        int oldChoice = channelValue.getChoice();
        if (oldChoice != newChoice) {
            channelValue.removeAll(cx);
        }
        CompUtil.setOrAdd((BComponent)channelValue, (String)slotName, (BValue)newValue, (Context)cx);
        channelValue.setInt(BBacnetChannelValue.choice, newChoice, cx);
        return channelValue;
    }

    public void doChoiceChanged(Context context) {
        BValue defaultValue = null;
        try {
            int choice = ((BDynamicEnum)this.choiceEditor.saveValue()).getOrdinal();
            defaultValue = BBacnetChannelValue.getDefaultValue((int)choice);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (defaultValue == null) {
            this.removeValueEditor();
            return;
        }
        if (this.valueEditor == null) {
            this.addValueEditor((BObject)defaultValue, context);
            return;
        }
        if (!defaultValue.getType().equals(this.valueEditor.getCurrentValue().getType())) {
            this.removeValueEditor();
            this.addValueEditor((BObject)defaultValue, context);
        }
    }

    private void addValueEditor(BObject channelValueValue, Context cx) {
        this.valueEditor = BWbFieldEditor.makeFor((BObject)channelValueValue, (Context)cx);
        this.valueEditor.loadValue(channelValueValue, cx);
        this.valueEditor.setReadonly(this.isReadonly());
        this.editPane.add("valueEditor", (BValue)this.valueEditor, cx);
        this.valueEditorLink1 = this.linkTo("valueEditorLink1", (BComponent)this.valueEditor, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.valueEditorLink2 = this.linkTo("valueEditorLink2", (BComponent)this.valueEditor, (Slot)BWbPlugin.actionPerformed, (Slot)actionPerformed);
    }

    private void removeValueEditor() {
        if (this.valueEditor != null) {
            this.editPane.remove((BComplex)this.valueEditor);
            this.remove((BComplex)this.valueEditorLink1);
            this.remove((BComplex)this.valueEditorLink2);
            this.valueEditor = null;
            this.valueEditorLink1 = null;
            this.valueEditorLink2 = null;
        }
    }
}

