/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.fe;

import javax.baja.bacnet.datatypes.BBacnetObjectIdentifier;
import javax.baja.bacnet.enums.BBacnetObjectType;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BTextDropDown;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"bacnet:BacnetObjectIdentifier"})})
public class BBacnetObjectIdentifierFE
extends BWbFieldEditor {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetObjectIdentifierFE.class);
    private BGridPane editPane = new BGridPane(2);
    private BTextDropDown objectType = new BTextDropDown("", 15, true);
    private BTextField instanceNumber = new BTextField();
    private BBacnetObjectIdentifier id;
    private BEnumRange range;
    static UiLexicon lex = UiLexicon.makeUiLexicon(BBacnetObjectIdentifierFE.class);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetObjectIdentifierFE() {
        this.setContent((BWidget)this.editPane);
        this.editPane.add("objectType", (BValue)this.objectType);
        this.editPane.add("instanceNumber", (BValue)this.instanceNumber);
        this.linkTo("lk0", (BComponent)this.objectType, (Slot)BTextDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.objectType, (Slot)BTextDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk2", (BComponent)this.instanceNumber, (Slot)BTextField.textModified, (Slot)setModified);
        this.linkTo("lk3", (BComponent)this.instanceNumber, (Slot)BTextField.actionPerformed, (Slot)actionPerformed);
    }

    protected void doSetReadonly(boolean readonly) {
        this.objectType.getEditor().setEditable(!readonly);
        this.objectType.setDropDownEnabled(!readonly);
        this.instanceNumber.setEditable(!readonly);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.id = (BBacnetObjectIdentifier)value;
        if (cx != null) {
            this.range = (BEnumRange)cx.getFacet("range");
        }
        if (this.range == null) {
            this.range = BBacnetObjectType.isFixed((int)this.id.getObjectType()) ? BEnumRange.make((Type)BBacnetObjectType.TYPE) : BEnumRange.make((Type)BBacnetObjectType.TYPE, (int[])new int[]{this.id.getObjectType()}, (String[])new String[]{BBacnetObjectType.tag((int)this.id.getObjectType())});
        }
        int maxLen = 15;
        this.objectType.getList().removeAllItems();
        int[] ordinals = this.range.getOrdinals();
        for (int i = 0; i < ordinals.length; ++i) {
            int ord = ordinals[i];
            String tag = this.range.getDisplayTag(ord, null);
            this.objectType.getList().addItem((Object)tag);
            maxLen = Math.max(maxLen, tag.length());
        }
        this.objectType.getEditor().setVisibleColumns(maxLen);
        this.objectType.setText(this.range.getDisplayTag(this.id.getObjectType(), null));
        this.instanceNumber.setText(Integer.toString(this.id.getInstanceNumber()));
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        int objType = this.saveToObjectType();
        int instNum = Integer.parseInt(this.instanceNumber.getText());
        if (instNum > 0x3FFFFF) {
            throw new IllegalArgumentException(lex.getText("bacnetObjectIdentifier.invalidInstanceNumber"));
        }
        return BBacnetObjectIdentifier.make((int)objType, (int)instNum);
    }

    int saveToObjectType() {
        String tag = this.objectType.getText();
        int[] ordinals = this.range.getOrdinals();
        for (int i = 0; i < ordinals.length; ++i) {
            int ordinal = ordinals[i];
            String displayTag = this.range.getDisplayTag(ordinal, null);
            if (!tag.equals(displayTag)) continue;
            return ordinal;
        }
        if (tag.startsWith("0x")) {
            return Integer.parseInt(tag.substring(2), 16);
        }
        return Integer.parseInt(tag);
    }
}

