/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.fe;

import com.tridium.bacnet.ui.fe.BBacnetNullFE;
import javax.baja.bacnet.datatypes.BBacnetNull;
import javax.baja.bacnet.datatypes.BBacnetPriorityValue;
import javax.baja.bacnet.datatypes.BBacnetUnsigned;
import javax.baja.bacnet.enums.BBacnetBinaryPv;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFloat;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BGridPane;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

@NiagaraType(agent={@AgentOn(types={"bacnet:BacnetPriorityValue"})})
@NiagaraAction(name="loadValueEditor")
public class BBacnetPriorityValueFE
extends BWbFieldEditor {
    @Generated
    public static final Action loadValueEditor = BBacnetPriorityValueFE.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetPriorityValueFE.class);
    private BGridPane editPane = new BGridPane(2);
    private BListDropDown ce = new BListDropDown();
    private BWbFieldEditor ve = new BBacnetNullFE();
    private BBacnetPriorityValue pv;
    private Context cx = null;
    private static String[] PV = new String[]{"NULL", "Real", "Double", "Binary", "Integer", "String"};
    private static final int NULL_INDEX = 0;
    private static final int REAL_INDEX = 1;
    private static final int DOUBLE_INDEX = 2;
    private static final int BINARY_INDEX = 3;
    private static final int INTEGER_INDEX = 4;
    private static final int STRING_INDEX = 5;
    private static final int CONSTRUCTED_INDEX = 6;
    private static final Context load = new BasicContext(){

        public String toString() {
            return "PValFE.load";
        }
    };

    @Generated
    public void loadValueEditor() {
        this.invoke(loadValueEditor, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BBacnetPriorityValueFE() {
        this.ce.getList().removeAllItems();
        for (String choice : PV) {
            this.ce.getList().addItem((Object)choice);
        }
        this.editPane.add("choice", (BValue)this.ce);
        this.editPane.add("value", (BValue)this.ve);
        this.linkTo("lk0", (BComponent)this.ce, (Slot)BListDropDown.valueModified, (Slot)setModified);
        this.linkTo("lk1", (BComponent)this.ce, (Slot)BListDropDown.actionPerformed, (Slot)actionPerformed);
        this.linkTo("lk2", (BComponent)this.ce, (Slot)BListDropDown.valueModified, (Slot)loadValueEditor);
        this.setContent((BWidget)this.editPane);
    }

    protected void doSetReadonly(boolean readonly) {
        this.ce.setDropDownEnabled(!readonly);
        this.ve.setReadonly(readonly);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.pv = (BBacnetPriorityValue)value;
        this.cx = load;
        this.ce.setSelectedItem((Object)this.pv.choiceName());
        this.cx = null;
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        this.pv = (BBacnetPriorityValue)value;
        BValue v = (BValue)this.ve.saveValue(cx);
        this.pv.setPriorityValue(v, cx);
        return this.pv;
    }

    public void doLoadValueEditor() {
        try {
            this.editPane.remove("value");
            this.remove("lk3");
            this.remove("lk4");
        }
        catch (NoSuchSlotException noSuchSlotException) {
            // empty catch block
        }
        BSimple v = this.pv.getValue();
        if (this.cx != load) {
            switch (this.ce.getSelectedIndex()) {
                case 0: {
                    v = BBacnetNull.DEFAULT;
                    break;
                }
                case 1: {
                    v = BFloat.DEFAULT;
                    break;
                }
                case 2: {
                    v = BDouble.DEFAULT;
                    break;
                }
                case 3: {
                    v = BBacnetBinaryPv.DEFAULT;
                    break;
                }
                case 4: {
                    v = BBacnetUnsigned.DEFAULT;
                    break;
                }
                case 5: {
                    v = BString.DEFAULT;
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid/unsupported PriorityValue choice!");
                }
            }
        }
        this.ve = BWbFieldEditor.makeFor((BObject)v);
        this.linkTo("lk3", (BComponent)this.ve, (Slot)BWbPlugin.pluginModified, (Slot)setModified);
        this.linkTo("lk4", (BComponent)this.ve, (Slot)BWbPlugin.actionPerformed, (Slot)actionPerformed);
        this.editPane.add("value", (BValue)this.ve);
        this.ve.loadValue((BObject)v, this.cx);
        this.cx = null;
    }
}

