/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.ip;

import com.tridium.bacnet.stack.link.ip.BFdtEntry;
import com.tridium.bacnet.stack.link.ip.BForeignDeviceTable;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.DefaultTableModel;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"bacnet:ForeignDeviceTable"}, requiredPermissions="W")})
public class BFdtManager
extends BWbComponentView {
    @Generated
    public static final Type TYPE = Sys.loadType(BFdtManager.class);
    private BTable table;
    private DefaultTableModel model = new DefaultTableModel(colNames);
    private Command newCmd;
    private Command editCmd;
    private Command deleteCmd;
    private static UiLexicon lex = UiLexicon.makeUiLexicon(BFdtManager.class);
    private static String[] colNames = new String[]{lex.getText("bdtfdt.bipAddr"), lex.getText("bdtfdt.timeToLive"), lex.getText("bdtfdt.purgeTime")};

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BFdtManager() {
        this.table = new BTable((TableModel)this.model);
        this.table.setSelection((TableSelection)new Selection());
        BGridPane buttonPane = this.makeButtonPane();
        BEdgePane content = new BEdgePane();
        content.setCenter((BWidget)this.table);
        content.setBottom((BWidget)new BBorderPane((BWidget)buttonPane, 5.0, 5.0, 0.0, 5.0));
        this.setContent((BWidget)content);
    }

    public BMenu[] getViewMenus() {
        return null;
    }

    public BToolBar getViewToolBar() {
        BToolBar bar = new BToolBar();
        return bar;
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        this.registerForComponentEvents((BComponent)((BForeignDeviceTable)value));
        this.updateTable((BForeignDeviceTable)value);
    }

    public void handleComponentEvent(BComponentEvent event) {
        this.updateTable(this.getFDT());
    }

    private void updateTable(BForeignDeviceTable fdt) {
        this.model.removeAllRows();
        BFdtEntry[] kids = (BFdtEntry[])fdt.getChildren(BFdtEntry.class);
        for (int i = 0; i < kids.length; ++i) {
            this.model.addRow(new Object[]{kids[i].getBacnetIPAddress(), kids[i].getTimeToLive(), kids[i].getPurgeTime()});
        }
        this.table.setModel((TableModel)this.model);
        this.table.relayout();
        this.updateCommands();
    }

    private BForeignDeviceTable getFDT() {
        return (BForeignDeviceTable)this.getCurrentValue();
    }

    private BGridPane makeButtonPane() {
        BInsets insets = BInsets.make((double)5.0, (double)5.0, (double)5.0, (double)5.0);
        BGridPane buttonPane = new BGridPane();
        this.newCmd = new New((BWidget)this);
        this.editCmd = new Edit((BWidget)this);
        this.deleteCmd = new Delete((BWidget)this);
        BAbstractButton bNew = BAbstractButton.make((Command)this.newCmd);
        BAbstractButton bEdit = BAbstractButton.make((Command)this.editCmd);
        BAbstractButton bDelete = BAbstractButton.make((Command)this.deleteCmd);
        bNew.setPadding(insets);
        bEdit.setPadding(insets);
        bDelete.setPadding(insets);
        buttonPane.add("bNew", (BValue)bNew);
        buttonPane.add("bEdit", (BValue)bEdit);
        buttonPane.add("bDelete", (BValue)bDelete);
        buttonPane.setColumnCount(3);
        return buttonPane;
    }

    private void updateCommands() {
        int selxn = this.table.getSelection().getRowCount();
        boolean sel = selxn > 0;
        this.editCmd.setEnabled(sel);
        this.deleteCmd.setEnabled(sel);
    }

    public CommandArtifact doNew() throws Exception {
        BFdtEntry entry = (BFdtEntry)BWbFieldEditor.dialog((BWidget)this, (String)this.newCmd.getLabel(), (BObject)new BFdtEntry());
        if (entry == null) {
            return null;
        }
        if (!entry.isAddressValid()) {
            BDialog.error((BWidget)this, (Object)lex.getText("bdtfdt.error.invalidAddress"));
            return null;
        }
        BForeignDeviceTable fdt = this.getFDT();
        fdt.add(null, (BValue)entry);
        this.updateTable(fdt);
        return null;
    }

    public CommandArtifact doEdit() throws Exception {
        int[] rows = this.table.getSelection().getRows();
        if (rows.length != 1) {
            return null;
        }
        BForeignDeviceTable fdt = this.getFDT();
        BFdtEntry entry = new BFdtEntry((String)this.model.getValueAt(rows[0], 0), ((Integer)this.model.getValueAt(rows[0], 1)).intValue(), (BAbsTime)this.model.getValueAt(rows[0], 2));
        entry = (BFdtEntry)BWbFieldEditor.dialog((BWidget)this, (String)this.newCmd.getLabel(), (BObject)entry);
        if (entry == null) {
            return null;
        }
        if (!entry.isAddressValid()) {
            BDialog.error((BWidget)this, (Object)lex.getText("bdtfdt.error.invalidAddress"));
            return null;
        }
        fdt.modifyEntry(rows[0], entry);
        this.updateTable(fdt);
        return null;
    }

    public CommandArtifact doDelete() throws Exception {
        int[] rows = this.table.getSelection().getRows();
        BForeignDeviceTable fdt = this.getFDT();
        BFdtEntry[] kids = (BFdtEntry[])fdt.getChildren(BFdtEntry.class);
        if (kids != null && rows.length <= kids.length) {
            for (int i = 0; i < rows.length; ++i) {
                fdt.remove((BComplex)kids[rows[i]]);
            }
            this.updateTable(fdt);
        }
        return null;
    }

    class Delete
    extends Command {
        Delete(BWidget owner) {
            super(owner, (Lexicon)lex, "bdtfdt.delete");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BFdtManager.this.doDelete();
        }
    }

    class Edit
    extends Command {
        Edit(BWidget owner) {
            super(owner, (Lexicon)lex, "bdtfdt.edit");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BFdtManager.this.doEdit();
        }
    }

    class New
    extends Command {
        New(BWidget owner) {
            super(owner, (Lexicon)lex, "bdtfdt.new");
        }

        public CommandArtifact doInvoke() throws Exception {
            return BFdtManager.this.doNew();
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BFdtManager.this.updateCommands();
        }
    }
}

