/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.bacnet.ui.schedule;

import com.tridium.bacnet.job.BDiscoverySchedule;
import com.tridium.bacnet.schedule.BBacnetScheduleDeviceExt;
import com.tridium.bacnet.schedule.BBacnetScheduleImportExt;
import com.tridium.bacnet.ui.schedule.ScheduleLearn;
import com.tridium.bacnet.ui.schedule.ScheduleState;
import javax.baja.bacnet.BBacnetDevice;
import javax.baja.driver.schedule.BScheduleDeviceExt;
import javax.baja.driver.schedule.BScheduleImportExt;
import javax.baja.driver.ui.schedule.BScheduleImportManager;
import javax.baja.driver.ui.schedule.ScheduleImportController;
import javax.baja.driver.ui.schedule.ScheduleImportModel;
import javax.baja.driver.util.BDescriptor;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.schedule.BAbstractSchedule;
import javax.baja.schedule.BBooleanSchedule;
import javax.baja.schedule.BEnumSchedule;
import javax.baja.schedule.BNumericSchedule;
import javax.baja.schedule.BStringSchedule;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.CommandArtifact;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;

@NiagaraType(agent={@AgentOn(types={"bacnet:BacnetScheduleDeviceExt"}, requiredPermissions="W")})
public class BBacnetScheduleImportManager
extends BScheduleImportManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BBacnetScheduleImportManager.class);
    private static final MgrTypeInfo[] ALL_SCHEDULE_TYPES = new MgrTypeInfo[]{MgrTypeInfo.make((Type)BEnumSchedule.TYPE), MgrTypeInfo.make((Type)BBooleanSchedule.TYPE), MgrTypeInfo.make((Type)BNumericSchedule.TYPE), MgrTypeInfo.make((Type)BStringSchedule.TYPE)};
    private BBacnetScheduleDeviceExt deviceExt;
    MgrColumn objectIdCol = new ScheduleImportModel.Ext(BBacnetScheduleImportExt.objectId, 1);

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject obj, Context cx) {
        this.deviceExt = (BBacnetScheduleDeviceExt)obj;
        super.doLoadValue(obj, cx);
    }

    public void restoreState() {
        MgrState state = MgrState.getCached((String)ScheduleState.toKey(this));
        if (state != null) {
            state.restore((BAbstractManager)this);
        }
    }

    public void saveState() {
        MgrState state = this.makeState();
        if (state != null) {
            state.save((BAbstractManager)this);
            MgrState.cache((String)ScheduleState.toKey(this), (MgrState)state);
        }
    }

    protected MgrController makeController() {
        return new Controller(this);
    }

    protected MgrLearn makeLearn() {
        return new Learn(this);
    }

    protected MgrModel makeModel() {
        return new Model(this);
    }

    protected MgrState makeState() {
        return ScheduleState.getState();
    }

    public BBacnetScheduleDeviceExt getDeviceExt() {
        if (this.deviceExt != null) {
            return this.deviceExt;
        }
        return (BBacnetScheduleDeviceExt)this.getCurrentValue();
    }

    public BBacnetDevice getDevice() {
        return (BBacnetDevice)this.getDeviceExt().getDevice();
    }

    class Controller
    extends ScheduleImportController {
        public Controller(BBacnetScheduleImportManager manager) {
            super((BScheduleImportManager)manager);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            BOrd jobOrd = BBacnetScheduleImportManager.this.getDeviceExt().submitScheduleDiscoveryJob();
            if (jobOrd != null && !jobOrd.equals((Object)BOrd.DEFAULT)) {
                BBacnetScheduleImportManager.this.getLearn().setJob(jobOrd);
            }
            return null;
        }
    }

    class Learn
    extends ScheduleLearn {
        public Learn(BBacnetScheduleImportManager manager) {
            super((BAbstractManager)manager);
        }

        public boolean isExisting(Object dis, BComponent db) {
            BScheduleImportExt ext = BScheduleDeviceExt.getExt((BAbstractSchedule)((BAbstractSchedule)db));
            if (ext == null) {
                return false;
            }
            if (!(ext instanceof BBacnetScheduleImportExt)) {
                return false;
            }
            return ((BBacnetScheduleImportExt)ext).getObjectId().equals((Object)this.disc(dis).getObjectId());
        }

        public boolean isMatchable(Object dis, BComponent db) {
            return db.getType().is(Sys.getRegistry().getType(this.disc(dis).getScheduleType()));
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            BDiscoverySchedule disc = this.disc(dis);
            if (disc.getScheduleType().indexOf("Calendar") >= 0) {
                return MgrTypeInfo.makeArray((TypeInfo)Sys.getRegistry().getType(disc.getScheduleType()));
            }
            if (disc.getDataType().equals("")) {
                return ALL_SCHEDULE_TYPES;
            }
            return new MgrTypeInfo[]{MgrTypeInfo.make((TypeInfo)Sys.getRegistry().getType(disc.getScheduleType()))};
        }

        public void toRow(Object dis, MgrEditRow row) throws Exception {
            BDiscoverySchedule ds = this.disc(dis);
            BAbstractSchedule sch = (BAbstractSchedule)row.getTarget();
            BBacnetScheduleImportExt ext = (BBacnetScheduleImportExt)sch.get("ext");
            ext.setObjectId(ds.getObjectId());
            row.setName(SlotPath.escape((String)ds.getObjectName()));
            row.setCell(BBacnetScheduleImportManager.this.objectIdCol, (BValue)ds.getObjectId());
        }
    }

    class Model
    extends ScheduleImportModel {
        public Model(BBacnetScheduleImportManager manager) {
            super((BScheduleImportManager)manager);
        }

        protected MgrColumn[] makeColumns() {
            Object[] cols = super.makeColumns();
            cols[1] = new MgrColumn.Type(1);
            cols[2] = BBacnetScheduleImportManager.this.objectIdCol;
            Array ret = new Array(cols);
            ret.add((Object)new ScheduleImportModel.Ext(BBacnetScheduleImportExt.priorityForWriting, 0));
            ret.add((Object)new ScheduleImportModel.Ext(BDescriptor.executionTime, 1));
            return (MgrColumn[])ret.trim();
        }
    }
}

