/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platIEEE8021X.ui;

import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.crypto.core.io.ICoreKeyStore;
import com.tridium.crypto.core.io.ICoreTrustStore;
import com.tridium.platIEEE8021X.BIEEE8021XAdapterSettings;
import com.tridium.platIEEE8021X.BIEEE8021XEAPMethod;
import com.tridium.platIEEE8021X.IEEE8021XUtil;
import com.tridium.platIEEE8021X.KeyStoreCertInfo;
import com.tridium.platIEEE8021X.TrustStoreCertInfo;
import com.tridium.platcrypto.ui.BCertEntryViewDialog;
import com.tridium.platform.ui.util.BLimitedFrozenEnumFE;
import com.tridium.platform.ui.util.BTextOutputPane;
import com.tridium.ui.util.LabelUtil;
import com.tridium.workbench.fieldeditors.BPasswordFE;
import com.tridium.workbench.fieldeditors.BStringFE;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.security.IX509CertificateEntry;
import javax.baja.security.BPassword;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.NoSuchSlotException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.util.LexiconModule;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbView;

@NiagaraType
@NiagaraActions(value={@NiagaraAction(name="setEnabledStates"), @NiagaraAction(name="handleEAPMethodChanged", flags=4), @NiagaraAction(name="handlePhase2Changed", flags=4)})
public class BIEEE8021XAdapterSettingsEditor
extends BWbView {
    @Generated
    public static final Action setEnabledStates = BIEEE8021XAdapterSettingsEditor.newAction((int)0, null);
    @Generated
    public static final Action handleEAPMethodChanged = BIEEE8021XAdapterSettingsEditor.newAction((int)4, null);
    @Generated
    public static final Action handlePhase2Changed = BIEEE8021XAdapterSettingsEditor.newAction((int)4, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BIEEE8021XAdapterSettingsEditor.class);
    private boolean saving;
    protected static final LexiconModule LEXICON = LexiconModule.make((Type)TYPE);
    protected static final Logger LOG = Logger.getLogger("platIEEE8021X.editor");
    private static final int DEFAULT_GRID_PANE_COLUMNS = 2;
    private static final int DEFAULT_GRID_PANE_COLUMN_GAP = 10;
    private static final int DEFAULT_GRID_PANE_ROW_GAP = 6;
    private ICoreKeyStore keyStore;
    private ICoreTrustStore trustStore;
    private BGridPane mainPane;
    private boolean isIEEE8021XReadonly;
    private BCheckBox use8021xCheckBox;
    private BLimitedFrozenEnumFE eapTypeFE;
    private BCheckBox useFastReauthenticationCheckBox;
    private BLabel currentStatusLabel;
    private BTextOutputPane allStatusesTextPane;
    private BButton viewAllStatusesButton;
    private BLabel eapUsernameFEPaneLabel;
    private BLabel eapIdentityFEPaneLabel;
    private BGridPane eapIdentityFEPane;
    private BStringFE eapIdentityFE;
    private static final String EAP_USERNAME_LABEL_SLOT_NAME = "eapUsernameLabel";
    private static final String EAP_USERNAME_FE_SLOT_NAME = "eapUsernameFE";
    private boolean eapIdentityInUse;
    private BLabel eapAnonymousIdentityFEPaneLabel;
    private BGridPane eapAnonymousIdentityFEPane;
    private BStringFE eapAnonymousIdentityFE;
    private static final String EAP_ANONYMOUS_IDENTITY_LABEL_SLOT_NAME = "eapAnonymousLabel";
    private static final String EAP_ANONYMOUS_IDENTITY_FE_SLOT_NAME = "eapAnonymousFE";
    private BLabel eapPassphraseFEPaneLabel;
    private BGridPane eapPassphraseFEPane;
    private BPasswordFE eapPassphraseFE;
    private static final String EAP_PASSPHRASE_LABEL_SLOT_NAME = "eapPassphraseLabel";
    private static final String EAP_PASSPHRASE_FE_SLOT_NAME = "eapPassphraseFE";
    private BLabel clientKeyDropDownPaneLabel;
    private BGridPane clientKeyDropDownPane;
    private BListDropDown clientKeyDropDown;
    private BButton viewClientKeyButton;
    private static final String CLIENT_KEY_LABEL_SLOT_NAME = "clientKeyLabel";
    private static final String CLIENT_KEY_FE_SLOT_NAME = "clientKeyFE";
    private BLabel privateKeyPassphraseFEPaneLabel;
    private BGridPane privateKeyPassphraseFEPane;
    private BPasswordFE privateKeyPassphraseFE;
    private static final String PRIVATE_KEY_PASSPHRASE_LABEL_SLOT_NAME = "privateKeyPassphraseLabel";
    private static final String PRIVATE_KEY_PASSPHRASE_FE_SLOT_NAME = "privateKeyPassphraseFE";
    private BLabel caCertDropDownPaneStandardLabel;
    private BLabel caCertDropDownPaneTunnelLabel;
    private BGridPane caCertDropDownPane;
    private BListDropDown caCertDropDown;
    private BButton viewCaCertButton;
    private static final String CA_CERT_LABEL_SLOT_NAME = "caCertLabel";
    private static final String CA_CERT_FE_SLOT_NAME = "caCertFE";
    private BLabel tunnelPhase1DropDownPaneLabel;
    private BGridPane tunnelPhase1DropDownPane;
    private BListDropDown tunnelPhase1DropDown;
    private static final String PHASE1_LABEL_SLOT_NAME = "phase1Label";
    private static final String PHASE1_FE_SLOT_NAME = "phase1FE";
    private BLabel tunnelPhase2DropDownPaneLabel;
    private BGridPane tunnelPhase2DropDownPane;
    private BListDropDown tunnelPhase2DropDown;
    private static final String PHASE2_LABEL_SLOT_NAME = "phase2Label";
    private static final String PHASE2_FE_SLOT_NAME = "phase2FE";
    private BLabel clientKey2DropDownPaneLabel;
    private BGridPane clientKey2DropDownPane;
    private BListDropDown clientKey2DropDown;
    private BButton viewClientKey2Button;
    private static final String CLIENT_KEY2_LABEL_SLOT_NAME = "clientKey2Label";
    private static final String CLIENT_KEY2_FE_SLOT_NAME = "clientKey2FE";
    private BLabel privateKey2PassphraseFEPaneLabel;
    private BGridPane privateKey2PassphraseFEPane;
    private BPasswordFE privateKey2PassphraseFE;
    private static final String PRIVATE_KEY2_PASSPHRASE_LABEL_SLOT_NAME = "privateKey2PassphraseLabel";
    private static final String PRIVATE_KEY2_PASSPHRASE_FE_SLOT_NAME = "privateKey2PassphraseFE";
    private BLabel caCert2DropDownPaneLabel;
    private BGridPane caCert2DropDownPane;
    private BListDropDown caCert2DropDown;
    private BButton viewCaCert2Button;
    private static final String CA_CERT2_LABEL_SLOT_NAME = "caCert2Label";
    private static final String CA_CERT2_FE_SLOT_NAME = "caCert2FE";
    private static final String[] ALL_DYNAMIC_SLOTS = new String[]{"eapUsernameLabel", "eapUsernameFE", "eapAnonymousLabel", "eapAnonymousFE", "eapPassphraseLabel", "eapPassphraseFE", "clientKeyLabel", "clientKeyFE", "privateKeyPassphraseLabel", "privateKeyPassphraseFE", "caCertLabel", "caCertFE", "phase1Label", "phase1FE", "phase2Label", "phase2FE", "clientKey2Label", "clientKey2FE", "privateKey2PassphraseLabel", "privateKey2PassphraseFE", "caCert2Label", "caCert2FE"};
    private static final String[] ALL_INNER_DYNAMIC_SLOTS = new String[]{"eapUsernameLabel", "eapUsernameFE", "eapPassphraseLabel", "eapPassphraseFE", "clientKey2Label", "clientKey2FE", "privateKey2PassphraseLabel", "privateKey2PassphraseFE", "caCert2Label", "caCert2FE"};
    private static final String[] ALL_DYNAMIC_FE_SLOTS = new String[]{"eapUsernameFE", "eapAnonymousFE", "eapPassphraseFE", "clientKeyFE", "privateKeyPassphraseFE", "caCertFE", "phase1FE", "phase2FE", "clientKey2FE", "privateKey2PassphraseFE", "caCert2FE"};
    private Map<String, BWidget> fieldEditorsBySlot;
    private static final Set<String> IGNORED_PROPERTY_NAMES = new HashSet<String>(Arrays.asList("isLicensed", "configurationFile", "pkiCertificatesDirectory", "pkiCertificatesResolvedDirectory", "statusFile"));
    private final TunnelModel peapPhase1Model = new TunnelModel(new String[]{BIEEE8021XAdapterSettingsEditor.phase1StringToModel("peapver=0")});
    private final TunnelModel peapPhase2Model = new TunnelModel(new String[]{BIEEE8021XAdapterSettingsEditor.phase2StringToModel("auth=MSCHAPV2")});
    private final TunnelModel ttlsPhase1Model = new TunnelModel(new String[]{IEEE8021XUtil.NO_OPTIONS});
    private final TunnelModel ttlsPhase2Model = new TunnelModel(new String[]{BIEEE8021XAdapterSettingsEditor.phase2StringToModel("autheap=TLS"), BIEEE8021XAdapterSettingsEditor.phase2StringToModel("auth=MSCHAPV2"), BIEEE8021XAdapterSettingsEditor.phase2StringToModel("autheap=MSCHAPV2")});
    private static final boolean SHOW_PRIVATE_KEY_PASSPHRASE_FE = AccessController.doPrivileged(() -> Boolean.getBoolean("niagara.platIEEE8021X.showPrivateKeyPassphraseEditors"));
    static final BImage SECURITY_ICON_HIGH = BImage.make((String)LEXICON.get("security.high.x16.icon", null, "module://icons/x16/security-high.png"));
    static final BImage SECURITY_ICON_MEDIUM = BImage.make((String)LEXICON.get("security.medium.x16.icon", null, "module://icons/x16/security-medium.png"));
    static final BImage SECURITY_ICON_LOW = BImage.make((String)LEXICON.get("security.low.x16.icon", null, "module://icons/x16/security-low.png"));

    @Generated
    public void setEnabledStates() {
        this.invoke(setEnabledStates, null, null);
    }

    @Generated
    public void handleEAPMethodChanged() {
        this.invoke(handleEAPMethodChanged, null, null);
    }

    @Generated
    public void handlePhase2Changed() {
        this.invoke(handlePhase2Changed, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIEEE8021XAdapterSettingsEditor() {
    }

    public BIEEE8021XAdapterSettingsEditor(ICoreCryptoManager coreCryptoManager) {
        if (coreCryptoManager == null) {
            LOG.warning("IEEE 802.1X Adapter Settings Editor was created without crypto manager interface, certificate enumeration unavailable");
            return;
        }
        try {
            this.keyStore = coreCryptoManager.getKeyStore();
            this.trustStore = coreCryptoManager.getUserTrustStore();
        }
        catch (Exception e) {
            throw new BajaRuntimeException("Failed to load crypto manager stores, can not load editor", (Throwable)e);
        }
    }

    public final void doLoadValue(BObject value, Context cx) throws Exception {
        boolean readonly;
        String allStatuses;
        TrustStoreCertInfo[] trustStoreInfo;
        KeyStoreCertInfo[] keyStoreInfo;
        BIEEE8021XAdapterSettings settings;
        block18: {
            String currentStatus;
            block17: {
                settings = (BIEEE8021XAdapterSettings)value;
                settings.getHostSettings().lease(Integer.MAX_VALUE);
                try {
                    keyStoreInfo = KeyStoreCertInfo.list((ICoreKeyStore)this.keyStore);
                }
                catch (Exception e) {
                    throw new BajaException("Exception occurred listing certificates, can not load editor", (Throwable)e);
                }
                try {
                    trustStoreInfo = TrustStoreCertInfo.list((ICoreTrustStore)this.trustStore);
                }
                catch (Exception e) {
                    throw new BajaException("Exception occurred listing certificates, can not load editor", (Throwable)e);
                }
                this.isIEEE8021XReadonly = settings.getIeee8021XReadonly() || settings.getHostSettings().getIeee8021XReadonly();
                this.mainPane = BIEEE8021XAdapterSettingsEditor.makeDefaultGridPane();
                this.use8021xCheckBox = new BCheckBox(LEXICON.getText("IEEE8021XAdapterSettingsEditor.ieee8021XEnabled.value", cx));
                LabelUtil.addLabelWidgetPair((BPane)this.mainPane, (String)LEXICON.getText("IEEE8021XAdapterSettingsEditor.ieee8021XEnabled.label", cx), (BWidget)this.use8021xCheckBox);
                this.linkTo(null, (BComponent)this.use8021xCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
                this.currentStatusLabel = new BLabel();
                this.allStatusesTextPane = new BTextOutputPane();
                this.viewAllStatusesButton = new BButton();
                this.viewAllStatusesButton.setButtonStyle(BButtonStyle.toolBar);
                BGridPane currentStatusPane = BIEEE8021XAdapterSettingsEditor.makeDefaultGridPane();
                currentStatusPane.add(null, (BValue)this.currentStatusLabel);
                currentStatusPane.add(null, (BValue)this.viewAllStatusesButton);
                LabelUtil.addLabelWidgetPair((BPane)this.mainPane, (String)LEXICON.getText("IEEE8021XAdapterSettingsEditor.ieee8021XStatus.label", cx), (BWidget)BIEEE8021XAdapterSettingsEditor.left((BWidget)currentStatusPane));
                this.eapTypeFE = new BLimitedFrozenEnumFE();
                LabelUtil.addLabelWidgetPair((BPane)this.mainPane, (String)LEXICON.getText("IEEE8021XAdapterSettingsEditor.EAP.label", cx), (BWidget)BIEEE8021XAdapterSettingsEditor.left((BWidget)this.eapTypeFE));
                this.linkTo(null, (BComponent)this.eapTypeFE, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)setModified);
                this.useFastReauthenticationCheckBox = new BCheckBox(LEXICON.getText("IEEE8021XAdapterSettingsEditor.ieee8021XFastReauth.value", cx));
                LabelUtil.addLabelWidgetPair((BPane)this.mainPane, (String)LEXICON.getText("IEEE8021XAdapterSettingsEditor.ieee8021XFastReauth.label", cx), (BWidget)this.useFastReauthenticationCheckBox);
                this.linkTo(null, (BComponent)this.useFastReauthenticationCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setModified);
                this.use8021xCheckBox.setSelected(settings.getIeee8021XEnabled());
                currentStatus = "unknown";
                try {
                    currentStatus = LEXICON.getText(((BString)settings.get("currentStatus")).getString(), cx);
                }
                catch (NullPointerException | NoSuchSlotException exception) {
                    if (!LOG.isLoggable(Level.FINEST)) break block17;
                    LOG.finest("IEEE 802.1X current status slot is absent, returning 'unknown' (" + exception + ")");
                }
            }
            this.currentStatusLabel.setText(currentStatus);
            if (currentStatus.equals(LEXICON.getText("unlicensed", cx, new Object[]{"Unlicensed"}))) {
                this.currentStatusLabel.setForeground(BBrush.makeSolid((BColor)BColor.red));
            }
            allStatuses = "unknown";
            try {
                allStatuses = LEXICON.getText(((BString)settings.get("allStatuses")).getString(), cx);
            }
            catch (NullPointerException | NoSuchSlotException exception) {
                if (!LOG.isLoggable(Level.FINEST)) break block18;
                LOG.finest("IEEE 802.1X all statuses slot is absent, returning 'unknown' (" + exception + ")");
            }
        }
        this.allStatusesTextPane.setText(allStatuses);
        this.viewAllStatusesButton.setCommand((Command)new ViewAllStatusesCommand(this.allStatusesTextPane), false, true);
        this.eapTypeFE.loadValue((BObject)settings.getEapMethod(), (Context)new BasicContext(cx, BIEEE8021XAdapterSettings.eapMethod.getFacets()));
        this.useFastReauthenticationCheckBox.setSelected(settings.getUseFastReauthentication());
        this.eapIdentityFE = new BStringFE();
        this.eapIdentityFEPane = BIEEE8021XAdapterSettingsEditor.left((BWidget)this.eapIdentityFE);
        this.eapIdentityFEPaneLabel = LabelUtil.makeLabel((String)LEXICON.getText("IEEE8021XAdapterSettingsEditor.EAPIdentity.label", cx), (boolean)true);
        this.eapUsernameFEPaneLabel = LabelUtil.makeLabel((String)LEXICON.getText("IEEE8021XAdapterSettingsEditor.EAPUsername.label", cx), (boolean)true);
        this.linkTo(null, (BComponent)this.eapIdentityFE, (Slot)BStringFE.pluginModified, (Slot)setModified);
        this.eapPassphraseFE = new BPasswordFE();
        this.eapPassphraseFEPane = BIEEE8021XAdapterSettingsEditor.left((BWidget)this.eapPassphraseFE);
        this.eapPassphraseFEPaneLabel = LabelUtil.makeLabel((String)LEXICON.getText("IEEE8021XAdapterSettingsEditor.EAPPassphrase.label", cx), (boolean)true);
        this.linkTo(null, (BComponent)this.eapPassphraseFE, (Slot)BPasswordFE.pluginModified, (Slot)setModified);
        this.eapAnonymousIdentityFE = new BStringFE();
        this.eapAnonymousIdentityFEPane = BIEEE8021XAdapterSettingsEditor.left((BWidget)this.eapAnonymousIdentityFE);
        this.eapAnonymousIdentityFEPaneLabel = LabelUtil.makeLabel((String)LEXICON.getText("IEEE8021XAdapterSettingsEditor.EAPAnonymousIdentity.label", cx), (boolean)true);
        this.linkTo(null, (BComponent)this.eapAnonymousIdentityFE, (Slot)BStringFE.pluginModified, (Slot)setModified);
        this.clientKeyDropDown = new BListDropDown();
        this.clientKeyDropDown.getList().setMultipleSelection(false);
        this.clientKeyDropDown.getList().setModel((ListModel)new KeyStoreModel(keyStoreInfo));
        this.viewClientKeyButton = new BButton();
        this.viewClientKeyButton.setButtonStyle(BButtonStyle.toolBar);
        this.viewClientKeyButton.setCommand((Command)new ViewCertificateCommand(this.clientKeyDropDown), false, true);
        this.clientKeyDropDownPane = BIEEE8021XAdapterSettingsEditor.makeDefaultGridPane();
        this.clientKeyDropDownPane.add(null, (BValue)this.clientKeyDropDown);
        this.clientKeyDropDownPane.add(null, (BValue)this.viewClientKeyButton);
        this.clientKeyDropDownPaneLabel = LabelUtil.makeLabel((String)LEXICON.getText("IEEE8021XAdapterSettingsEditor.clientKeyDropDown.label", cx), (boolean)true);
        this.linkTo(null, (BComponent)this.clientKeyDropDown, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.privateKeyPassphraseFE = new BPasswordFE();
        this.privateKeyPassphraseFEPane = BIEEE8021XAdapterSettingsEditor.left((BWidget)this.privateKeyPassphraseFE);
        this.privateKeyPassphraseFEPaneLabel = LabelUtil.makeLabel((String)LEXICON.getText("IEEE8021XAdapterSettingsEditor.privateKeyPassphrase.label", cx), (boolean)true);
        this.linkTo(null, (BComponent)this.privateKeyPassphraseFE, (Slot)BPasswordFE.pluginModified, (Slot)setModified);
        this.caCertDropDown = new BListDropDown();
        this.caCertDropDown.getList().setMultipleSelection(false);
        this.caCertDropDown.getList().setModel((ListModel)new TrustStoreModel(trustStoreInfo));
        this.viewCaCertButton = new BButton();
        this.viewCaCertButton.setButtonStyle(BButtonStyle.toolBar);
        this.viewCaCertButton.setCommand((Command)new ViewCertificateCommand(this.caCertDropDown), false, true);
        this.caCertDropDownPane = BIEEE8021XAdapterSettingsEditor.makeDefaultGridPane();
        this.caCertDropDownPane.add(null, (BValue)this.caCertDropDown);
        this.caCertDropDownPane.add(null, (BValue)this.viewCaCertButton);
        this.caCertDropDownPaneStandardLabel = LabelUtil.makeLabel((String)LEXICON.getText("IEEE8021XAdapterSettingsEditor.CACertDropDown.label", cx), (boolean)true);
        this.caCertDropDownPaneTunnelLabel = LabelUtil.makeLabel((String)LEXICON.getText("IEEE8021XAdapterSettingsEditor.CACertDropDownTunnel.label", cx), (boolean)true);
        this.linkTo(null, (BComponent)this.caCertDropDown, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.tunnelPhase1DropDown = new BListDropDown();
        this.tunnelPhase1DropDown.getList().setMultipleSelection(false);
        this.tunnelPhase1DropDownPane = BIEEE8021XAdapterSettingsEditor.left((BWidget)this.tunnelPhase1DropDown);
        this.tunnelPhase1DropDownPaneLabel = LabelUtil.makeLabel((String)LEXICON.getText("IEEE8021XAdapterSettingsEditor.tunnel.phase1.label", cx), (boolean)true);
        this.linkTo(null, (BComponent)this.tunnelPhase1DropDown, (Slot)BListDropDown.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.tunnelPhase1DropDown, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.tunnelPhase2DropDown = new BListDropDown();
        this.tunnelPhase2DropDown.getList().setMultipleSelection(false);
        this.tunnelPhase2DropDownPane = BIEEE8021XAdapterSettingsEditor.left((BWidget)this.tunnelPhase2DropDown);
        this.tunnelPhase2DropDownPaneLabel = LabelUtil.makeLabel((String)LEXICON.getText("IEEE8021XAdapterSettingsEditor.tunnel.phase2.label", cx), (boolean)true);
        this.linkTo(null, (BComponent)this.tunnelPhase2DropDown, (Slot)BListDropDown.actionPerformed, (Slot)setModified);
        this.linkTo(null, (BComponent)this.tunnelPhase2DropDown, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.clientKey2DropDown = new BListDropDown();
        this.clientKey2DropDown.getList().setMultipleSelection(false);
        this.clientKey2DropDown.getList().setModel((ListModel)new KeyStoreModel(keyStoreInfo));
        this.viewClientKey2Button = new BButton();
        this.viewClientKey2Button.setButtonStyle(BButtonStyle.toolBar);
        this.viewClientKey2Button.setCommand((Command)new ViewCertificateCommand(this.clientKey2DropDown), false, true);
        this.clientKey2DropDownPane = BIEEE8021XAdapterSettingsEditor.makeDefaultGridPane();
        this.clientKey2DropDownPane.add(null, (BValue)this.clientKey2DropDown);
        this.clientKey2DropDownPane.add(null, (BValue)this.viewClientKey2Button);
        this.clientKey2DropDownPaneLabel = LabelUtil.makeLabel((String)LEXICON.getText("IEEE8021XAdapterSettingsEditor.clientKey2DropDown.label", cx), (boolean)true);
        this.linkTo(null, (BComponent)this.clientKey2DropDown, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.privateKey2PassphraseFE = new BPasswordFE();
        this.privateKey2PassphraseFEPane = BIEEE8021XAdapterSettingsEditor.left((BWidget)this.privateKey2PassphraseFE);
        this.privateKey2PassphraseFEPaneLabel = LabelUtil.makeLabel((String)LEXICON.getText("IEEE8021XAdapterSettingsEditor.privateKey2Passphrase.label", cx), (boolean)true);
        this.linkTo(null, (BComponent)this.privateKey2PassphraseFE, (Slot)BPasswordFE.pluginModified, (Slot)setModified);
        this.caCert2DropDown = new BListDropDown();
        this.caCert2DropDown.getList().setMultipleSelection(false);
        this.caCert2DropDown.getList().setModel((ListModel)new TrustStoreModel(trustStoreInfo));
        this.viewCaCert2Button = new BButton();
        this.viewCaCert2Button.setButtonStyle(BButtonStyle.toolBar);
        this.viewCaCert2Button.setCommand((Command)new ViewCertificateCommand(this.caCert2DropDown), false, true);
        this.caCert2DropDownPane = BIEEE8021XAdapterSettingsEditor.makeDefaultGridPane();
        this.caCert2DropDownPane.add(null, (BValue)this.caCert2DropDown);
        this.caCert2DropDownPane.add(null, (BValue)this.viewCaCert2Button);
        this.caCert2DropDownPaneLabel = LabelUtil.makeLabel((String)LEXICON.getText("IEEE8021XAdapterSettingsEditor.CACertDropDown.label", cx), (boolean)true);
        this.linkTo(null, (BComponent)this.caCert2DropDown, (Slot)BListDropDown.listActionPerformed, (Slot)setModified);
        this.eapIdentityFE.loadValue((BObject)BString.make((String)settings.getIdentity()), (Context)new BasicContext(cx, BIEEE8021XAdapterSettings.identity.getFacets()));
        this.eapPassphraseFE.loadValue((BObject)BIEEE8021XAdapterSettingsEditor.passphraseToPassphrase(settings.getPassphrase()), (Context)new BasicContext(cx, BIEEE8021XAdapterSettings.passphrase.getFacets()));
        this.eapAnonymousIdentityFE.loadValue((BObject)BString.make((String)settings.getAnonymousIdentity()), (Context)new BasicContext(cx, BIEEE8021XAdapterSettings.anonymousIdentity.getFacets()));
        ((KeyStoreModel)this.clientKeyDropDown.getList().getModel()).select(settings.getClientCertificate());
        this.privateKeyPassphraseFE.loadValue((BObject)BIEEE8021XAdapterSettingsEditor.passphraseToPassphrase(settings.getPrivateKeyPassphrase()), (Context)new BasicContext(cx, BIEEE8021XAdapterSettings.privateKeyPassphrase.getFacets()));
        ((TrustStoreModel)this.caCertDropDown.getList().getModel()).select(settings.getCaCertificate());
        this.tunnelPhase1DropDown.getList().getSelection().deselectAll();
        this.tunnelPhase1DropDown.getList().removeAllItems();
        if (settings.getEapMethod().equals((Object)BIEEE8021XEAPMethod.peap) && this.tunnelPhase1DropDown.getList().getModel() != this.peapPhase1Model) {
            this.tunnelPhase1DropDown.getList().setModel((ListModel)this.peapPhase1Model);
            this.tunnelPhase1DropDown.setSelectedIndex(0);
        } else if (settings.getEapMethod().equals((Object)BIEEE8021XEAPMethod.ttls) && this.tunnelPhase1DropDown.getList().getModel() != this.ttlsPhase1Model) {
            this.tunnelPhase1DropDown.getList().setModel((ListModel)this.ttlsPhase1Model);
            this.tunnelPhase1DropDown.setSelectedIndex(0);
        }
        this.tunnelPhase1DropDown.setSelectedItem((Object)BIEEE8021XAdapterSettingsEditor.phase1StringToModel(settings.getTunnelPhase1()));
        this.tunnelPhase2DropDown.getList().getSelection().deselectAll();
        this.tunnelPhase2DropDown.getList().removeAllItems();
        if (settings.getEapMethod().equals((Object)BIEEE8021XEAPMethod.peap) && this.tunnelPhase2DropDown.getList().getModel() != this.peapPhase2Model) {
            this.tunnelPhase2DropDown.getList().setModel((ListModel)this.peapPhase2Model);
            this.tunnelPhase2DropDown.setSelectedIndex(0);
        } else if (settings.getEapMethod().equals((Object)BIEEE8021XEAPMethod.ttls) && this.tunnelPhase2DropDown.getList().getModel() != this.ttlsPhase2Model) {
            this.tunnelPhase2DropDown.getList().setModel((ListModel)this.ttlsPhase2Model);
            this.tunnelPhase2DropDown.setSelectedIndex(0);
        }
        this.tunnelPhase2DropDown.setSelectedItem((Object)BIEEE8021XAdapterSettingsEditor.phase2StringToModel(settings.getTunnelPhase2()));
        ((KeyStoreModel)this.clientKey2DropDown.getList().getModel()).select(settings.getClientCertificate2());
        this.privateKey2PassphraseFE.loadValue((BObject)BIEEE8021XAdapterSettingsEditor.passphraseToPassphrase(settings.getPrivateKey2Passphrase()), (Context)new BasicContext(cx, BIEEE8021XAdapterSettings.privateKey2Passphrase.getFacets()));
        ((TrustStoreModel)this.caCert2DropDown.getList().getModel()).select(settings.getCaCertificate2());
        boolean bl = readonly = this.isIEEE8021XReadonly || this.isReadonly();
        if (this.isReadonly() == readonly) {
            this.doSetReadonly(readonly);
        } else {
            this.setReadonly(readonly);
        }
        this.doHandleEAPMethodChanged();
        this.linkTo(null, (BComponent)this.use8021xCheckBox, (Slot)BCheckBox.actionPerformed, (Slot)setEnabledStates);
        this.linkTo(null, (BComponent)this.eapTypeFE, (Slot)BLimitedFrozenEnumFE.pluginModified, (Slot)handleEAPMethodChanged);
        this.linkTo(null, (BComponent)this.tunnelPhase2DropDown, (Slot)BListDropDown.listActionPerformed, (Slot)handlePhase2Changed);
        this.fieldEditorsBySlot = Stream.of({EAP_USERNAME_FE_SLOT_NAME, this.eapIdentityFE}, {EAP_ANONYMOUS_IDENTITY_FE_SLOT_NAME, this.eapAnonymousIdentityFE}, {EAP_PASSPHRASE_FE_SLOT_NAME, this.eapPassphraseFE}, {CLIENT_KEY_FE_SLOT_NAME, this.clientKeyDropDown}, {PRIVATE_KEY_PASSPHRASE_FE_SLOT_NAME, this.privateKeyPassphraseFE}, {CA_CERT_FE_SLOT_NAME, this.caCertDropDown}, {PHASE1_FE_SLOT_NAME, this.tunnelPhase1DropDown}, {PHASE2_FE_SLOT_NAME, this.tunnelPhase2DropDown}, {CLIENT_KEY2_FE_SLOT_NAME, this.clientKey2DropDown}, {PRIVATE_KEY2_PASSPHRASE_FE_SLOT_NAME, this.privateKey2PassphraseFE}, {CA_CERT2_FE_SLOT_NAME, this.caCert2DropDown}).collect(Collectors.toMap(data -> (String)data[0], data -> (BWidget)data[1]));
        this.setContent((BWidget)this.mainPane);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BObject doSaveValue(BObject value, Context cx) throws Exception {
        BIEEE8021XAdapterSettings settings = (BIEEE8021XAdapterSettings)value;
        if (this.isReadonly()) {
            return value;
        }
        if (this.isIEEE8021XReadonly) {
            return value;
        }
        if (!this.isModified()) {
            return value;
        }
        if (this.use8021xCheckBox.isSelected()) {
            this.validateContent();
        }
        for (String dynamicSlotName : ALL_DYNAMIC_FE_SLOTS) {
            this.unsetIfAbsent(dynamicSlotName);
        }
        this.saving = true;
        try {
            String currentSelection;
            settings.setIeee8021XEnabled(this.use8021xCheckBox.isSelected());
            settings.setEapMethod((BIEEE8021XEAPMethod)this.eapTypeFE.saveValue(cx));
            settings.setUseFastReauthentication(this.useFastReauthenticationCheckBox.isSelected());
            settings.setIdentity(((BString)this.eapIdentityFE.saveValue()).getString());
            settings.setAnonymousIdentity(((BString)this.eapAnonymousIdentityFE.saveValue()).getString());
            settings.setPassphrase(BIEEE8021XAdapterSettingsEditor.passphraseToPassphrase((BPassword)this.eapPassphraseFE.saveValue(cx)));
            settings.setCaCertificate(((TrustStoreModel)this.caCertDropDown.getList().getModel()).getSelectedAlias());
            settings.setClientCertificate(((KeyStoreModel)this.clientKeyDropDown.getList().getModel()).getSelectedAlias());
            settings.setPrivateKeyPassphrase(BIEEE8021XAdapterSettingsEditor.passphraseToPassphrase((BPassword)this.privateKeyPassphraseFE.saveValue(cx)));
            if (settings.getEapMethod() == BIEEE8021XEAPMethod.peap) {
                currentSelection = BIEEE8021XAdapterSettingsEditor.phase1ModelToString((String)this.tunnelPhase1DropDown.getSelectedItem());
                settings.setTunnelPhase1(currentSelection != null ? currentSelection : "");
                currentSelection = BIEEE8021XAdapterSettingsEditor.phase2ModelToString((String)this.tunnelPhase2DropDown.getSelectedItem());
                settings.setTunnelPhase2(currentSelection != null ? currentSelection : "");
            } else if (settings.getEapMethod() == BIEEE8021XEAPMethod.ttls) {
                settings.setTunnelPhase1("");
                currentSelection = BIEEE8021XAdapterSettingsEditor.phase2ModelToString((String)this.tunnelPhase2DropDown.getSelectedItem());
                settings.setTunnelPhase2(currentSelection != null ? currentSelection : "");
            } else {
                settings.setTunnelPhase1("");
                settings.setTunnelPhase2("");
            }
            settings.setCaCertificate2(((TrustStoreModel)this.caCert2DropDown.getList().getModel()).getSelectedAlias());
            settings.setClientCertificate2(((KeyStoreModel)this.clientKey2DropDown.getList().getModel()).getSelectedAlias());
            settings.setPrivateKey2Passphrase(BIEEE8021XAdapterSettingsEditor.passphraseToPassphrase((BPassword)this.privateKey2PassphraseFE.saveValue(cx)));
        }
        finally {
            this.saving = false;
        }
        return settings;
    }

    public void validateContent() throws Exception {
        String text;
        if (this.editorPresent(EAP_USERNAME_FE_SLOT_NAME) && ((text = ((BString)this.eapIdentityFE.saveValue()).getString()) == null || text.trim().isEmpty())) {
            BIEEE8021XAdapterSettingsEditor.saveError("IEEE8021XAdapterSettingsEditor.cannotSave.invalidIdentity");
        }
        if (this.editorPresent(CLIENT_KEY_FE_SLOT_NAME) && ((text = ((KeyStoreModel)this.clientKeyDropDown.getList().getModel()).getSelectedAlias()) == null || text.trim().isEmpty())) {
            BIEEE8021XAdapterSettingsEditor.saveError("IEEE8021XAdapterSettingsEditor.cannotSave.invalidClientCertificate");
        }
        if (this.editorPresent(CLIENT_KEY2_FE_SLOT_NAME) && ((text = ((KeyStoreModel)this.clientKey2DropDown.getList().getModel()).getSelectedAlias()) == null || text.trim().isEmpty())) {
            BIEEE8021XAdapterSettingsEditor.saveError("IEEE8021XAdapterSettingsEditor.cannotSave.invalidClientCertificate");
        }
    }

    public final void processComponentEvent(BComponentEvent evt) {
        boolean handled = false;
        if (evt.getSourceComponent() instanceof BIEEE8021XAdapterSettings) {
            BIEEE8021XAdapterSettings settings = (BIEEE8021XAdapterSettings)evt.getSourceComponent();
            Property property = evt.getSlot().asProperty();
            BValue propertyValue = settings.get(property);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("IEEE 8021X Adapter Settings Editor processComponentEvent, property '" + property + "' " + BComponentEvent.getDisplayStrings()[evt.getId()] + " value = '" + propertyValue + "'");
            }
            if (IGNORED_PROPERTY_NAMES.contains(property.getName())) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Ignoring component event for property '" + property + "' " + BComponentEvent.getDisplayStrings()[evt.getId()] + " value = '" + propertyValue + "', value is not tied to editor");
                    handled = true;
                }
            } else if (this.saving) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Ignoring component event for property '" + property + "' " + BComponentEvent.getDisplayStrings()[evt.getId()] + " value = '" + propertyValue + "', editor is saving");
                    handled = true;
                }
            } else if (property == BIEEE8021XAdapterSettings.ieee8021XEnabled) {
                if (this.use8021xCheckBox != null) {
                    this.use8021xCheckBox.setSelected(((BBoolean)propertyValue).getBoolean());
                    handled = true;
                    this.doSetEnabledStates();
                }
            } else if ("currentStatus".equals(property.getName())) {
                if (this.currentStatusLabel != null) {
                    this.currentStatusLabel.setText(LEXICON.getText(((BString)propertyValue).getString(), null));
                    handled = true;
                }
            } else if ("allStatuses".equals(property.getName())) {
                if (this.allStatusesTextPane != null) {
                    this.allStatusesTextPane.setText(((BString)propertyValue).getString());
                    handled = true;
                }
            } else if (property == BIEEE8021XAdapterSettings.eapMethod) {
                if (this.eapTypeFE != null) {
                    this.eapTypeFE.loadValue((BObject)((BIEEE8021XEAPMethod)propertyValue));
                    handled = true;
                    this.doHandleEAPMethodChanged();
                }
            } else if (property == BIEEE8021XAdapterSettings.useFastReauthentication) {
                if (this.useFastReauthenticationCheckBox != null) {
                    this.useFastReauthenticationCheckBox.setSelected(((BBoolean)propertyValue).getBoolean());
                    handled = true;
                }
            } else if (property == BIEEE8021XAdapterSettings.identity) {
                if (this.eapIdentityFE != null) {
                    this.eapIdentityFE.loadValue((BObject)BString.make((String)propertyValue.toString().trim()), (Context)BIEEE8021XAdapterSettings.identity.getFacets());
                    handled = true;
                }
            } else if (property == BIEEE8021XAdapterSettings.passphrase) {
                if (this.eapPassphraseFE != null) {
                    this.eapPassphraseFE.loadValue((BObject)BIEEE8021XAdapterSettingsEditor.passphraseToPassphrase((BPassword)propertyValue), (Context)BIEEE8021XAdapterSettings.passphrase.getFacets());
                    handled = true;
                }
            } else if (property == BIEEE8021XAdapterSettings.anonymousIdentity) {
                if (this.eapAnonymousIdentityFE != null) {
                    this.eapAnonymousIdentityFE.loadValue((BObject)BString.make((String)propertyValue.toString().trim()), (Context)BIEEE8021XAdapterSettings.anonymousIdentity.getFacets());
                    handled = true;
                }
            } else if (property == BIEEE8021XAdapterSettings.caCertificate) {
                if (this.caCertDropDown != null) {
                    ((TrustStoreModel)this.caCertDropDown.getList().getModel()).select(((BString)propertyValue).getString());
                    this.caCertDropDown.repaint();
                    handled = true;
                }
            } else if (property == BIEEE8021XAdapterSettings.clientCertificate) {
                if (this.clientKeyDropDown != null) {
                    ((KeyStoreModel)this.clientKeyDropDown.getList().getModel()).select(((BString)propertyValue).getString());
                    this.clientKeyDropDownPane.repaint();
                    handled = true;
                }
            } else if (property == BIEEE8021XAdapterSettings.privateKeyPassphrase) {
                if (this.privateKeyPassphraseFE != null) {
                    this.privateKeyPassphraseFE.loadValue((BObject)BIEEE8021XAdapterSettingsEditor.passphraseToPassphrase((BPassword)propertyValue), (Context)BIEEE8021XAdapterSettings.privateKeyPassphrase.getFacets());
                    handled = true;
                }
            } else if (property == BIEEE8021XAdapterSettings.tunnelPhase1) {
                if (this.tunnelPhase1DropDown != null) {
                    this.tunnelPhase1DropDown.setSelectedItem((Object)BIEEE8021XAdapterSettingsEditor.phase1StringToModel(propertyValue.toString().trim()));
                    handled = true;
                }
            } else if (property == BIEEE8021XAdapterSettings.tunnelPhase2) {
                if (this.tunnelPhase2DropDown != null) {
                    this.tunnelPhase2DropDown.setSelectedItem((Object)BIEEE8021XAdapterSettingsEditor.phase2StringToModel(propertyValue.toString().trim()));
                    handled = true;
                    this.doHandlePhase2Changed();
                }
            } else if (property == BIEEE8021XAdapterSettings.caCertificate2) {
                if (this.caCert2DropDown != null) {
                    ((TrustStoreModel)this.caCert2DropDown.getList().getModel()).select(((BString)propertyValue).getString());
                    this.caCert2DropDownPane.repaint();
                    handled = true;
                }
            } else if (property == BIEEE8021XAdapterSettings.clientCertificate2) {
                if (this.clientKey2DropDown != null) {
                    ((KeyStoreModel)this.clientKey2DropDown.getList().getModel()).select(((BString)propertyValue).getString());
                    this.clientKey2DropDownPane.repaint();
                    handled = true;
                }
            } else if (property == BIEEE8021XAdapterSettings.privateKey2Passphrase && this.privateKey2PassphraseFE != null) {
                this.privateKey2PassphraseFE.loadValue((BObject)BIEEE8021XAdapterSettingsEditor.passphraseToPassphrase((BPassword)propertyValue), (Context)BIEEE8021XAdapterSettings.privateKey2Passphrase.getFacets());
                handled = true;
            }
        }
        if (!handled && LOG.isLoggable(Level.WARNING)) {
            LOG.warning("IEEE 8021X Adapter Settings Editor processComponentEvent did not handle event '" + evt + "'");
        }
    }

    public void doSetReadonly(boolean readonlyCondition) {
        boolean enabledCondition;
        boolean bl = enabledCondition = !readonlyCondition && !this.isIEEE8021XReadonly;
        if (this.use8021xCheckBox != null) {
            this.use8021xCheckBox.setEnabled(enabledCondition);
        }
        this.doSetEnabledStates();
    }

    public final void doSetEnabledStates() {
        boolean actionsEnabled;
        boolean enabledCondition = this.use8021xCheckBox != null && this.use8021xCheckBox.isSelected() && !this.isReadonly() && !this.isIEEE8021XReadonly;
        boolean readonlyCondition = !enabledCondition;
        boolean bl = actionsEnabled = this.use8021xCheckBox != null && this.use8021xCheckBox.isSelected() && this.keyStore != null && this.trustStore != null;
        if (this.eapTypeFE != null) {
            this.eapTypeFE.setEnabled(enabledCondition);
            this.eapTypeFE.setReadonly(readonlyCondition);
        }
        if (this.useFastReauthenticationCheckBox != null) {
            this.useFastReauthenticationCheckBox.setEnabled(enabledCondition);
        }
        if (this.currentStatusLabel != null) {
            this.currentStatusLabel.setEnabled(enabledCondition);
        }
        if (this.viewAllStatusesButton != null) {
            this.viewAllStatusesButton.setEnabled(actionsEnabled);
        }
        if (this.allStatusesTextPane != null) {
            this.allStatusesTextPane.setEnabled(enabledCondition);
        }
        if (this.eapIdentityFE != null) {
            this.eapIdentityFE.setEnabled(enabledCondition);
            this.eapIdentityFE.setReadonly(readonlyCondition);
        }
        if (this.eapAnonymousIdentityFE != null) {
            this.eapAnonymousIdentityFE.setEnabled(enabledCondition);
            this.eapAnonymousIdentityFE.setReadonly(readonlyCondition);
        }
        if (this.eapPassphraseFE != null) {
            this.eapPassphraseFE.setEnabled(enabledCondition);
            this.eapPassphraseFE.setReadonly(readonlyCondition);
        }
        if (this.caCertDropDown != null) {
            this.caCertDropDown.setEnabled(enabledCondition);
        }
        if (this.viewCaCertButton != null) {
            this.viewCaCertButton.setEnabled(actionsEnabled);
        }
        if (this.clientKeyDropDown != null) {
            this.clientKeyDropDown.setEnabled(enabledCondition);
        }
        if (this.viewClientKeyButton != null) {
            this.viewClientKeyButton.setEnabled(actionsEnabled);
        }
        if (this.privateKeyPassphraseFE != null) {
            this.privateKeyPassphraseFE.setEnabled(enabledCondition);
            this.privateKeyPassphraseFE.setReadonly(readonlyCondition);
        }
        if (this.tunnelPhase1DropDown != null) {
            this.tunnelPhase1DropDown.setEnabled(enabledCondition);
        }
        if (this.tunnelPhase2DropDown != null) {
            this.tunnelPhase2DropDown.setEnabled(enabledCondition);
        }
        if (this.caCert2DropDown != null) {
            this.caCert2DropDown.setEnabled(enabledCondition);
        }
        if (this.viewCaCert2Button != null) {
            this.viewCaCert2Button.setEnabled(actionsEnabled);
        }
        if (this.clientKey2DropDown != null) {
            this.clientKey2DropDown.setEnabled(enabledCondition);
        }
        if (this.viewClientKey2Button != null) {
            this.viewClientKey2Button.setEnabled(actionsEnabled);
        }
        if (this.privateKey2PassphraseFE != null) {
            this.privateKey2PassphraseFE.setEnabled(enabledCondition);
            this.privateKey2PassphraseFE.setReadonly(readonlyCondition);
        }
    }

    public void doHandleEAPMethodChanged() {
        BIEEE8021XEAPMethod currentEapMethod;
        this.lockModifiedState();
        try {
            currentEapMethod = (BIEEE8021XEAPMethod)this.eapTypeFE.saveValue();
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Failed to save current EAP type", e);
            return;
        }
        for (String property : ALL_DYNAMIC_SLOTS) {
            if (this.mainPane.getProperty(property) == null) continue;
            this.mainPane.remove(property);
        }
        this.eapIdentityInUse = false;
        if (currentEapMethod == BIEEE8021XEAPMethod.tls) {
            this.mainPane.add(EAP_USERNAME_LABEL_SLOT_NAME, (BValue)this.eapIdentityFEPaneLabel);
            this.mainPane.add(EAP_USERNAME_FE_SLOT_NAME, (BValue)this.eapIdentityFEPane);
            this.eapIdentityInUse = true;
            this.mainPane.add(CLIENT_KEY_LABEL_SLOT_NAME, (BValue)this.clientKeyDropDownPaneLabel);
            this.mainPane.add(CLIENT_KEY_FE_SLOT_NAME, (BValue)this.clientKeyDropDownPane);
            if (SHOW_PRIVATE_KEY_PASSPHRASE_FE) {
                this.mainPane.add(PRIVATE_KEY_PASSPHRASE_LABEL_SLOT_NAME, (BValue)this.privateKeyPassphraseFEPaneLabel);
                this.mainPane.add(PRIVATE_KEY_PASSPHRASE_FE_SLOT_NAME, (BValue)this.privateKeyPassphraseFEPane);
            }
            this.mainPane.add(CA_CERT_LABEL_SLOT_NAME, (BValue)this.caCertDropDownPaneStandardLabel);
            this.mainPane.add(CA_CERT_FE_SLOT_NAME, (BValue)this.caCertDropDownPane);
        } else if (currentEapMethod == BIEEE8021XEAPMethod.ttls) {
            this.mainPane.add(EAP_ANONYMOUS_IDENTITY_LABEL_SLOT_NAME, (BValue)this.eapAnonymousIdentityFEPaneLabel);
            this.mainPane.add(EAP_ANONYMOUS_IDENTITY_FE_SLOT_NAME, (BValue)this.eapAnonymousIdentityFEPane);
            this.mainPane.add(CA_CERT_LABEL_SLOT_NAME, (BValue)this.caCertDropDownPaneTunnelLabel);
            this.mainPane.add(CA_CERT_FE_SLOT_NAME, (BValue)this.caCertDropDownPane);
            if (this.tunnelPhase2DropDown.getList().getModel() != this.ttlsPhase2Model) {
                this.tunnelPhase2DropDown.getList().setModel((ListModel)this.ttlsPhase2Model);
                this.tunnelPhase2DropDown.setSelectedIndex(0);
            }
            this.mainPane.add(PHASE2_LABEL_SLOT_NAME, (BValue)this.tunnelPhase2DropDownPaneLabel);
            this.mainPane.add(PHASE2_FE_SLOT_NAME, (BValue)this.tunnelPhase2DropDownPane);
            this.doHandlePhase2Changed();
        } else if (currentEapMethod == BIEEE8021XEAPMethod.peap) {
            this.mainPane.add(EAP_ANONYMOUS_IDENTITY_LABEL_SLOT_NAME, (BValue)this.eapAnonymousIdentityFEPaneLabel);
            this.mainPane.add(EAP_ANONYMOUS_IDENTITY_FE_SLOT_NAME, (BValue)this.eapAnonymousIdentityFEPane);
            this.mainPane.add(CA_CERT_LABEL_SLOT_NAME, (BValue)this.caCertDropDownPaneTunnelLabel);
            this.mainPane.add(CA_CERT_FE_SLOT_NAME, (BValue)this.caCertDropDownPane);
            if (this.tunnelPhase1DropDown.getList().getModel() != this.peapPhase1Model) {
                this.tunnelPhase1DropDown.getList().setModel((ListModel)this.peapPhase1Model);
                this.tunnelPhase1DropDown.setSelectedIndex(0);
            }
            if (this.tunnelPhase2DropDown.getList().getModel() != this.peapPhase2Model) {
                this.tunnelPhase2DropDown.getList().setModel((ListModel)this.peapPhase2Model);
                this.tunnelPhase2DropDown.setSelectedIndex(0);
            }
            this.mainPane.add(PHASE2_LABEL_SLOT_NAME, (BValue)this.tunnelPhase2DropDownPaneLabel);
            this.mainPane.add(PHASE2_FE_SLOT_NAME, (BValue)this.tunnelPhase2DropDownPane);
            this.doHandlePhase2Changed();
        }
        this.unlockModifiedState();
    }

    public void doHandlePhase2Changed() {
        this.lockModifiedState();
        String currentInnerAuthentication = BIEEE8021XAdapterSettingsEditor.phase2ModelToString((String)this.tunnelPhase2DropDown.getList().getSelectedItem());
        for (String property : ALL_INNER_DYNAMIC_SLOTS) {
            if (this.mainPane.getProperty(property) == null || (EAP_USERNAME_LABEL_SLOT_NAME.equals(property) || EAP_USERNAME_FE_SLOT_NAME.equals(property)) && this.eapIdentityInUse) continue;
            this.mainPane.remove(property);
        }
        if ("autheap=TLS".equals(currentInnerAuthentication)) {
            this.mainPane.add(EAP_USERNAME_LABEL_SLOT_NAME, (BValue)this.eapIdentityFEPaneLabel);
            this.mainPane.add(EAP_USERNAME_FE_SLOT_NAME, (BValue)this.eapIdentityFEPane);
            this.mainPane.add(CLIENT_KEY2_LABEL_SLOT_NAME, (BValue)this.clientKey2DropDownPaneLabel);
            this.mainPane.add(CLIENT_KEY2_FE_SLOT_NAME, (BValue)this.clientKey2DropDownPane);
            if (SHOW_PRIVATE_KEY_PASSPHRASE_FE) {
                this.mainPane.add(PRIVATE_KEY2_PASSPHRASE_LABEL_SLOT_NAME, (BValue)this.privateKey2PassphraseFEPaneLabel);
                this.mainPane.add(PRIVATE_KEY2_PASSPHRASE_FE_SLOT_NAME, (BValue)this.privateKey2PassphraseFEPane);
            }
            this.mainPane.add(CA_CERT2_LABEL_SLOT_NAME, (BValue)this.caCert2DropDownPaneLabel);
            this.mainPane.add(CA_CERT2_FE_SLOT_NAME, (BValue)this.caCert2DropDownPane);
        } else if ("autheap=MSCHAPV2".equals(currentInnerAuthentication) || "auth=MSCHAPV2".equals(currentInnerAuthentication)) {
            this.mainPane.add(EAP_USERNAME_LABEL_SLOT_NAME, (BValue)this.eapUsernameFEPaneLabel);
            this.mainPane.add(EAP_USERNAME_FE_SLOT_NAME, (BValue)this.eapIdentityFEPane);
            this.mainPane.add(EAP_PASSPHRASE_LABEL_SLOT_NAME, (BValue)this.eapPassphraseFEPaneLabel);
            this.mainPane.add(EAP_PASSPHRASE_FE_SLOT_NAME, (BValue)this.eapPassphraseFEPane);
        }
        this.unlockModifiedState();
    }

    public BIEEE8021XAdapterSettings getAdapterSettings() {
        return (BIEEE8021XAdapterSettings)this.getCurrentValue();
    }

    private static void saveError(String messageTag) throws CannotSaveException {
        LOG.log(Level.SEVERE, () -> "Failed to save IEEE8021X Adapter Settings Editor (" + messageTag + ")");
        throw new CannotSaveException(LEXICON.getText(messageTag, null));
    }

    private static BGridPane makeDefaultGridPane() {
        BGridPane pane = new BGridPane(2);
        pane.setColumnAlign(BHalign.fill);
        pane.setValign(BValign.top);
        pane.setHalign(BHalign.left);
        pane.setColumnGap(10.0);
        pane.setRowGap(6.0);
        pane.setColorRows(false);
        return pane;
    }

    private void unsetIfAbsent(String slotName) {
        if (this.mainPane == null) {
            return;
        }
        if (!this.editorPresent(slotName)) {
            BWidget fieldEditor = this.fieldEditorsBySlot.get(slotName);
            if (fieldEditor instanceof BListDropDown) {
                ((BListDropDown)fieldEditor).setSelectedIndex(0);
            } else if (fieldEditor instanceof BStringFE) {
                ((BStringFE)fieldEditor).loadValue((BObject)BString.DEFAULT);
            } else if (fieldEditor instanceof BPasswordFE) {
                ((BPasswordFE)fieldEditor).loadValue((BObject)BPassword.DEFAULT);
            }
        }
    }

    private boolean editorPresent(String slotName) {
        if (this.mainPane == null) {
            return false;
        }
        return this.mainPane.getProperty(slotName) != null;
    }

    private static BGridPane left(BWidget content) {
        BGridPane result = new BGridPane(1);
        result.setHalign(BHalign.left);
        result.setColumnAlign(BHalign.left);
        result.add(null, (BValue)content);
        return result;
    }

    public static String phase1StringToModel(String phase1String) {
        if ("peapver=0".equals(phase1String)) {
            return "Version 0";
        }
        if ("".equals(phase1String)) {
            return IEEE8021XUtil.NO_OPTIONS;
        }
        return phase1String;
    }

    public static String phase1ModelToString(String phase1Model) {
        if ("Version 0".equals(phase1Model)) {
            return "peapver=0";
        }
        if (IEEE8021XUtil.NO_OPTIONS.equals(phase1Model)) {
            return "";
        }
        return phase1Model;
    }

    public static String phase2StringToModel(String phase2String) {
        if ("autheap=TLS".equals(phase2String)) {
            return "TLS";
        }
        if ("auth=MSCHAPV2".equals(phase2String)) {
            return "MSCHAPv2";
        }
        if ("autheap=MSCHAPV2".equals(phase2String)) {
            return "EAP-MSCHAPv2";
        }
        if ("".equals(phase2String)) {
            return IEEE8021XUtil.NO_OPTIONS;
        }
        return phase2String;
    }

    public static String phase2ModelToString(String phase2Model) {
        if ("TLS".equals(phase2Model)) {
            return "autheap=TLS";
        }
        if ("MSCHAPv2".equals(phase2Model)) {
            return "auth=MSCHAPV2";
        }
        if ("EAP-MSCHAPv2".equals(phase2Model)) {
            return "autheap=MSCHAPV2";
        }
        if (IEEE8021XUtil.NO_OPTIONS.equals(phase2Model)) {
            return "";
        }
        return phase2Model;
    }

    static BPassword passphraseToPassphrase(BPassword passphraseValue) {
        if (passphraseValue == null || passphraseValue == BPassword.DEFAULT || passphraseValue.isDefault() || passphraseValue.equals((Object)BPassword.DEFAULT) || passphraseValue.getValue().isEmpty()) {
            return BPassword.DEFAULT;
        }
        return passphraseValue;
    }

    private final class ViewCertificateCommand
    extends Command {
        private final BListDropDown dropDown;

        public ViewCertificateCommand(BListDropDown dropDown) {
            super((BWidget)BIEEE8021XAdapterSettingsEditor.this, TYPE.getModule(), "IEEE8021XAdapterSettingsEditor.command.viewCert");
            this.dropDown = dropDown;
        }

        public CommandArtifact doInvoke() {
            try {
                TrustStoreCertInfo selected;
                if (this.dropDown.getList().getModel() instanceof KeyStoreModel) {
                    KeyStoreCertInfo selected2 = (KeyStoreCertInfo)this.dropDown.getSelectedItem();
                    if (selected2 != KeyStoreCertInfo.BLANK_KEY_CERTIFICATE) {
                        BCertEntryViewDialog.show((BWidget)this.getOwner(), (IX509CertificateEntry)selected2.cert());
                    }
                } else if (this.dropDown.getList().getModel() instanceof TrustStoreModel && (selected = (TrustStoreCertInfo)this.dropDown.getSelectedItem()) != TrustStoreCertInfo.BLANK_CA_CERTIFICATE) {
                    BCertEntryViewDialog.show((BWidget)this.getOwner(), (IX509CertificateEntry)selected.cert());
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to view certificate", e);
            }
            return null;
        }
    }

    private final class ViewAllStatusesCommand
    extends Command {
        private final BTextOutputPane allStatusesTextPane;

        public ViewAllStatusesCommand(BTextOutputPane allStatusesTextPane) {
            super((BWidget)BIEEE8021XAdapterSettingsEditor.this, TYPE.getModule(), "IEEE8021XAdapterSettingsEditor.command.viewAllStatuses");
            this.allStatusesTextPane = allStatusesTextPane;
        }

        public CommandArtifact doInvoke() {
            try {
                if (!this.allStatusesTextPane.getText().isEmpty()) {
                    BDialog.open((BWidget)BIEEE8021XAdapterSettingsEditor.this, (String)LEXICON.get("IEEE8021XAdapterSettingsEditor.ieee8021XStatus.label", null), (Object)this.allStatusesTextPane, (int)1);
                }
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Failed to view all statuses", e);
            }
            return null;
        }
    }

    private static class KeyStoreModel
    extends ListModel {
        private final ArrayList<KeyStoreCertInfo> items = new ArrayList();

        public KeyStoreModel(KeyStoreCertInfo[] keyInfo) {
            for (KeyStoreCertInfo aKeyInfo : keyInfo) {
                if (aKeyInfo.alias() == null) continue;
                this.items.add(aKeyInfo);
            }
            this.items.sort(KeyStoreCertInfo.KEY_STORE_CERT_INFO_COMPARATOR);
            this.items.add(0, KeyStoreCertInfo.BLANK_KEY_CERTIFICATE);
        }

        public void select(String alias) {
            this.getSelection().deselectAll();
            if (alias == null || alias.isEmpty()) {
                this.getSelection().select(0);
                return;
            }
            for (int i = 1; i < this.getItemCount(); ++i) {
                if (!this.keyInfo(i).alias().equals(alias)) continue;
                this.getSelection().select(i);
                return;
            }
            LOG.log(Level.WARNING, () -> "KeyStoreModel could not select provided alias '" + alias + "', alias not in key store");
        }

        public String getSelectedAlias() {
            int ix = this.getSelection().getLead();
            if (ix <= 0) {
                return "";
            }
            return this.keyInfo(ix).alias();
        }

        public KeyStoreCertInfo keyInfo(int index) {
            return this.items.get(index);
        }

        public Object getItem(int index) {
            if (index <= 0) {
                return KeyStoreCertInfo.BLANK_KEY_CERTIFICATE;
            }
            return this.keyInfo(index);
        }

        public BImage getItemIcon(int index) {
            if (index <= 0) {
                return null;
            }
            if (this.keyInfo(index).dateInvalid()) {
                return SECURITY_ICON_LOW;
            }
            if (this.keyInfo(index).selfSigned()) {
                return SECURITY_ICON_MEDIUM;
            }
            return SECURITY_ICON_HIGH;
        }

        public int getItemCount() {
            return this.items.size();
        }
    }

    private static final class TrustStoreModel
    extends ListModel {
        private final ArrayList<TrustStoreCertInfo> items = new ArrayList();

        public TrustStoreModel(TrustStoreCertInfo[] caInfo) {
            for (TrustStoreCertInfo aCaInfo : caInfo) {
                if (aCaInfo.alias() == null) continue;
                this.items.add(aCaInfo);
            }
            this.items.sort(TrustStoreCertInfo.TRUST_STORE_CERT_INFO_COMPARATOR);
            this.items.add(0, TrustStoreCertInfo.BLANK_CA_CERTIFICATE);
        }

        public void select(String alias) {
            this.getSelection().deselectAll();
            if (alias == null || alias.isEmpty()) {
                this.getSelection().select(0);
                return;
            }
            for (int i = 1; i < this.getItemCount(); ++i) {
                if (!this.caCertInfo(i).alias().equals(alias)) continue;
                this.getSelection().select(i);
                return;
            }
            LOG.log(Level.WARNING, () -> "TrustStoreModel could not select provided alias '" + alias + "', alias not in trust store");
        }

        public String getSelectedAlias() {
            int ix = this.getSelection().getLead();
            if (ix <= 0) {
                return "";
            }
            return this.caCertInfo(ix).alias();
        }

        public TrustStoreCertInfo caCertInfo(int index) {
            return this.items.get(index);
        }

        public Object getItem(int index) {
            if (index <= 0) {
                return TrustStoreCertInfo.BLANK_CA_CERTIFICATE;
            }
            return this.caCertInfo(index);
        }

        public BImage getItemIcon(int index) {
            if (index <= 0) {
                return null;
            }
            if (this.caCertInfo(index).dateInvalid()) {
                return SECURITY_ICON_LOW;
            }
            return SECURITY_ICON_HIGH;
        }

        public int getItemCount() {
            return this.items.size();
        }
    }

    private static final class TunnelModel
    extends ListModel {
        private final ArrayList<String> items = new ArrayList();

        public TunnelModel(String[] tunnelOptions) {
            for (String tunnelOption : tunnelOptions) {
                if (tunnelOption == null) continue;
                this.items.add(tunnelOption);
            }
        }

        public String tunnelInfo(int index) {
            return this.items.get(index);
        }

        public Object getItem(int index) {
            return this.tunnelInfo(index);
        }

        public int getItemCount() {
            return this.items.size();
        }
    }
}

