/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm;

import com.tridium.ndriver.util.LinkedQueue;

public abstract class LinkedProcessor
implements Runnable {
    LinkedQueue rcvQueue = new LinkedQueue();
    Thread processThread = null;
    boolean done = false;

    public void start(String threadName) {
        if (this.processThread != null) {
            return;
        }
        this.done = false;
        this.processThread = new Thread((Runnable)this, threadName);
        this.processThread.start();
    }

    public void stop() {
        this.done = true;
        if (this.processThread != null) {
            this.processThread.interrupt();
        }
        this.processThread = null;
        this.rcvQueue.clear();
    }

    @Override
    public void run() {
        while (!this.done) {
            try {
                LinkedQueue.ILinkable newMsg = this.rcvQueue.dequeue();
                if (newMsg == null) continue;
                this.process(newMsg);
            }
            catch (Throwable throwable) {}
        }
    }

    public void enqueue(LinkedQueue.ILinkable lmsg) {
        this.rcvQueue.enqueue(lmsg);
    }

    public abstract void process(Object var1);
}

