/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.comm;

import com.tridium.ndriver.comm.LinkMessage;

public class NLinkMessageFactory {
    private Pool pool;
    protected int linkMaxLength;

    public NLinkMessageFactory(int linkMaxLength) {
        this(32, linkMaxLength);
    }

    public NLinkMessageFactory(int maxPool, int linkMaxLength) {
        this.pool = new Pool(maxPool);
        this.linkMaxLength = linkMaxLength;
    }

    public final LinkMessage getLinkMessage() {
        LinkMessage lm = this.pool.getPoolMessage();
        return lm;
    }

    public final void releaseLinkMessage(LinkMessage lm) {
        this.pool.releasePoolMessage(lm);
    }

    protected LinkMessage createLinkMessage() {
        return new LinkMessage(this.linkMaxLength);
    }

    public int getLinkMaxLength() {
        return this.linkMaxLength;
    }

    class Pool {
        private LinkMessage[] appPool;
        private int appCnt = 0;

        public Pool(int maxPool) {
            this.appPool = new LinkMessage[maxPool];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LinkMessage getPoolMessage() {
            LinkMessage[] linkMessageArray = this.appPool;
            synchronized (this.appPool) {
                LinkMessage lm = this.appCnt > 0 ? this.appPool[--this.appCnt] : NLinkMessageFactory.this.createLinkMessage();
                lm.init();
                lm.freeBuf = false;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return lm;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void releasePoolMessage(LinkMessage lm) {
            LinkMessage[] linkMessageArray = this.appPool;
            synchronized (this.appPool) {
                while (lm != null) {
                    if (lm.freeBuf) {
                        System.out.println("already free ");
                        Thread.dumpStack();
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return;
                    }
                    if (this.appCnt < this.appPool.length) {
                        this.appPool[this.appCnt++] = lm;
                    }
                    lm.freeBuf = true;
                    lm = (LinkMessage)lm.getNext();
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

