/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.ndriver.util;

import java.io.InputStream;
import javax.baja.sys.BajaRuntimeException;

public class TByteArrayInputStream
extends InputStream {
    byte[] buf;
    int count;
    int mark = 0;
    int pos = 0;

    public TByteArrayInputStream() {
        throw new BajaRuntimeException("Must supply byte array");
    }

    public TByteArrayInputStream(byte[] buf, int pos, int cnt) {
        this.buf = buf;
        this.pos = pos;
        this.count = cnt;
    }

    public TByteArrayInputStream(byte[] buf) {
        this.buf = buf;
        this.count = buf.length;
    }

    @Override
    public synchronized int available() {
        return this.count - this.pos;
    }

    public void mark() {
        this.mark = this.pos;
    }

    @Override
    public void mark(int markpos) {
        if (markpos >= this.count) {
            return;
        }
        this.mark = markpos;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized int read() {
        if (this.pos >= this.count) {
            throw new BajaRuntimeException("end of buf encountered");
        }
        return this.buf[this.pos++];
    }

    public synchronized int peek() {
        if (this.pos >= this.count) {
            throw new BajaRuntimeException("end of buf encountered");
        }
        return this.buf[this.pos];
    }

    @Override
    public synchronized void reset() {
        this.pos = this.mark;
    }

    public synchronized int getPosition() {
        return this.pos;
    }

    public byte[] copyBuffer() {
        byte[] a = new byte[this.buf.length];
        System.arraycopy(this.buf, 0, a, 0, this.buf.length);
        return a;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    public int peekFinal() {
        return this.buf[this.count - 1];
    }
}

