/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.awt.ImageAnimator;
import java.awt.Image;
import java.security.AccessController;
import javax.baja.sys.Clock;

class GifAnimator
implements ImageAnimator {
    Frame[] frames;
    double loopCount;
    double duration;
    private long firstDrawnTicks;
    private int currentFrame;
    private int lastFrame;
    private long lastFrameChange = 0L;
    private static long animateDelay = AccessController.doPrivileged(() -> Long.getLong("bajaui.animateDelay", 100L));

    GifAnimator() {
    }

    @Override
    public Image getAnimatedImage() {
        return this.frames[this.currentFrame].image;
    }

    @Override
    public boolean animate() {
        if (this.frames == null || this.frames.length == 1) {
            return false;
        }
        double age = Clock.ticks() - this.firstDrawnTicks;
        if (this.firstDrawnTicks == 0L) {
            this.firstDrawnTicks = Clock.ticks();
            age = 0.0;
        }
        if (this.loopCount != 0.0 && Math.floor(age / this.duration) > this.loopCount) {
            this.currentFrame = this.frames.length - 1;
        } else {
            double remainder = age % this.duration;
            for (int i = 0; i < this.currentFrame; ++i) {
                remainder -= (double)this.frames[i].delay;
            }
            if (remainder > (double)this.frames[this.currentFrame].delay || remainder < 0.0) {
                this.currentFrame = (this.currentFrame + 1) % this.frames.length;
            }
        }
        if (this.currentFrame != this.lastFrame) {
            this.lastFrame = this.currentFrame;
            this.lastFrameChange = Clock.ticks();
            return true;
        }
        return Clock.ticks() - this.lastFrameChange < animateDelay * 2L || this.lastFrameChange == 0L;
    }

    static class Frame {
        Image image;
        int delay;

        Frame() {
        }
    }
}

