/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.GxEnv;
import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.ImageAnimator;
import java.awt.Graphics2D;
import java.awt.Image;
import javax.baja.file.BIFile;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrdList;
import javax.baja.sys.BAbsTime;

public class ImageData {
    Image image;
    ImageAnimator animator;
    BOrdList ordList;
    String cacheKey;
    long lastUsedTicks;
    BIFile file;
    BAbsTime fileTime;
    int fileSize;
    boolean loaded;
    public boolean repaintOnLoad;
    BTransform.Scale scale;

    ImageData(Image image) {
        this.image = image;
        this.loaded = image != null;
    }

    public Image getImage() {
        return this.image;
    }

    public Graphics getGraphics() {
        return ((AwtEnv)AwtEnv.get()).makeGraphics((Graphics2D)this.image.getGraphics());
    }

    public double getWidth() {
        return this.image == null ? 0.0 : (double)this.image.getWidth(null);
    }

    public double getHeight() {
        return this.image == null ? 0.0 : (double)this.image.getHeight(null);
    }

    public void dispose() {
        if (this.cacheKey != null) {
            return;
        }
        if (this.image != null) {
            this.image.flush();
            this.image = null;
        }
    }

    void setFile(BIFile file, int fileSize) {
        if (this.file == null) {
            this.file = file;
            this.fileTime = file.getLastModified();
        }
        this.fileSize += fileSize;
    }

    boolean hasFileBeenModified() {
        if (this.file == null) {
            return false;
        }
        return !this.file.getLastModified().equals((Object)this.fileTime);
    }

    synchronized void loaded() {
        this.loaded = true;
        this.notifyAll();
        if (this.repaintOnLoad) {
            this.repaintOnLoad = false;
            GxEnv.get().repaintAll();
        }
    }

    boolean trim(long now) {
        return this.fileSize > 10240 && now - this.lastUsedTicks > 900000L;
    }

    Image getAnimatedImage() {
        if (this.animator == null) {
            return this.image;
        }
        return this.animator.getAnimatedImage();
    }

    boolean animate() {
        if (this.animator == null) {
            return false;
        }
        return this.animator.animate();
    }
}

