/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt;

import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.AwtGraphics;
import com.tridium.gx.awt.BImageDecoder;
import com.tridium.gx.awt.GifDecoder;
import com.tridium.gx.awt.ImageData;
import com.tridium.sys.Nre;
import com.tridium.sys.spy.CacheSpy;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Comparator;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentList;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.util.SortUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;
import javax.baja.sys.ModuleNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Queue;

public class ImageManager {
    static final int TRIM_SIZE = 10240;
    static final long TRIM_AGE = 900000L;
    private static Logger log = Logger.getLogger("gx.image");
    private static HashMap<String, ImageData> cache = new HashMap();
    private static Queue queue = new Queue();
    private static final Thread thread;
    private static String activeTheme;
    private static MediaTracker tracker;

    public static synchronized ImageData fetchImageData(BImage image) {
        return ImageManager.fetchImageData(image, null);
    }

    public static synchronized ImageData fetchImageData(BImage image, BTransform.Scale scale) {
        ImageData data;
        BOrdList ordList = image.getAbsoluteOrdList();
        String key = ordList.encodeToString();
        if (scale != null) {
            key = key + "{" + scale.getX() + "," + scale.getY() + "}";
        }
        if ((data = cache.get(key)) != null) {
            if (data.hasFileBeenModified()) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine("out of date: " + key);
                }
                cache.remove(key);
            } else {
                data.lastUsedTicks = Clock.ticks();
                return data;
            }
        }
        data = new ImageData(null);
        data.ordList = ordList;
        data.cacheKey = key;
        data.lastUsedTicks = Clock.ticks();
        data.scale = scale;
        if (log.isLoggable(Level.FINE)) {
            log.fine("caching: " + key);
        }
        cache.put(key, data);
        if (key.startsWith("module://") || key.startsWith("local:|module://")) {
            if (log.isLoggable(Level.FINE)) {
                log.fine("load sync: " + key);
            }
            ImageManager.load(data);
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine("load async: " + key);
            }
            queue.enqueue((Object)data);
        }
        return data;
    }

    public static void trimAll() {
        log.warning("Entire cache cleared");
        cache = new HashMap();
    }

    public static Image sync(Image image) {
        try {
            AccessController.doPrivileged(new SyncPrivilegedAction(image));
        }
        catch (PrivilegedActionException e) {
            throw (IllegalStateException)e.getException();
        }
        return image;
    }

    public static void setActiveTheme(String activeTheme) {
        ImageManager.activeTheme = activeTheme;
        IconManager.updateModuleBase();
    }

    public static Image rescaleImage(Image image, BTransform.Scale scale) {
        int width = image.getWidth(null);
        int height = image.getHeight(null);
        if (width == 0 || height == 0) {
            return image;
        }
        AwtEnv env = (AwtEnv)AwtEnv.get();
        Image rescaled = env.makeBufferedImage((double)width * scale.getX(), (double)height * scale.getY());
        Graphics g = env.makeGraphics((Graphics2D)rescaled.getGraphics());
        Graphics2D g2d = ((AwtGraphics)g).getAwtGraphics();
        AwtEnv.makeHighQuality(g2d);
        g.transform(BTransform.make((BTransform.Transform)scale));
        g2d.drawImage(image, 0, 0, null);
        return rescaled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(ImageData data) {
        try {
            BOrdList list = data.ordList;
            if (list.size() == 0) {
                return;
            }
            ImageManager.loadFile(data, list.get(0));
            if (list.size() == 1) {
                return;
            }
            double w = data.getWidth();
            double h = data.getHeight();
            if (data.scale != null) {
                w *= data.scale.getX();
                h *= data.scale.getY();
            }
            Image composite = ((AwtEnv)AwtEnv.get()).makeBufferedImage(w, h);
            composite.getGraphics().drawImage(data.image, 0, 0, null);
            for (int i = 1; i < list.size(); ++i) {
                ImageManager.loadFile(data, list.get(i));
                composite.getGraphics().drawImage(data.image, 0, 0, null);
            }
            data.image = composite;
        }
        finally {
            data.loaded();
        }
    }

    private static void loadFile(ImageData data, BOrd ord) {
        if (ord.isNull()) {
            return;
        }
        try {
            ord = IconManager.getExistingOrd(ord.toString());
            BIFile file = (BIFile)ord.resolve((BObject)BLocalHost.INSTANCE).get();
            byte[] buf = file.read();
            data.setFile(file, buf.length);
            AgentList agents = ((BObject)file).getAgents().filter(AgentFilter.is((Type)BImageDecoder.TYPE));
            if (agents.size() > 0) {
                BImageDecoder decoder = (BImageDecoder)agents.getDefault().getInstance();
                decoder.decode(ord, buf, data.scale);
                data.image = decoder.getImage();
                data.animator = decoder.getAnimator();
            } else {
                ImageManager.decode(data, buf);
            }
        }
        catch (UnresolvedException e) {
            log.severe("Cannot resolve image \"" + ord + "\"");
        }
        catch (Throwable e) {
            log.log(Level.SEVERE, "Cannot load image \"" + ord + "\"", e);
        }
    }

    private static void decode(ImageData data, byte[] buf) throws Exception {
        if (buf[0] == 71 && buf[1] == 73 && buf[2] == 70) {
            GifDecoder decoder = new GifDecoder();
            decoder.decode(buf, data.scale);
            data.image = decoder.getImage();
            data.animator = decoder.getAnimator();
        } else {
            Image image = Toolkit.getDefaultToolkit().createImage(buf);
            ImageManager.sync(image);
            data.image = data.scale == null ? image : ImageManager.rescaleImage(image, data.scale);
        }
    }

    static synchronized void trim() {
        log.fine("trim");
        long now = Clock.ticks();
        ImageData[] datas = cache.values().toArray(new ImageData[0]);
        for (int i = 0; i < datas.length; ++i) {
            ImageData data = datas[i];
            if (!data.trim(now)) continue;
            if (log.isLoggable(Level.FINE)) {
                log.fine("  trim: " + data.cacheKey);
            }
            cache.remove(data.cacheKey);
        }
    }

    static {
        activeTheme = "";
        tracker = new MediaTracker(new Component(){
            private static final long serialVersionUID = 6209986508048992178L;
        });
        thread = new ImageManagerThread();
        thread.start();
        Spy.ROOT.add("imageManager", (Spy)new ImageManagerSpy());
    }

    public static class IconManager {
        private static String moduleBase;
        private static final String DEFAULT_MODULE_BASE = "module://";
        private static Logger logger;

        private static void updateModuleBase() {
            String theme = activeTheme;
            moduleBase = DEFAULT_MODULE_BASE;
            if (theme != null && theme.trim().length() > 0) {
                try {
                    Sys.loadModule((String)theme);
                    moduleBase = DEFAULT_MODULE_BASE + theme + "/imageOverrides/";
                }
                catch (ModuleNotFoundException e) {
                    logger.severe("bajaui.activeTheme '" + theme + "' could not be loaded");
                }
            }
        }

        public static BOrd getExistingOrd(String imagePath) {
            if (imagePath.startsWith(DEFAULT_MODULE_BASE)) {
                String newImagePath = moduleBase + imagePath.substring(9);
                BOrd ord = IconManager.makeOrd(newImagePath);
                if (ord != null) {
                    return ord;
                }
                ord = IconManager.makeOrd(imagePath);
                if (ord == null) {
                    logger.severe("icon '" + imagePath + "' could not be found either in active theme module or in icons module.");
                    return BOrd.make((String)"module://icons/x16/error.png");
                }
                return ord;
            }
            return BOrd.make((String)imagePath);
        }

        private static BOrd makeOrd(String path) {
            try {
                BOrd ord = BOrd.make((String)path);
                ord.get();
                return ord;
            }
            catch (Exception e) {
                return null;
            }
        }

        static {
            logger = Logger.getLogger("com.tridium.gx.awt");
            IconManager.updateModuleBase();
        }
    }

    static class ImageManagerSpy
    extends SpyByKey {
        ImageManagerSpy() {
            this.add("bySize", (Spy)new SpyBySize());
            this.add("byLastUsed", (Spy)new SpyByLastUsed());
        }
    }

    static class SpyByLastUsed
    extends AbstractSpy {
        SpyByLastUsed() {
        }

        @Override
        public int compare(ImageData a, ImageData b) {
            long aticks = a.lastUsedTicks;
            long bticks = b.lastUsedTicks;
            if (aticks < bticks) {
                return -1;
            }
            return 1;
        }
    }

    static class SpyBySize
    extends AbstractSpy {
        SpyBySize() {
        }

        @Override
        public int compare(ImageData a, ImageData b) {
            int asize = a.fileSize;
            int bsize = b.fileSize;
            if (asize < bsize) {
                return 1;
            }
            if (asize == bsize) {
                return 0;
            }
            return -1;
        }
    }

    static class SpyByKey
    extends AbstractSpy {
        SpyByKey() {
        }

        @Override
        public int compare(ImageData a, ImageData b) {
            return SortUtil.compare((Object)a.cacheKey, (Object)b.cacheKey);
        }
    }

    static abstract class AbstractSpy
    extends CacheSpy
    implements Comparator<ImageData> {
        AbstractSpy() {
            super("Image Manager", "/imageManager");
        }

        public void clearCache() {
            ImageManager.trimAll();
        }

        public void write(SpyWriter out) throws Exception {
            super.write(out);
            Object[] datas = cache.values().toArray(new ImageData[0]);
            SortUtil.sort((Object[])datas, (Object[])datas, (Comparator)this);
            out.startTable(true);
            out.trTitle((Object)("Image Cache [" + datas.length + "]"), 3);
            out.tr().th().w((Object)"<b>").a("/imageManager", (Object)"Image").w((Object)"</b>").endTh().th().w((Object)"<b>").a("/imageManager/bySize", (Object)"Size").w((Object)"</b>").endTh().th().w((Object)"<b>").a("/imageManager/byLastUsed", (Object)"Last Used").w((Object)"</b>").endTh().endTr();
            for (int i = 0; i < datas.length; ++i) {
                Object data = datas[i];
                String size = ((ImageData)data).fileSize / 1024 + "kb";
                String lastUsed = BRelTime.toString((long)(Clock.ticks() - ((ImageData)data).lastUsedTicks));
                out.tr((Object)((ImageData)data).cacheKey, (Object)size, (Object)lastUsed);
            }
            out.endTable();
        }
    }

    static class ImageManagerThread
    extends Thread {
        ImageManagerThread() {
            super(Nre.mainThreadGroup, "Ui:ImageManager");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            long lastTrim = Clock.ticks();
            while (true) {
                try {
                    while (true) {
                        ImageData data;
                        block8: {
                            block9: {
                                block7: {
                                    if ((data = (ImageData)queue.dequeue()) != null) break block7;
                                    if (Clock.ticks() - lastTrim <= 60000L) break block8;
                                    break block9;
                                }
                                if (log.isLoggable(Level.FINE)) {
                                    log.fine("  loading: " + data.cacheKey);
                                }
                                ImageManager.load(data);
                                if (!log.isLoggable(Level.FINE)) continue;
                                log.fine("       ok: " + data.cacheKey + " -> " + data.getWidth() + "," + data.getHeight());
                                continue;
                            }
                            lastTrim = Clock.ticks();
                            ImageManager.trim();
                        }
                        data = queue;
                        synchronized (data) {
                            queue.wait(10000L);
                        }
                    }
                }
                catch (Throwable e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    private static class SyncPrivilegedAction
    implements PrivilegedExceptionAction<Object> {
        private Image image;

        private SyncPrivilegedAction(Image image) {
            this.image = image;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object run() throws IllegalStateException {
            MediaTracker mediaTracker = tracker;
            synchronized (mediaTracker) {
                try {
                    tracker.addImage(this.image, 0);
                    tracker.waitForID(0, 0L);
                    tracker.removeImage(this.image, 0);
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e.toString());
                }
            }
            return null;
        }
    }
}

