/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.gx.awt.se;

import com.tridium.gx.GraphPaper;
import com.tridium.gx.awt.AwtGraphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import javax.baja.gx.BColor;
import javax.baja.gx.Graphics;

public class AwtGraphPaper
implements GraphPaper,
Paint,
PaintContext {
    private static final ColorModel COLOR_MODEL = ColorModel.getRGBdefault();
    private int size;
    private int[] pixel = new int[4];
    private AffineTransform xform;
    private int width = 0;
    private int height = 0;
    private WritableRaster raster;
    private Raster blank;

    public void fillRect(Graphics g, double x, double y, double width, double height) {
        Graphics2D g2 = ((AwtGraphics)g).getAwtGraphics();
        g2.setPaint(this);
        g2.fillRect((int)x, (int)y, (int)width, (int)height);
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void setColor(BColor color) {
        this.pixel[0] = color.getRed();
        this.pixel[1] = color.getGreen();
        this.pixel[2] = color.getBlue();
        this.pixel[3] = color.getAlpha();
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        this.xform = xform;
        return this;
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return COLOR_MODEL;
    }

    @Override
    public Raster getRaster(int x, int y, int w, int h) {
        if (w > this.width || h > this.height) {
            this.width = w;
            this.height = h;
            this.raster = COLOR_MODEL.createCompatibleWritableRaster(this.width, this.height);
            this.blank = COLOR_MODEL.createCompatibleWritableRaster(this.width, this.height);
        } else {
            this.raster.setDataElements(0, 0, this.blank);
        }
        double vsize = (double)this.size * this.xform.getScaleX();
        double n = ((double)x - this.xform.getTranslateX()) % vsize;
        if (n == 0.0) {
            n = vsize;
        }
        for (double aa = vsize - n; aa < (double)w; aa += vsize) {
            for (int b = 0; b < h; ++b) {
                this.raster.setPixel((int)aa, b, this.pixel);
            }
        }
        double hsize = (double)this.size * this.xform.getScaleY();
        n = ((double)y - this.xform.getTranslateY()) % hsize;
        if (n == 0.0) {
            n = hsize;
        }
        for (double bb = hsize - n; bb < (double)h; bb += hsize) {
            for (int a = 0; a < w; ++a) {
                this.raster.setPixel(a, (int)bb, this.pixel);
            }
        }
        return this.raster;
    }
}

