/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.addresses;

import com.tridiumX.knxnetIp.addresses.BGroupAddress;
import com.tridiumX.knxnetIp.addresses.BIndividualDeviceAddress;
import com.tridiumX.knxnetIp.addresses.BKnxAddress;
import com.tridiumX.knxnetIp.addresses.BKnxAddressStyleEnum;
import com.tridiumX.knxnetIp.addresses.IKnxAddress;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BStruct;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="addressStyleName", type="String", defaultValue="KnxStrings.EMPTY_STRING")
public final class BKnxAddressStyle
extends BStruct {
    public static final Property addressStyleName = BKnxAddressStyle.newProperty((int)0, (String)"", null);
    public static final Type TYPE = Sys.loadType(BKnxAddressStyle.class);
    private BKnxAddressStyleEnum addressStyle = BKnxAddressStyleEnum.DEFAULT;
    private char m_cSeparator = (char)32;
    private int m_iTotalBits;
    private int m_iRadix = 10;
    private byte[] m_abFieldLengths = EMPTY_BYTES;
    public static final int K_MIN_ADDRESS_BITS = 15;
    public static final int K_MAX_ADDRESS_BITS = 16;
    public static final int K_SIZE_OF_INT = 16;
    private static final byte[] EMPTY_BYTES = new byte[0];
    private static final byte[] abIndividualDeviceFieldLengths = new byte[]{4, 4, 8};
    public static final BKnxAddressStyle kasIndividualDevice = BKnxAddressStyle.make_NoChecks(BKnxAddressStyleEnum.individualDevice, "IndividualDeviceAddress", '.', 16, abIndividualDeviceFieldLengths);
    private static final byte[] ab2LevelGroupFieldLengths = new byte[]{5, 11};
    public static final BKnxAddressStyle kas2LevelGroup = BKnxAddressStyle.make_NoChecks(BKnxAddressStyleEnum.twoLevel, "TwoLevelGroupAddress", '/', 16, ab2LevelGroupFieldLengths);
    private static final byte[] ab3LevelGroupFieldLengths = new byte[]{5, 3, 8};
    public static final BKnxAddressStyle kas3LevelGroup = BKnxAddressStyle.make_NoChecks(BKnxAddressStyleEnum.threeLevel, "ThreeLevelGroupAddress", '/', 16, ab3LevelGroupFieldLengths);
    private static final byte[] abFreeGroupFieldLengths = new byte[]{16};
    public static final BKnxAddressStyle kasFreeGroup = BKnxAddressStyle.make_NoChecks(BKnxAddressStyleEnum.free, "FreeGroupAddress", ' ', 16, abFreeGroupFieldLengths);
    public static final BKnxAddressStyle[] ALL_GA_STYLES = new BKnxAddressStyle[]{kas3LevelGroup, kas2LevelGroup, kasFreeGroup};

    public String getAddressStyleName() {
        return this.getString(addressStyleName);
    }

    public void setAddressStyleName(String v) {
        this.setString(addressStyleName, v, null);
    }

    public Type getType() {
        return TYPE;
    }

    public static BKnxAddressStyle make(BKnxAddressStyleEnum addressStyle, String addressStyleName, char separator, int totalBits, byte[] fieldLengths) throws Exception {
        if (totalBits < 15 || totalBits > 16) {
            throw new Exception("BKnxAddressStyle totalBitsSize must be between 15 and 16.");
        }
        if (fieldLengths.length == 0) {
            throw new Exception("No 'fieldLengths' provided, a BKNXAddresType must have at least 1 'fieldLength'.");
        }
        if (fieldLengths.length > totalBits) {
            throw new Exception("Too many 'fieldLengths', a BKnxAddressStyle cannot have more 'fieldLengths' than 'totalBits'.");
        }
        int totalFieldsLength = 0;
        for (byte iFieldLength : fieldLengths) {
            if (iFieldLength <= 0) {
                throw new Exception("Zero length fields are not permitted.");
            }
            totalFieldsLength += iFieldLength;
        }
        if (totalFieldsLength > totalBits) {
            throw new Exception("The sum of the 'fieldLengths' cannot be more than 'totalBits'.");
        }
        return BKnxAddressStyle.make_NoChecks(addressStyle, addressStyleName, separator, totalBits, fieldLengths);
    }

    private static BKnxAddressStyle make_NoChecks(BKnxAddressStyleEnum addressStyle, String addressStyleName, char separator, int totalBits, byte[] fieldLengths) {
        return BKnxAddressStyle.make_NoChecks(addressStyle, addressStyleName, separator, totalBits, fieldLengths, 10);
    }

    private static BKnxAddressStyle make_NoChecks(BKnxAddressStyleEnum addressStyle, String addressStyleName, char separator, int totalBits, byte[] fieldLengths, int radix) {
        BKnxAddressStyle knxAddressStyle = new BKnxAddressStyle();
        knxAddressStyle.setAddressStyleName(addressStyleName);
        knxAddressStyle.addressStyle = addressStyle;
        knxAddressStyle.m_cSeparator = separator;
        knxAddressStyle.m_iTotalBits = totalBits;
        knxAddressStyle.m_abFieldLengths = fieldLengths;
        knxAddressStyle.m_iRadix = radix;
        return knxAddressStyle;
    }

    public String getFriendlyAddress(IKnxAddress address) {
        StringBuilder sb = new StringBuilder();
        int iAddress = address.getAddress();
        int iOffset = 0;
        iOffset = 16 - this.m_iTotalBits;
        for (int i = 0; i < this.m_abFieldLengths.length; ++i) {
            if (i > 0) {
                sb.append(this.m_cSeparator);
            }
            byte iFieldLength = this.m_abFieldLengths[i];
            int mask = (1 << iFieldLength) - 1;
            if (iFieldLength == 16) {
                mask = -1;
            }
            int iShift = 16 - (iOffset += iFieldLength);
            int fieldValue = iAddress >>> iShift & mask;
            if (this.m_iRadix == 10) {
                sb.append(fieldValue);
            }
            if (this.m_iRadix != 16) continue;
            sb.append(Integer.toHexString(fieldValue));
        }
        return sb.toString();
    }

    public IKnxAddress getFriendlyAddress(String address) {
        BKnxAddress result = null;
        if (address != null && this.m_iTotalBits > 0) {
            String[] sParts = TextUtil.splitAndTrim((String)address, (char)this.m_cSeparator);
            if (sParts.length == this.m_abFieldLengths.length) {
                int iAddress = 0;
                int iOffset = this.m_iTotalBits;
                for (int i = 0; i < this.m_abFieldLengths.length; ++i) {
                    byte iFieldLength = this.m_abFieldLengths[i];
                    int mask = (1 << iFieldLength) - 1;
                    if (iFieldLength == 16) {
                        mask = 65535;
                    }
                    int iPart = 0;
                    if (this.m_iRadix == 10) {
                        iPart = new Integer(sParts[i]);
                    }
                    if (this.m_iRadix == 16) {
                        iPart = Integer.parseInt(sParts[i], this.m_iRadix);
                    }
                    if (iPart < 0 || iPart > mask) {
                        throw new IllegalArgumentException("Part " + (i + 1) + " of 'address' (" + iPart + ") is out of range (0 to " + mask + ") for this 'AddressStyle'.");
                    }
                    iAddress += (iPart <<= (iOffset -= iFieldLength));
                }
                if (this.equals((Object)kasIndividualDevice)) {
                    result = new BIndividualDeviceAddress(iAddress);
                } else {
                    if (iAddress == 0) {
                        throw new IllegalArgumentException("Group Address " + address + " is reserved.");
                    }
                    result = new BGroupAddress(iAddress, this.addressStyle);
                }
            } else {
                throw new IllegalArgumentException("The number of parts in 'address' (" + sParts.length + ") does not match the number of parts defined for this 'AddressStyle' (" + this.m_abFieldLengths.length + ").");
            }
        }
        return result;
    }

    public char getSeparator() {
        return this.m_cSeparator;
    }

    public int getTotalBits() {
        return this.m_iTotalBits;
    }

    public int getRadix() {
        return this.m_iRadix;
    }

    public byte[] getFieldLengths() {
        return this.m_abFieldLengths;
    }

    public BKnxAddressStyleEnum getAddressStyle() {
        return this.addressStyle;
    }
}

