/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames;

import com.tridiumX.knxnetIp.comms.IHardwareAndServicesDIBs;
import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.frames.BKnxIpFrameTypeEnum;
import com.tridiumX.knxnetIp.comms.frames.EmptyKnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.KnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.parts.BDeviceInfoDIB;
import com.tridiumX.knxnetIp.comms.frames.parts.BSupportedServiceFamiliesDIB;
import java.io.IOException;
import java.util.logging.Level;

public final class CoreDescriptionResponse
extends KnxIpFrame
implements IHardwareAndServicesDIBs {
    private BDeviceInfoDIB deviceInfo;
    private BSupportedServiceFamiliesDIB supportedServices;

    public CoreDescriptionResponse() {
    }

    public CoreDescriptionResponse(EmptyKnxIpFrame inFrame) throws IOException {
        super(inFrame);
        this.fromStream(inFrame.inputStream);
    }

    public CoreDescriptionResponse(BDeviceInfoDIB deviceInfo, BSupportedServiceFamiliesDIB supportedServiceFamilies) {
        this.deviceInfo = deviceInfo;
        this.supportedServices = supportedServiceFamilies;
    }

    @Override
    protected BKnxIpFrameTypeEnum getKnxIpFrameType() {
        return BKnxIpFrameTypeEnum.coreDescriptionResponse;
    }

    @Override
    protected int getMinimumFrameLength() {
        return 62;
    }

    @Override
    protected void fromStream(KnxInputStream in) throws IOException {
        try {
            this.deviceInfo = BDeviceInfoDIB.make(in);
            this.supportedServices = BSupportedServiceFamiliesDIB.make(in);
        }
        catch (Exception ex) {
            if (CoreDescriptionResponse.getLogger().isLoggable(Level.FINEST)) {
                ex.printStackTrace();
            }
            throw new IOException(ex.toString());
        }
    }

    @Override
    protected void toStream(KnxOutputStream out) throws IOException {
        this.deviceInfo.toStream(out);
        this.supportedServices.toStream(out);
    }

    @Override
    protected void toLogString(StringBuffer sb) {
        sb.append("DeviceInfo DIB = ");
        this.deviceInfo.toLogString(sb);
        sb.append(", SupportedServices DIB = ");
        this.supportedServices.toLogString(sb);
    }

    @Override
    public BDeviceInfoDIB getDeviceInfoDIB() {
        return this.deviceInfo;
    }

    @Override
    public BSupportedServiceFamiliesDIB getSupportedServicesDIB() {
        return this.supportedServices;
    }
}

