/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames;

import com.tridiumX.knxnetIp.comms.IHardwareAndServicesDIBs;
import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.frames.BKnxIpFrameTypeEnum;
import com.tridiumX.knxnetIp.comms.frames.EmptyKnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.KnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.parts.BDeviceInfoDIB;
import com.tridiumX.knxnetIp.comms.frames.parts.BSupportedServiceFamiliesDIB;
import com.tridiumX.knxnetIp.comms.frames.parts.HostProtocolAddressInformation;
import java.io.IOException;
import java.net.InetAddress;
import java.util.logging.Level;

public final class CoreSearchResponse
extends KnxIpFrame
implements IHardwareAndServicesDIBs {
    private HostProtocolAddressInformation hpai;
    private BDeviceInfoDIB deviceInfo;
    private BSupportedServiceFamiliesDIB supportedServices;

    public CoreSearchResponse() {
    }

    public CoreSearchResponse(EmptyKnxIpFrame inFrame) throws IOException {
        super(inFrame);
        this.fromStream(inFrame.inputStream);
    }

    public CoreSearchResponse(InetAddress address, int port, BDeviceInfoDIB deviceInfo, BSupportedServiceFamiliesDIB supportedServiceFamilies) {
        this.hpai = new HostProtocolAddressInformation(address, port);
        this.deviceInfo = deviceInfo;
        this.supportedServices = supportedServiceFamilies;
    }

    @Override
    protected BKnxIpFrameTypeEnum getKnxIpFrameType() {
        return BKnxIpFrameTypeEnum.coreSearchResponse;
    }

    @Override
    protected int getMinimumFrameLength() {
        return 70;
    }

    @Override
    protected void fromStream(KnxInputStream in) throws IOException {
        try {
            this.hpai = new HostProtocolAddressInformation(in);
            this.deviceInfo = BDeviceInfoDIB.make(in);
            this.supportedServices = BSupportedServiceFamiliesDIB.make(in);
        }
        catch (Exception ex) {
            if (CoreSearchResponse.getLogger().isLoggable(Level.FINEST)) {
                ex.printStackTrace();
            }
            throw new IOException(ex.toString());
        }
    }

    @Override
    protected void toStream(KnxOutputStream out) throws IOException {
        if (this.hpai.getAddress() == null) {
            throw new IOException("HPAI address is null");
        }
        if (this.hpai.getPort() == -1) {
            throw new IOException("HPAI port == Constants.NO_IP_PORT_NUMBER (-1)");
        }
        this.hpai.toStream(out);
        this.deviceInfo.toStream(out);
        this.supportedServices.toStream(out);
    }

    @Override
    protected void toLogString(StringBuffer sb) {
        sb.append("HPAI = " + this.hpai.getLogString());
        sb.append(", DeviceInfo DIB = ");
        this.deviceInfo.toLogString(sb);
        sb.append(", SupportedServices DIB = ");
        this.supportedServices.toLogString(sb);
    }

    @Override
    public BDeviceInfoDIB getDeviceInfoDIB() {
        return this.deviceInfo;
    }

    @Override
    public BSupportedServiceFamiliesDIB getSupportedServicesDIB() {
        return this.supportedServices;
    }

    public HostProtocolAddressInformation getHpai() {
        return this.hpai;
    }
}

