/*
 * Decompiled with CFR 0.152.
 */
package com.tridiumX.knxnetIp.comms.frames;

import com.tridiumX.knxnetIp.comms.KnxInputStream;
import com.tridiumX.knxnetIp.comms.KnxOutputStream;
import com.tridiumX.knxnetIp.comms.frames.BKnxIpFrameTypeEnum;
import com.tridiumX.knxnetIp.comms.frames.EmptyKnxIpFrame;
import com.tridiumX.knxnetIp.comms.frames.KnxIpFrame;
import java.io.IOException;
import java.util.logging.Level;

public final class RoutingBusy
extends KnxIpFrame {
    private int deviceState;
    private int busyWaitTime;
    private int busyControlField;

    public RoutingBusy(EmptyKnxIpFrame inFrame) throws IOException {
        super(inFrame);
        this.fromStream(inFrame.inputStream);
    }

    public RoutingBusy(int deviceState, int busyWaitTime, int busyControlField) {
        this.deviceState = deviceState;
        this.busyWaitTime = busyWaitTime;
        this.busyControlField = busyControlField;
    }

    @Override
    protected BKnxIpFrameTypeEnum getKnxIpFrameType() {
        return BKnxIpFrameTypeEnum.routingBusy;
    }

    @Override
    protected int getMinimumFrameLength() {
        return 12;
    }

    @Override
    protected void fromStream(KnxInputStream in) throws IOException {
        try {
            if (in.read() != 6) {
                throw new IOException("incorrect structure length for 'Routing Busy Structure'");
            }
            this.deviceState = in.read();
            this.busyWaitTime = in.readInt();
            this.busyControlField = in.readInt();
        }
        catch (Exception ex) {
            if (RoutingBusy.getLogger().isLoggable(Level.FINEST)) {
                ex.printStackTrace();
            }
            throw new IOException(ex.toString());
        }
    }

    @Override
    protected void toStream(KnxOutputStream out) throws IOException {
        out.write(6);
        out.write(this.deviceState);
        out.writeInt(this.busyWaitTime);
        out.writeInt(this.busyControlField);
    }

    @Override
    protected void toLogString(StringBuffer sb) {
        sb.append("deviceState = " + this.deviceState);
        sb.append(", busyWaitTime = " + this.busyWaitTime);
        sb.append(", busyControlField = " + this.busyControlField);
    }

    public int getDeviceState() {
        return this.deviceState;
    }

    public int getBusyWaitTime() {
        return this.deviceState;
    }

    public int getBusyControlField() {
        return this.deviceState;
    }
}

